/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class TreasureLootModifier
extends LootModifier {
    public static final MapCodec<TreasureLootModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> TreasureLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ItemStack.CODEC.optionalFieldOf("item").forGetter(tlm -> tlm.drop), (App)Codec.INT.fieldOf("count").forGetter(tlm -> tlm.count), (App)Codec.DOUBLE.fieldOf("chance").forGetter(tlm -> tlm.chance), (App)Codec.BOOL.optionalFieldOf("per_level").forGetter(tlm -> Optional.of(tlm.perLevel)), (App)Codec.STRING.optionalFieldOf("skill").forGetter(tlm -> Optional.of(tlm.skill)))).apply((Applicative)instance, TreasureLootModifier::new));
    public Optional<ItemStack> drop;
    public final int count;
    public double chance;
    public boolean perLevel;
    public String skill;

    public TreasureLootModifier(LootItemCondition[] conditionsIn, Optional<ItemStack> lootItem, int count, double chance) {
        this(conditionsIn, lootItem, count, chance, Optional.of(false), Optional.empty());
    }

    public TreasureLootModifier(LootItemCondition[] conditionsIn, Optional<ItemStack> lootItem, int count, double chance, Optional<Boolean> perLevel, Optional<String> skill) {
        super(conditionsIn);
        this.chance = chance;
        this.drop = lootItem;
        if (this.drop.isPresent()) {
            this.drop.get().setCount(count);
        }
        this.count = count;
        this.perLevel = perLevel.orElse(false);
        this.skill = skill.orElse("");
    }

    public LootItemCondition[] getConditions() {
        return this.conditions;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Object object;
        if (!Config.server().general().treasureEnabled()) {
            return generatedLoot;
        }
        if (this.perLevel && (object = context.getParam(LootContextParams.THIS_ENTITY)) instanceof Player) {
            Player player = (Player)object;
            this.chance *= (double)Core.get(player.level()).getData().getLevel(this.skill, player.getUUID());
        }
        if (context.getRandom().nextDouble() <= this.chance) {
            Entity breaker;
            BlockState state = (BlockState)context.getParamOrNull(LootContextParams.BLOCK_STATE);
            if (state != null && this.drop.isEmpty()) {
                this.drop = Optional.of((ItemStack)state.getDrops(this.builderFromContext(context)).get(0));
                this.drop.get().setCount(this.count);
            }
            if ((breaker = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY)) instanceof Player) {
                Player player = (Player)breaker;
                player.sendSystemMessage((Component)LangProvider.FOUND_TREASURE.asComponent());
            }
            generatedLoot.add((Object)this.drop.get().copy());
        }
        return generatedLoot;
    }

    private LootParams.Builder builderFromContext(LootContext context) {
        return new LootParams.Builder(context.getLevel()).withParameter(LootContextParams.ORIGIN, (Object)((Vec3)context.getParam(LootContextParams.ORIGIN))).withParameter(LootContextParams.TOOL, (Object)((ItemStack)context.getParam(LootContextParams.TOOL)));
    }
}

