/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.setup.datagen;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import harmonised.pmmo.features.loot_modifiers.RareDropModifier;
import harmonised.pmmo.features.loot_modifiers.SkillLootConditionKill;
import harmonised.pmmo.features.loot_modifiers.SkillLootConditionPlayer;
import harmonised.pmmo.features.loot_modifiers.TreasureLootModifier;
import harmonised.pmmo.features.loot_modifiers.ValidBlockCondition;
import harmonised.pmmo.util.Reference;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.WithConditions;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public abstract class GLMProvider
implements DataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final PackOutput output;
    private final String modid = "pmmo";
    private final Map<String, WithConditions<IGlobalLootModifier>> toSerialize = new HashMap<String, WithConditions<IGlobalLootModifier>>();
    private final Path destination;
    CompletableFuture<HolderLookup.Provider> registries;

    public GLMProvider(PackOutput gen, Path destination, CompletableFuture<HolderLookup.Provider> registries) {
        this.output = gen;
        this.destination = destination;
        this.registries = registries;
    }

    protected abstract void start();

    public TreasureLootModifier of(TagKey<Block> validBlocks, Item drop, int count, double chance, String skill, int minLevel) {
        return new TreasureLootModifier(new LootItemCondition[]{new SkillLootConditionPlayer(minLevel, Integer.MAX_VALUE, skill), new ValidBlockCondition(validBlocks)}, Optional.of(drop.getDefaultInstance()), count, chance);
    }

    public TreasureLootModifier of(Block validBlocks, Item drop, int count, double chance, String skill, int minLevel) {
        return new TreasureLootModifier(new LootItemCondition[]{new SkillLootConditionPlayer(minLevel, Integer.MAX_VALUE, skill), new ValidBlockCondition(validBlocks)}, Optional.of(drop.getDefaultInstance()), count, chance);
    }

    public TreasureLootModifier extra(TagKey<Block> validBlocks, int count, double chance, String skill, int minLevel) {
        return new TreasureLootModifier(new LootItemCondition[]{new SkillLootConditionPlayer(minLevel, Integer.MAX_VALUE, skill), new ValidBlockCondition(validBlocks)}, Optional.empty(), count, chance);
    }

    public RareDropModifier fish(Item drop, int count, double chance, String skill, int minLevel, int maxLevel) {
        return new RareDropModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.FISHING.location()).build(), new SkillLootConditionKill(minLevel, maxLevel, skill)}, drop.getDefaultInstance(), count, chance);
    }

    public RareDropModifier fish(Item drop, int count, double chance, String skill, int minLevel) {
        return this.fish(drop, count, chance, skill, minLevel, Integer.MAX_VALUE);
    }

    public RareDropModifier mob(EntityType<?> mob, Item drop, int count, double chance, String skill, int minLevel, int maxLevel) {
        return new RareDropModifier(new LootItemCondition[]{LootItemKilledByPlayerCondition.killedByPlayer().build(), LootTableIdCondition.builder((ResourceLocation)mob.getDefaultLootTable().location()).build(), new SkillLootConditionKill(minLevel, maxLevel, skill)}, drop.getDefaultInstance(), count, chance);
    }

    public RareDropModifier mob(EntityType<?> mob, Item drop, int count, double chance, String skill, int minLevel) {
        return this.mob(mob, drop, count, chance, skill, minLevel, Integer.MAX_VALUE);
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        return this.registries.thenCompose(registries -> this.run(cache, (HolderLookup.Provider)registries));
    }

    public CompletableFuture<?> run(CachedOutput cache, HolderLookup.Provider registries) {
        this.start();
        Path forgePath = this.output.getOutputFolder().resolve(this.destination).resolve("neoforge").resolve("loot_modifiers").resolve("global_loot_modifiers.json");
        Path modifierFolderPath = this.output.getOutputFolder().resolve(this.destination).resolve(this.modid).resolve("loot_modifiers");
        ArrayList<ResourceLocation> entries = new ArrayList<ResourceLocation>();
        ImmutableList.Builder futuresBuilder = new ImmutableList.Builder();
        for (Map.Entry<String, WithConditions<IGlobalLootModifier>> entry : this.toSerialize.entrySet()) {
            String name = entry.getKey();
            WithConditions<IGlobalLootModifier> lootModifier = entry.getValue();
            entries.add(Reference.rl("pmmo", name));
            Path modifierPath = modifierFolderPath.resolve(name + ".json");
            futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (HolderLookup.Provider)registries, (Codec)IGlobalLootModifier.CONDITIONAL_CODEC, Optional.of(lootModifier), (Path)modifierPath));
        }
        JsonObject forgeJson = new JsonObject();
        forgeJson.addProperty("replace", Boolean.valueOf(false));
        forgeJson.add("entries", GSON.toJsonTree(entries.stream().map(ResourceLocation::toString).collect(Collectors.toList())));
        futuresBuilder.add((Object)DataProvider.saveStable((CachedOutput)cache, (JsonElement)forgeJson, (Path)forgePath));
        return CompletableFuture.allOf((CompletableFuture[])futuresBuilder.build().toArray(CompletableFuture[]::new));
    }

    public <T extends IGlobalLootModifier> void add(String modifier, T instance, List<ICondition> conditions) {
        this.toSerialize.put(modifier, (WithConditions<IGlobalLootModifier>)new WithConditions(conditions, instance));
    }

    public <T extends IGlobalLootModifier> void add(String modifier, T instance, ICondition ... conditions) {
        this.add(modifier, instance, Arrays.asList(conditions));
    }

    public String getName() {
        return "Global Loot Modifiers : " + this.destination.toString();
    }
}

