/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.setup.datagen.defaultpack;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.setup.datagen.PmmoDataProvider;
import harmonised.pmmo.util.RegistryUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class DefaultEntityConfigProvider
extends PmmoDataProvider<ObjectData> {
    Map<ResourceLocation, ObjectData.Builder> data = new HashMap<ResourceLocation, ObjectData.Builder>();

    public DefaultEntityConfigProvider(PackOutput gen) {
        super(gen, "default", "pmmo/entities", ObjectData.CODEC.codec());
    }

    @Override
    protected void start() {
        this.get(EntityType.BOAT).addXpValues(EventType.RIDING, Map.of("sailing", 20L));
        this.get(EntityType.CHEST_BOAT).addXpValues(EventType.RIDING, Map.of("sailing", 20L));
        this.data.forEach((id, builder) -> this.add((ResourceLocation)id, builder.end()));
    }

    private ObjectData.Builder get(EntityType<?> entity) {
        return this.data.computeIfAbsent(RegistryUtil.getId(entity), id -> ObjectData.build());
    }

    public String getName() {
        return "Project MMO Default Entity Generator";
    }
}

