/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.features.autovalues.AutoValues;
import harmonised.pmmo.features.loot_modifiers.GLMRegistry;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.setup.CommonSetup;
import harmonised.pmmo.setup.GameplayPacks;
import harmonised.pmmo.storage.DataAttachmentTypes;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.resource.JarContentsPackResources;

@Mod(value="pmmo")
public class ProjectMMO {
    public ProjectMMO(IEventBus modbus, ModContainer container) {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_CONFIG);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.COMMON_CONFIG);
        modbus.addListener(this::onConfigReload);
        modbus.addListener(this::onPackFind);
        modbus.addListener(Networking::registerMessages);
        GLMRegistry.CONDITIONS.register(modbus);
        GLMRegistry.GLM.register(modbus);
        DataAttachmentTypes.ATTACHMENT_TYPES.register(modbus);
        CommonSetup.TRIGGERS.register(modbus);
        CommonSetup.DATA_COMPONENTS.register(modbus);
        CommonSetup.ATTRIBUTES.register(modbus);
        modbus.addListener(CommonSetup::init);
        modbus.addListener(CommonSetup::gatherData);
        modbus.addListener(CommonSetup::addAttributes);
    }

    @SubscribeEvent
    public void onConfigReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getType().equals((Object)ModConfig.Type.SERVER) && event.getConfig().getFileName().equalsIgnoreCase("pmmo-autovalues.toml")) {
            AutoValues.resetCache();
        }
    }

    @SubscribeEvent
    public void onPackFind(AddPackFindersEvent event) {
        GameplayPacks.getPacks().stream().filter(holder -> holder.type().equals((Object)event.getPackType())).forEach(holder -> {
            JarContentsPackResources.JarContentsResourcesSupplier supplier = new JarContentsPackResources.JarContentsResourcesSupplier(ModList.get().getModFileById("pmmo").getFile().getContents(), "resourcepacks/%s".formatted(holder.id().getPath()));
            Pack pack = Pack.readMetaAndCreate((PackLocationInfo)new PackLocationInfo("builtin/%s".formatted(holder.id().getPath()), (Component)holder.titleKey().asComponent(), holder.source(), Optional.empty()), (Pack.ResourcesSupplier)supplier, (PackType)holder.type(), (PackSelectionConfig)new PackSelectionConfig(false, Pack.Position.BOTTOM, false));
            event.addRepositorySource(consumer -> consumer.accept(pack));
        });
    }
}

