/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.api.enums;

import com.mojang.serialization.Codec;
import harmonised.pmmo.client.gui.component.GuiEnumGroup;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.util.StringRepresentable;

public enum ModifierDataType implements StringRepresentable,
GuiEnumGroup
{
    BIOME(LangProvider.BIOME_HEADER),
    HELD(LangProvider.BOOST_HELD),
    WORN(LangProvider.BOOST_WORN),
    DIMENSION(LangProvider.DIMENSION_HEADER);

    public final LangProvider.Translation tooltip;
    public static final Codec<ModifierDataType> CODEC;
    private static final Map<String, ModifierDataType> BY_NAME;

    private ModifierDataType(LangProvider.Translation tooltip) {
        this.tooltip = tooltip;
    }

    public static ModifierDataType byName(String name) {
        return BY_NAME.get(name);
    }

    public String getSerializedName() {
        return this.name();
    }

    @Override
    public String getName() {
        return this.name();
    }

    static {
        CODEC = StringRepresentable.fromEnum(ModifierDataType::values);
        BY_NAME = Arrays.stream(ModifierDataType.values()).collect(Collectors.toMap(ModifierDataType::getSerializedName, s -> s));
    }
}

