/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.events;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.util.Pair;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.gui.StatsScreen;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.setup.ClientSetup;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="pmmo", value={Dist.CLIENT})
public class TooltipHandler {
    public static boolean tooltipOn = true;

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        if (!tooltipOn) {
            return;
        }
        Player player = event.getEntity();
        if (player != null) {
            Core core = Core.get(LogicalSide.CLIENT);
            ItemStack stack = event.getItemStack();
            boolean isBlockItem = stack.getItem() instanceof BlockItem;
            ResourceLocation itemID = RegistryUtil.getId(player.level().registryAccess(), stack);
            if (itemID == null) {
                return;
            }
            if (!ClientSetup.OPEN_MENU.isUnbound() && InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)ClientSetup.OPEN_MENU.getKey().getValue())) {
                Minecraft.getInstance().setScreen((Screen)new StatsScreen(stack));
                return;
            }
            Arrays.stream(isBlockItem ? ReqType.BLOCKITEM_APPLICABLE_EVENTS : ReqType.ITEM_APPLICABLE_EVENTS).filter(type -> (Boolean)Config.tooltipReqEnabled(type).get()).map(type -> Pair.of((Object)type, TooltipHandler.getReqData(core, type, stack, player))).filter(pair -> !((Map)pair.getSecond()).isEmpty()).forEach(pair -> TooltipHandler.addRequirementTooltip(((ReqType)pair.getFirst()).tooltipTranslation, event, (Map)pair.getSecond()));
            Arrays.stream(isBlockItem ? EventType.BLOCKITEM_APPLICABLE_EVENTS : EventType.ITEM_APPLICABLE_EVENTS).filter(type -> (Boolean)Config.tooltipXpEnabled(type).get()).map(type -> Pair.of((Object)type, TooltipHandler.getXpData(core, type, player, stack))).filter(pair -> !((Map)pair.getSecond()).isEmpty()).forEach(pair -> TooltipHandler.addXpValueTooltip(((EventType)pair.getFirst()).tooltipTranslation, event, (Map)pair.getSecond()));
            Stream.of(ModifierDataType.HELD, ModifierDataType.WORN).filter(type -> (Boolean)Config.tooltipBonusEnabled(type).get()).map(type -> Pair.of((Object)type, core.getObjectModifierMap(ObjectType.ITEM, itemID, (ModifierDataType)type, TagUtils.stackTag(stack, player.level())))).filter(pair -> !((Map)pair.getSecond()).isEmpty()).forEach(pair -> TooltipHandler.addModifierTooltip(((ModifierDataType)pair.getFirst()).tooltip, event, (Map)pair.getSecond()));
            VeinData veinData = core.getLoader().ITEM_LOADER.getData(itemID).veinData();
            if (!veinData.isUnconfigured() && !veinData.isEmpty() && Config.server().veinMiner().enabled()) {
                TooltipHandler.addVeinTooltip(LangProvider.VEIN_TOOLTIP, event, veinData, isBlockItem);
            }
        }
    }

    private static void addRequirementTooltip(LangProvider.Translation header, ItemTooltipEvent event, Map<String, Long> reqs) {
        MutableComponent headerComp = header.asComponent().withStyle(ChatFormatting.RED);
        if (reqs.entrySet().size() == 1) {
            Map.Entry<String, Long> req = reqs.entrySet().iterator().next();
            MutableComponent singleComponent = Component.translatable((String)("pmmo." + req.getKey())).append((Component)Component.literal((String)(" " + String.valueOf(req.getValue())))).setStyle(CoreUtils.getSkillStyle(req.getKey()));
            event.getToolTip().add(headerComp.append(" ").append((Component)singleComponent));
        } else {
            event.getToolTip().add(headerComp);
            for (Map.Entry<String, Long> req : reqs.entrySet()) {
                event.getToolTip().add(Component.literal((String)"   ").append((Component)Component.translatable((String)("pmmo." + req.getKey()))).append((Component)Component.literal((String)(" " + String.valueOf(req.getValue())))).setStyle(CoreUtils.getSkillStyle(req.getKey())));
            }
        }
    }

    private static void addXpValueTooltip(LangProvider.Translation header, ItemTooltipEvent event, Map<String, Long> values) {
        MutableComponent headerComp = header.asComponent().withStyle(ChatFormatting.GREEN);
        if (values.entrySet().size() == 1) {
            Map.Entry<String, Long> value2 = values.entrySet().iterator().next();
            MutableComponent xpValue = Component.translatable((String)("pmmo." + value2.getKey())).append((Component)Component.literal((String)(" " + String.valueOf(value2.getValue())))).setStyle(CoreUtils.getSkillStyle(value2.getKey()));
            event.getToolTip().add(headerComp.append(" ").append((Component)xpValue));
        } else {
            event.getToolTip().add(headerComp);
            values.entrySet().stream().filter(entry -> (Long)entry.getValue() > 0L).forEach(value -> event.getToolTip().add(Component.literal((String)"   ").append((Component)Component.translatable((String)("pmmo." + (String)value.getKey()))).append((Component)Component.literal((String)(" " + String.valueOf(value.getValue())))).setStyle(CoreUtils.getSkillStyle((String)value.getKey()))));
        }
    }

    private static void addModifierTooltip(LangProvider.Translation header, ItemTooltipEvent event, Map<String, Double> values) {
        MutableComponent headerComp = header.asComponent().withStyle(ChatFormatting.BLUE);
        if (values.entrySet().size() == 1) {
            Map.Entry<String, Double> modifier2 = values.entrySet().iterator().next();
            MutableComponent bonusComponent = Component.translatable((String)("pmmo." + modifier2.getKey())).append((Component)Component.literal((String)(" " + TooltipHandler.modifierPercent(modifier2.getValue())))).setStyle(CoreUtils.getSkillStyle(modifier2.getKey()));
            event.getToolTip().add(headerComp.append(" ").append((Component)bonusComponent));
        } else {
            event.getToolTip().add(headerComp);
            values.entrySet().stream().filter(entry -> (Double)entry.getValue() != 0.0 && (Double)entry.getValue() != 1.0).forEach(modifier -> event.getToolTip().add(Component.literal((String)"   ").append((Component)Component.translatable((String)("pmmo." + (String)modifier.getKey()))).append((Component)Component.literal((String)(" " + TooltipHandler.modifierPercent((Double)modifier.getValue())))).setStyle(CoreUtils.getSkillStyle((String)modifier.getKey()))));
        }
    }

    private static void addVeinTooltip(LangProvider.Translation header, ItemTooltipEvent event, VeinData data, boolean isBlockItem) {
        event.getToolTip().add(header.asComponent());
        event.getToolTip().add(LangProvider.VEIN_DATA.asComponent(data.chargeCap.orElse(0), DP.dp(data.chargeRate.orElse(0.0) * 2.0)));
        if (isBlockItem) {
            event.getToolTip().add(LangProvider.VEIN_BREAK.asComponent(data.consumeAmount.orElse(0)));
        }
    }

    private static String modifierPercent(Double value) {
        return DP.dp((value - 1.0) * 100.0) + "%";
    }

    private static Map<String, Long> getXpData(Core core, EventType type, Player player, ItemStack stack) {
        Map<String, Long> map = core.getExperienceAwards(type, stack, player, new CompoundTag());
        if (type.blockApplicable && stack.getItem() instanceof BlockItem) {
            map = core.getCommonXpAwardData(new HashMap<String, Long>(), type, RegistryUtil.getId(player.level().registryAccess(), stack), player, ObjectType.BLOCK, TagUtils.stackTag(stack, player.level()));
        }
        CoreUtils.processSkillGroupXP(map);
        return map;
    }

    private static Map<String, Long> getReqData(Core core, ReqType type, ItemStack stack, Player player) {
        Map<String, Long> map;
        if (!Config.server().requirements().isEnabled(type)) {
            return new HashMap<String, Long>();
        }
        Map<String, Long> map2 = map = type == ReqType.USE_ENCHANTMENT ? core.getEnchantReqs(stack) : core.getReqMap(type, stack, player.level(), true);
        if (stack.getItem() instanceof BlockItem) {
            map.putAll(core.getCommonReqData(new HashMap<String, Long>(), ObjectType.BLOCK, RegistryUtil.getId(player.level().registryAccess(), stack), type, TagUtils.stackTag(stack, player.level())));
        }
        CoreUtils.processSkillGroupReqs(map);
        if (!((Boolean)Config.HIDE_MET_REQS.get()).booleanValue()) {
            return map;
        }
        new HashMap<String, Long>(map).forEach((skill, level) -> {
            if (Config.skills().skills().getOrDefault(skill, SkillData.Builder.getDefault()).isSkillGroup()) {
                long total = Config.skills().get((String)skill).getGroup().keySet().stream().map(groupskill -> core.getData().getLevel((String)groupskill, null)).mapToLong(Long::longValue).sum();
                if (level <= total) {
                    map.remove(skill);
                }
            } else if (core.getData().getLevel((String)skill, null) >= level) {
                map.remove(skill);
            }
        });
        return map;
    }
}

