/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.gui.StatsScreen;
import harmonised.pmmo.client.gui.component.GuiEnumGroup;
import harmonised.pmmo.client.gui.component.SelectionWidget;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.serverpackets.SP_GLMRequest;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class GlossarySelectScreen
extends Screen {
    private static final ResourceLocation GUI_BG = Reference.rl("textures/gui/screenboxy.png");
    private SelectionWidget<SelectionWidget.SelectionEntry<SELECTION>> selectSection;
    private SelectionWidget<SelectionWidget.SelectionEntry<OBJECT>> selectObject;
    private SelectionWidget<SelectionWidget.SelectionEntry<String>> selectSkills;
    private SelectionWidget<SelectionWidget.SelectionEntry<GuiEnumGroup>> selectEnum;
    private Button viewButton;
    private SELECTION selection;
    private OBJECT object;
    private String skill = "";
    private GuiEnumGroup type;
    private int renderX;
    private int renderY;

    public GlossarySelectScreen() {
        super((Component)Component.literal((String)"pmmo_glossary"));
        this.init();
    }

    protected void init() {
        this.renderX = this.width / 2 - 128;
        this.renderY = this.height / 2 - 128;
        this.selectSection = new SelectionWidget<SelectionWidget.SelectionEntry>(this.width / 2 - 100, this.renderY + 25, 200, (Component)LangProvider.GLOSSARY_DEFAULT_SECTION.asComponent(), this::updateSelection);
        this.selectSection.setEntries(SELECTION.CHOICE_LIST);
        this.selectObject = new SelectionWidget<SelectionWidget.SelectionEntry>(this.width / 2 - 100, this.renderY + 50, 200, (Component)LangProvider.GLOSSARY_DEFAULT_OBJECT.asComponent(), sel -> {
            this.object = (OBJECT)((Object)((Object)sel.reference));
            this.updateEnum((SelectionWidget.SelectionEntry<OBJECT>)sel);
        });
        this.selectObject.visible = false;
        this.selectSkills = new SelectionWidget<SelectionWidget.SelectionEntry>(this.width / 2 - 100, this.renderY + 75, 200, (Component)LangProvider.GLOSSARY_DEFAULT_SKILL.asComponent(), sel -> {
            this.skill = (String)sel.reference;
        });
        this.selectSkills.setEntries(Config.skills().skills().keySet().stream().sorted().map(skill -> new SelectionWidget.SelectionEntry<String>((Component)Component.translatable((String)("pmmo." + skill)).setStyle(CoreUtils.getSkillStyle(skill)), (String)skill)).toList());
        this.selectSkills.visible = false;
        this.selectEnum = new SelectionWidget<SelectionWidget.SelectionEntry>(this.width / 2 - 100, this.renderY + 100, 200, (Component)LangProvider.GLOSSARY_DEFAULT_ENUM.asComponent(), sel -> {
            this.type = (GuiEnumGroup)sel.reference;
        });
        this.selectEnum.visible = false;
        this.viewButton = Button.builder((Component)LangProvider.GLOSSARY_VIEW_BUTTON.asComponent(), button -> {
            if (this.selection != null && this.object != null) {
                Minecraft.getInstance().setScreen((Screen)new StatsScreen(this.selection, this.object, this.skill, this.type));
            }
        }).bounds(this.width / 2 - 40, this.renderY + 125, 80, 20).build();
        this.viewButton.visible = false;
        this.addRenderableWidget((GuiEventListener)this.viewButton);
        this.addRenderableWidget((GuiEventListener)this.selectEnum);
        this.addRenderableWidget((GuiEventListener)this.selectSkills);
        this.addRenderableWidget((GuiEventListener)this.selectObject);
        this.addRenderableWidget((GuiEventListener)this.selectSection);
        Networking.sendToServer(new SP_GLMRequest());
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(graphics, mouseX, mouseY, partialTicks);
        super.render(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics graphics, int i, int j, float k) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, GUI_BG, this.renderX, this.renderY, 0.0f, 0.0f, 256, 256, 256, 256);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrolled, double other) {
        if (this.selectSection.isExtended()) {
            return this.selectSection.mouseScrolled(mouseX, mouseY, scrolled, other) || super.mouseScrolled(mouseX, mouseY, scrolled, other);
        }
        if (this.selectObject.isExtended()) {
            return this.selectObject.mouseScrolled(mouseX, mouseY, scrolled, other) || super.mouseScrolled(mouseX, mouseY, scrolled, other);
        }
        if (this.selectSkills.isExtended()) {
            return this.selectSkills.mouseScrolled(mouseX, mouseY, scrolled, other) || super.mouseScrolled(mouseX, mouseY, scrolled, other);
        }
        if (this.selectEnum.isExtended()) {
            return this.selectEnum.mouseScrolled(mouseX, mouseY, scrolled, other) || super.mouseScrolled(mouseX, mouseY, scrolled, other);
        }
        return super.mouseScrolled(mouseX, mouseY, scrolled, other);
    }

    public boolean mouseClicked(MouseButtonEvent mouseEvent, boolean doubleClick) {
        if (this.selectSection.isExtended()) {
            return this.selectSection.mouseClicked(mouseEvent, doubleClick) || super.mouseClicked(mouseEvent, doubleClick);
        }
        if (this.selectObject.isExtended()) {
            return this.selectObject.mouseClicked(mouseEvent, doubleClick) || super.mouseClicked(mouseEvent, doubleClick);
        }
        if (this.selectSkills.isExtended()) {
            return this.selectSkills.mouseClicked(mouseEvent, doubleClick) || super.mouseClicked(mouseEvent, doubleClick);
        }
        if (this.selectEnum.isExtended()) {
            return this.selectEnum.mouseClicked(mouseEvent, doubleClick) || super.mouseClicked(mouseEvent, doubleClick);
        }
        return this.viewButton.mouseClicked(mouseEvent, doubleClick) || super.mouseClicked(mouseEvent, doubleClick);
    }

    private void updateSelection(SelectionWidget.SelectionEntry<SELECTION> sel) {
        this.selection = (SELECTION)((Object)sel.reference);
        this.selectObject.visible = true;
        this.selectObject.setEntries(this.selection.validObjects);
        this.selectSkills.visible = true;
        this.selectEnum.visible = this.selection != SELECTION.SALVAGE && this.selection != SELECTION.VEIN && this.selection != SELECTION.PERKS;
        this.viewButton.visible = true;
    }

    private void updateEnum(SelectionWidget.SelectionEntry<OBJECT> sel) {
        if (this.selection == null) {
            return;
        }
        this.selectEnum.setEntries(switch (((OBJECT)((Object)sel.reference)).ordinal()) {
            case 0 -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(ReqType.ITEM_APPLICABLE_EVENTS);
                }
                if (this.selection == SELECTION.XP) {
                    yield this.enumToList(EventType.ITEM_APPLICABLE_EVENTS);
                }
                if (this.selection == SELECTION.BONUS) {
                    yield this.enumToList(new ModifierDataType[]{ModifierDataType.HELD, ModifierDataType.WORN});
                }
                yield new ArrayList();
            }
            case 1 -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(ReqType.BLOCK_APPLICABLE_EVENTS);
                }
                if (this.selection == SELECTION.XP) {
                    yield this.enumToList(EventType.BLOCK_APPLICABLE_EVENTS);
                }
                yield new ArrayList();
            }
            case 2 -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(ReqType.ENTITY_APPLICABLE_EVENTS);
                }
                if (this.selection == SELECTION.XP) {
                    yield this.enumToList(EventType.ENTITY_APPLICABLE_EVENTS);
                }
                yield new ArrayList();
            }
            case 3 -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(new ReqType[]{ReqType.TRAVEL});
                }
                if (this.selection == SELECTION.BONUS) {
                    yield this.enumToList(new ModifierDataType[]{ModifierDataType.DIMENSION});
                }
                yield new ArrayList();
            }
            case 4 -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(new ReqType[]{ReqType.TRAVEL});
                }
                if (this.selection == SELECTION.BONUS) {
                    yield this.enumToList(new ModifierDataType[]{ModifierDataType.BIOME});
                }
                yield new ArrayList();
            }
            case 5 -> {
                if (this.selection == SELECTION.REQS) {
                    yield this.enumToList(new ReqType[]{ReqType.USE_ENCHANTMENT});
                }
                yield new ArrayList();
            }
            default -> new ArrayList();
        });
    }

    private List<SelectionWidget.SelectionEntry<GuiEnumGroup>> enumToList(GuiEnumGroup[] array) {
        return Arrays.stream(array).map(val -> new SelectionWidget.SelectionEntry<GuiEnumGroup>((Component)Component.translatable((String)("pmmo.enum." + val.getName())), (GuiEnumGroup)val)).toList();
    }

    public static enum SELECTION {
        REQS(LangProvider.GLOSSARY_SECTION_REQ.asComponent(), Arrays.stream(OBJECT.values()).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        XP(LangProvider.GLOSSARY_SECTION_XP.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.ITEMS, OBJECT.BLOCKS, OBJECT.ENTITY, OBJECT.EFFECTS}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        BONUS(LangProvider.GLOSSARY_SECTION_BONUS.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.ITEMS, OBJECT.DIMENSIONS, OBJECT.BIOMES}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        SALVAGE(LangProvider.GLOSSARY_SECTION_SALVAGE.asComponent(), List.of(new SelectionWidget.SelectionEntry<OBJECT>((Component)OBJECT.ITEMS.text, OBJECT.ITEMS))),
        VEIN(LangProvider.GLOSSARY_SECTION_VEIN.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.ITEMS, OBJECT.BLOCKS, OBJECT.DIMENSIONS, OBJECT.BIOMES}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        MOB_SCALING(LangProvider.GLOSSARY_SECTION_MOB.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.DIMENSIONS, OBJECT.BIOMES}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList()),
        PERKS(LangProvider.GLOSSARY_SECTION_PERKS.asComponent(), Arrays.stream(new OBJECT[]{OBJECT.PERKS}).map(obj -> new SelectionWidget.SelectionEntry<OBJECT>((Component)obj.text, (OBJECT)((Object)obj))).toList());

        MutableComponent text;
        List<SelectionWidget.SelectionEntry<OBJECT>> validObjects;
        public static final List<SelectionWidget.SelectionEntry<SELECTION>> CHOICE_LIST;

        private SELECTION(MutableComponent text, List<SelectionWidget.SelectionEntry<OBJECT>> validObjects) {
            this.text = text;
            this.validObjects = validObjects;
        }

        static {
            CHOICE_LIST = Arrays.stream(SELECTION.values()).map(val -> new SelectionWidget.SelectionEntry<SELECTION>((Component)val.text, (SELECTION)((Object)val))).toList();
        }
    }

    public static enum OBJECT {
        ITEMS(LangProvider.GLOSSARY_OBJECT_ITEMS.asComponent()),
        BLOCKS(LangProvider.GLOSSARY_OBJECT_BLOCKS.asComponent()),
        ENTITY(LangProvider.GLOSSARY_OBJECT_ENTITIES.asComponent()),
        DIMENSIONS(LangProvider.GLOSSARY_OBJECT_DIMENSIONS.asComponent()),
        BIOMES(LangProvider.GLOSSARY_OBJECT_BIOMES.asComponent()),
        ENCHANTS(LangProvider.GLOSSARY_OBJECT_ENCHANTS.asComponent()),
        EFFECTS(LangProvider.GLOSSARY_OBJECT_EFFECTS.asComponent()),
        PERKS(LangProvider.GLOSSARY_OBJECT_PERKS.asComponent());

        MutableComponent text;
        public static final List<SelectionWidget.SelectionEntry<OBJECT>> CHOICE_LIST;

        private OBJECT(MutableComponent text) {
            this.text = text;
        }

        static {
            CHOICE_LIST = Arrays.stream(OBJECT.values()).map(val -> new SelectionWidget.SelectionEntry<OBJECT>((Component)val.text, (OBJECT)((Object)val))).toList();
        }
    }
}

