/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import com.mojang.blaze3d.vertex.BufferBuilder;
import harmonised.pmmo.client.utils.ClientUtils;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.client.gui.GuiLayer;
import org.joml.Matrix4f;
import org.joml.Vector2i;

public class TutorialOverlayGUI
implements GuiLayer {
    private Minecraft mc;
    private Font fontRenderer;
    private List<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
    private BlockHitResult bhr;

    public void render(GuiGraphics guiGraphics, DeltaTracker partialTick) {
        if (this.mc == null) {
            this.mc = Minecraft.getInstance();
        }
        if (!(this.mc.hitResult instanceof BlockHitResult)) {
            return;
        }
        this.bhr = (BlockHitResult)this.mc.hitResult;
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.font;
        }
        int renderLeft = guiGraphics.guiWidth() / 8 * 5;
        int renderTop = guiGraphics.guiHeight() / 4;
        int tooltipWidth = 3 * (guiGraphics.guiWidth() / 8);
        if (!this.mc.getDebugOverlay().showDebugScreen() && ((Boolean)Config.SALVAGE_HIGHLIGHTS.get()).booleanValue()) {
            if (this.mc.level.getBlockState(this.bhr.getBlockPos()).getBlock().equals(BuiltInRegistries.BLOCK.get(Config.server().general().salvageBlock()))) {
                this.lines = new ArrayList<ClientTooltipComponent>(ClientUtils.ctc(LangProvider.SALVAGE_TUTORIAL_HEADER.asComponent().withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), tooltipWidth));
                if (!(!this.mc.player.isCrouching() || this.mc.player.getMainHandItem().isEmpty() && this.mc.player.getOffhandItem().isEmpty())) {
                    ItemStack salvageStack = this.mc.player.getMainHandItem().isEmpty() ? this.mc.player.getOffhandItem() : this.mc.player.getMainHandItem();
                    this.gatherSalvageData(salvageStack).forEach(line -> this.lines.addAll(ClientUtils.ctc(line, tooltipWidth)));
                } else {
                    this.lines.addAll(ClientUtils.ctc(LangProvider.SALVAGE_TUTORIAL_USAGE.asComponent(), tooltipWidth));
                }
            } else {
                return;
            }
            if (!this.lines.isEmpty()) {
                guiGraphics.renderTooltip(this.mc.font, this.lines, renderLeft, renderTop, (sw, sh, mx, my, tw, th) -> new Vector2i(renderLeft, renderTop), null);
            }
        }
    }

    protected static void fillGradient(Matrix4f pMatrix, BufferBuilder pBuilder, int pX1, int pY1, int pX2, int pY2, int pBlitOffset, int pColorA, int pColorB) {
        float f = (float)(pColorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(pColorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(pColorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(pColorA & 0xFF) / 255.0f;
        float f4 = (float)(pColorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(pColorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(pColorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(pColorB & 0xFF) / 255.0f;
        pBuilder.addVertex(pMatrix, (float)pX2, (float)pY1, (float)pBlitOffset).setColor(f1, f2, f3, f);
        pBuilder.addVertex(pMatrix, (float)pX1, (float)pY1, (float)pBlitOffset).setColor(f1, f2, f3, f);
        pBuilder.addVertex(pMatrix, (float)pX1, (float)pY2, (float)pBlitOffset).setColor(f5, f6, f7, f4);
        pBuilder.addVertex(pMatrix, (float)pX2, (float)pY2, (float)pBlitOffset).setColor(f5, f6, f7, f4);
    }

    private List<MutableComponent> gatherSalvageData(ItemStack stack) {
        ArrayList<MutableComponent> outList = new ArrayList<MutableComponent>();
        for (Map.Entry<ResourceLocation, CodecTypes.SalvageData> entry : Core.get((LogicalSide)LogicalSide.CLIENT).getLoader().ITEM_LOADER.getData(RegistryUtil.getId(this.mc.level.registryAccess(), stack)).salvage().entrySet()) {
            outList.add(MutableComponent.create((ComponentContents)new ItemStack((Holder)BuiltInRegistries.ITEM.get(entry.getKey()).get()).getDisplayName().getContents()));
            CodecTypes.SalvageData data = entry.getValue();
            if (!data.levelReq().isEmpty()) {
                outList.add(LangProvider.SALVAGE_LEVEL_REQ.asComponent().withStyle(ChatFormatting.UNDERLINE));
                for (Map.Entry<String, Long> entry2 : data.levelReq().entrySet()) {
                    outList.add(Component.translatable((String)("pmmo." + entry2.getKey())).append((Component)Component.literal((String)(": " + String.valueOf(entry2.getValue())))));
                }
            }
            outList.add(LangProvider.SALVAGE_CHANCE.asComponent(data.baseChance(), data.maxChance()).withStyle(ChatFormatting.UNDERLINE));
            outList.add(LangProvider.SALVAGE_MAX.asComponent(data.salvageMax()).withStyle(ChatFormatting.UNDERLINE));
            if (!data.chancePerLevel().isEmpty()) {
                outList.add(LangProvider.SALVAGE_CHANCE_MOD.asComponent().withStyle(ChatFormatting.UNDERLINE));
                for (Map.Entry<String, Number> entry3 : data.chancePerLevel().entrySet()) {
                    outList.add(Component.translatable((String)("pmmo." + entry3.getKey())).append((Component)Component.literal((String)(": " + String.valueOf(entry3.getValue())))));
                }
            }
            if (data.xpAward().isEmpty()) continue;
            outList.add(LangProvider.SALVAGE_XP_AWARD.asComponent().withStyle(ChatFormatting.UNDERLINE));
            for (Map.Entry<String, Number> entry4 : data.xpAward().entrySet()) {
                outList.add(Component.translatable((String)("pmmo." + entry4.getKey())).append((Component)Component.literal((String)(": " + String.valueOf(entry4.getValue())))));
            }
        }
        return outList;
    }
}

