/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui.component;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.storage.Experience;
import harmonised.pmmo.util.Reference;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import org.jetbrains.annotations.NotNull;

public class PlayerStatsComponent
extends AbstractWidget {
    protected static final ResourceLocation TEXTURE_LOCATION = Reference.rl("textures/gui/player_stats.png");
    protected static final Core core = Core.get(LogicalSide.CLIENT);
    protected Minecraft minecraft;
    private boolean visible;
    private int xOffset;
    private int width;
    private int height;
    private boolean widthTooNarrow;
    private int timesInventoryChanged;
    protected PlayerStatsScroller statsScroller;
    public static final int IMAGE_WIDTH = 147;
    public static final int IMAGE_HEIGHT = 166;
    private static final int OFFSET_X_POSITION = 86;

    public PlayerStatsComponent() {
        super(0, 0, 0, 0, (Component)Component.empty());
    }

    public void init(int width, int height, Minecraft minecraft, boolean widthTooNarrow) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.widthTooNarrow = widthTooNarrow;
        this.timesInventoryChanged = minecraft.player.getInventory().getTimesChanged();
        if (this.visible) {
            this.initVisuals();
        }
    }

    public void tick() {
        if (this.isVisible() && this.timesInventoryChanged != this.minecraft.player.getInventory().getTimesChanged()) {
            this.timesInventoryChanged = this.minecraft.player.getInventory().getTimesChanged();
        }
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            int i = (this.width - 147) / 2 - this.xOffset;
            int j = (this.height - 166) / 2;
            graphics.blit(TEXTURE_LOCATION, i, j, i + 147, j + 166, 0.0f, 0.57421875f, 0.0f, 0.6484375f);
            this.statsScroller.render(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void initVisuals() {
        this.xOffset = this.widthTooNarrow ? 0 : 86;
        int i = (this.width - 147) / 2 - this.xOffset;
        int j = (this.height - 166) / 2;
        this.statsScroller = new PlayerStatsScroller(Minecraft.getInstance(), 131, 150, j + 8, i + 8);
        this.statsScroller.populateAbilities(core, this.minecraft);
    }

    public int updateScreenPosition(int x, int y) {
        int i = this.isVisible() && !this.widthTooNarrow ? 177 + (x - y - 200) / 2 : (x - y) / 2;
        return i;
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean visible) {
        if (visible) {
            this.initVisuals();
        }
        this.visible = visible;
    }

    public boolean mouseClicked(MouseButtonEvent mouseEvent, boolean doubleClicked) {
        if (!this.isVisible()) {
            return false;
        }
        return this.statsScroller.mouseClicked(mouseEvent, doubleClicked) || super.mouseClicked(mouseEvent, doubleClicked);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta, double delta) {
        if (!this.isVisible()) {
            return false;
        }
        return this.statsScroller.mouseScrolled(pMouseX, pMouseY, pDelta, delta) || super.mouseScrolled(pMouseX, pMouseY, pDelta, delta);
    }

    public boolean mouseDragged(MouseButtonEvent mouseEvent, double pDragX, double pDragY) {
        if (!this.isVisible()) {
            return false;
        }
        return this.statsScroller.mouseDragged(mouseEvent, pDragX, pDragY) || super.mouseDragged(mouseEvent, pDragX, pDragY);
    }

    @NotNull
    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    static class PlayerStatsScroller
    extends ScrollPanel {
        private final List<String> skillsKeys = new ArrayList<String>();
        private final List<StatComponent> abilities = new ArrayList<StatComponent>();

        public PlayerStatsScroller(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left, 1, 6, 0xFFFFFF, 0xFFFFFF, -2011094751);
        }

        public void populateAbilities(Core core, Minecraft minecraft) {
            IDataStorage dataStorage = core.getData();
            this.skillsKeys.addAll(dataStorage.getXpMap(null).keySet());
            this.skillsKeys.sort(Comparator.comparingLong(skill -> dataStorage.getXp(null, (String)skill)).reversed());
            for (String skillKey : this.skillsKeys) {
                SkillData skillData = Config.skills().get(skillKey);
                this.abilities.add(new StatComponent(minecraft, this.left + 1, this.top, skillKey, skillData));
            }
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, int mouseX, int mouseY) {
            for (StatComponent component : this.abilities) {
                component.setPosition(component.getX(), relativeY);
                component.render(guiGraphics, mouseX, mouseY, Minecraft.getInstance().getFrameTimeNs());
                relativeY += 24 + this.border;
            }
        }

        protected int getScrollAmount() {
            return 24 + this.border;
        }

        protected int getContentHeight() {
            int height = this.abilities.size() * (24 + this.border);
            if (height < this.bottom - this.top - 1) {
                height = this.bottom - this.top - 1;
            }
            return height;
        }

        @NotNull
        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }

    static class StatComponent
    extends ImageButton {
        private static final WidgetSprites BACKGROUND_SPRITES = new WidgetSprites(Reference.rl("stat_background"), Reference.rl("stat_background_highlighted"));
        private final Minecraft minecraft;
        private final String skillName;
        private final SkillData skillData;
        private final Color skillColor;
        private final Experience xp;
        private static final int BASE_HEIGHT = 24;

        public StatComponent(Minecraft minecraft, int pX, int pY, String skillKey, SkillData skillData) {
            super(pX, pY, 123, 24, BACKGROUND_SPRITES, pButton -> {});
            this.minecraft = minecraft;
            this.skillName = Component.translatable((String)("pmmo." + skillKey)).getString();
            this.skillData = skillData;
            this.skillColor = new Color(skillData.getColor());
            this.xp = core.getData().getXpMap(null).getOrDefault(skillKey, new Experience());
        }

        public void renderWidget(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.renderWidget(graphics, pMouseX, pMouseY, pPartialTick);
            graphics.blit(RenderPipelines.GUI_TEXTURED, this.skillData.getIcon(), this.getX() + 3, this.getY() + 3, 0.0f, 0.0f, 16, 16, this.skillData.getIconSize(), this.skillData.getIconSize(), this.skillData.getIconSize(), this.skillData.getIconSize());
            this.renderProgressBar(graphics);
            graphics.drawString(this.minecraft.font, this.skillName, this.getX() + 24, this.getY() + 5, this.skillColor.getRGB());
            graphics.drawString(this.minecraft.font, String.valueOf(this.xp.getLevel().getLevel()), this.getX() + this.width - 5 - this.minecraft.font.width(String.valueOf(this.xp.getLevel().getLevel())), this.getY() + 5, this.skillColor.getRGB());
            if (pMouseX > this.getX() + 3 && pMouseX < this.getX() + 19 && pMouseY > this.getY() + 3 && pMouseY < this.getY() + 19) {
                this.renderPerkTooltip(graphics, pMouseX, pMouseY, this.skillName);
            }
        }

        public void renderProgressBar(GuiGraphics graphics) {
            int renderX = this.getX() + 24;
            int n = this.getY();
            Objects.requireNonNull(this.minecraft.font);
            int renderY = n + (9 + 6);
            if (this.isHovered()) {
                MutableComponent text = Component.literal((String)"%s => %s".formatted(this.xpToNext(), this.xp.getLevel().getLevel() + 1L));
                graphics.drawString(this.minecraft.font, (Component)text, renderX, renderY - 1, this.skillColor.getRGB());
            } else {
                graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE_LOCATION, renderX, renderY, 0.0f, 217.0f, 94, 5, 101, 5, 256, 256);
                float percent = (float)this.xp.getXp() / (float)this.xp.getLevel().getXpToNext();
                int xp = (int)(percent * 94.0f);
                graphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE_LOCATION, renderX, renderY, 0.0f, 223.0f, xp, 5, 101, 5, 256, 256, 0xFF000000 | this.skillColor.getRGB());
            }
        }

        public void renderPerkTooltip(GuiGraphics graphics, int mouseX, int mouseY, String skill) {
            ArrayList holder = new ArrayList();
            LocalPlayer player = Minecraft.getInstance().player;
            ((List)Config.perks().perks().getOrDefault(EventType.SKILL_UP, new ArrayList())).stream().filter(nbt -> skill.isEmpty() || !nbt.contains("skill") || LangProvider.skill((String)nbt.getString("skill").get()).getString().equals(skill)).forEach(arg_0 -> StatComponent.lambda$renderPerkTooltip$3((Player)player, holder, arg_0));
            graphics.setTooltipForNextFrame(holder, mouseX, mouseY);
        }

        private long xpToNext() {
            return this.xp.getLevel().getXpToNext() - this.xp.getXp();
        }

        private static /* synthetic */ void lambda$renderPerkTooltip$3(Player player, List holder, CompoundTag nbt) {
            ResourceLocation perkID = Reference.of((String)nbt.getString("perk").get());
            nbt.putLong("level", nbt.contains("skill") ? Core.get(player.level()).getData().getLevel((String)nbt.getString("skill").get(), player.getUUID()) : 0L);
            holder.add(Component.translatable((String)("perk." + perkID.getNamespace() + "." + perkID.getPath())).getVisualOrderText());
            holder.add(core.getPerkRegistry().getDescription(perkID).copy().getVisualOrderText());
            core.getPerkRegistry().getStatusLines(perkID, player, nbt).stream().map(component -> component.getVisualOrderText()).forEach(holder::add);
        }
    }
}

