/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui.component;

import harmonised.pmmo.util.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class SelectionWidget<T extends SelectionEntry<?>>
extends AbstractWidget {
    protected static final WidgetSprites BUTTON_SPRITES = new WidgetSprites(Reference.mc("widget/button"), Reference.mc("widget/button_disabled"), Reference.mc("widget/button_highlighted"));
    private static final ResourceLocation SORT_UP_SPRITE = Reference.mc("statistics/sort_up");
    private static final ResourceLocation SORT_DOWN_SPRITE = Reference.mc("statistics/sort_down");
    private static final int ENTRY_HEIGHT = 20;
    private final Component title;
    private final Consumer<T> selectCallback;
    private List<T> entries = new ArrayList<T>();
    private T selected = null;
    private boolean extended = false;
    private int scrollOffset = 0;
    private Font font;

    public SelectionWidget(int x, int y, int width, Component title, Consumer<T> selectCallback) {
        super(x, y, width, 20, (Component)Component.empty());
        this.font = Minecraft.getInstance().font;
        this.title = title;
        this.selectCallback = selectCallback;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation location = BUTTON_SPRITES.get(this.isActive(), this.isMouseOver(mouseX, mouseY));
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, location, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.selected != null) {
            ((SelectionEntry)this.selected).render(graphics, this.getX(), this.getY(), this.width, false, this.getFGColor(), this.alpha);
        } else {
            graphics.drawString(this.font, this.title, this.getX() + 6, this.getY() + (this.height - 8) / 2, this.getFGColor() | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
        }
        if (this.extended) {
            graphics.pose().translate(0.0f, 0.0f);
            int boxHeight = Math.max(1, 20 * Math.min(this.entries.size(), 4)) + 2;
            graphics.fill(RenderPipelines.GUI, this.getX(), this.getY() + 20 - 1, this.getX() + this.width, this.getY() + 20 + boxHeight - 1, -1);
            graphics.fill(RenderPipelines.GUI, this.getX() + 1, this.getY() + 20, this.getX() + this.width - 1, this.getY() + 20 + boxHeight - 2, -16777216);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SORT_UP_SPRITE, this.getX() + this.width - 22, this.getY() + 1, 20, 18);
            T hoverEntry = this.getEntryAtPosition(mouseX, mouseY);
            for (int i = 0; i < 4; ++i) {
                int idx = i + this.scrollOffset;
                if (idx >= this.entries.size()) continue;
                int entryY = this.getY() + (i + 1) * 20;
                SelectionEntry entry = (SelectionEntry)this.entries.get(idx);
                entry.render(graphics, this.getX() + 1, entryY, this.width - 2, entry == hoverEntry, this.getFGColor(), this.alpha);
            }
            if (this.entries.size() > 4) {
                float scale = 4.0f / (float)this.entries.size();
                int scrollY = this.getY() + (int)((float)(20 * this.scrollOffset) * scale) + 20;
                int barHeight = (int)(80.0f * scale + 1.0f);
                int scrollBotY = Math.min(scrollY + barHeight, this.getY() + 20 + boxHeight - 2);
                graphics.fill(RenderPipelines.GUI, this.getX() + this.width - 5, scrollY, this.getX() + this.width - 1, scrollBotY, -10066330);
                graphics.fill(RenderPipelines.GUI, this.getX() + this.width - 4, scrollY + 1, this.getX() + this.width - 2, scrollBotY - 1, -5592406);
            }
        } else {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, SORT_DOWN_SPRITE, this.getX() + this.width - 22, this.getY() + 1, 20, 18);
        }
    }

    public int getHeight() {
        if (this.extended) {
            return 20 * (Math.min(this.entries.size(), 4) + 1) + 1;
        }
        return 20;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean mouseClicked(MouseButtonEvent mouseEvent, boolean doubleClicked) {
        if (this.active && mouseEvent.x() >= (double)this.getX() && mouseEvent.x() <= (double)(this.getX() + this.width) && mouseEvent.y() >= (double)this.getY() && mouseEvent.y() <= (double)(this.getY() + this.getHeight())) {
            int maxX = this.getX() + this.width - (this.entries.size() > 4 ? 5 : 0);
            int maxY = this.getY() + 20 * Math.min(this.entries.size() + 1, 5);
            if (this.extended && mouseEvent.x() < (double)maxX && mouseEvent.y() > (double)(this.getY() + 20) && mouseEvent.y() < (double)maxY) {
                this.setSelected(this.getEntryAtPosition(mouseEvent.x(), mouseEvent.y()), true);
            }
            if (mouseEvent.y() < (double)(this.getY() + 20) && mouseEvent.x() < (double)(this.getX() + this.width) || mouseEvent.x() < (double)maxX) {
                this.extended = !this.extended;
                this.scrollOffset = 0;
            }
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        this.extended = false;
        this.scrollOffset = 0;
        return super.mouseClicked(mouseEvent, doubleClicked);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta, double other) {
        int maxY = this.getY() + 20 * Math.min(this.entries.size() + 1, 5);
        if (this.extended && mouseX >= (double)this.getX() && mouseX <= (double)(this.getX() + this.width) && mouseY > (double)(this.getY() + 20) && mouseY < (double)maxY) {
            if (other <= 0.0 && this.scrollOffset < this.entries.size() - 4) {
                ++this.scrollOffset;
            } else if (other > 0.0 && this.scrollOffset > 0) {
                --this.scrollOffset;
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, delta, other);
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        if (!this.active || !this.visible) {
            return false;
        }
        return pMouseX >= (double)this.getX() && pMouseY >= (double)this.getY() && pMouseX < (double)(this.getX() + this.width) && pMouseY < (double)(this.getY() + this.getHeight());
    }

    private T getEntryAtPosition(double x, double y) {
        if (x < (double)this.getX() || x > (double)(this.getX() + this.width) || y < (double)(this.getY() + 20) || y > (double)(this.getY() + 100)) {
            return null;
        }
        double posY = y - (double)(this.getY() + 20);
        int idx = (int)(posY / 20.0) + this.scrollOffset;
        return (T)(idx < this.entries.size() ? (SelectionEntry)this.entries.get(idx) : null);
    }

    public void setEntries(Collection<T> entry) {
        this.entries = new ArrayList<T>(entry);
    }

    public void setSelected(T selected, boolean notify) {
        this.selected = selected;
        if (notify && this.selectCallback != null) {
            this.selectCallback.accept(selected);
        }
    }

    public T getSelected() {
        return this.selected;
    }

    public Stream<T> stream() {
        return this.entries.stream();
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }

    public static class SelectionEntry<T>
    implements GuiEventListener {
        private Font font;
        public final Component message;
        public T reference;

        public SelectionEntry(Component message, T reference) {
            this.font = Minecraft.getInstance().font;
            this.message = message;
            this.reference = reference;
        }

        public void render(GuiGraphics graphics, int x, int y, int width, boolean hovered, int fgColor, float alpha) {
            if (hovered) {
                graphics.fill(RenderPipelines.GUI, x, y, x + width, y + 20, -6250336);
            }
            FormattedCharSequence text = Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{this.font.substrByWidth((FormattedText)this.message, width - 12)}));
            graphics.drawString(this.font, text, x + 6, y + 6, fgColor | Mth.ceil((float)(alpha * 255.0f)) << 24);
        }

        public void setFocused(boolean p_265728_) {
        }

        public boolean isFocused() {
            return false;
        }
    }
}

