/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.utils;

import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.features.loot_modifiers.RareDropModifier;
import harmonised.pmmo.features.loot_modifiers.SkillLootConditionHighestSkill;
import harmonised.pmmo.features.loot_modifiers.SkillLootConditionKill;
import harmonised.pmmo.features.loot_modifiers.SkillLootConditionPlayer;
import harmonised.pmmo.features.loot_modifiers.TreasureLootModifier;
import harmonised.pmmo.features.loot_modifiers.ValidBlockCondition;
import harmonised.pmmo.mixin.LootTableConditionMixin;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.storage.Experience;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.fml.LogicalSide;

public class DataMirror
implements IDataStorage {
    private Map<String, Experience> mySkills = new HashMap<String, Experience>();
    private Map<String, Experience> otherSkills = new HashMap<String, Experience>();
    public final List<GLM> lootModifiers = new ArrayList<GLM>();

    public boolean me(UUID id) {
        return id == null || id.equals(Minecraft.getInstance().player.getUUID());
    }

    public double getXpWithPercentToNextLevel(Experience rawXP) {
        return (double)rawXP.getXp() / (double)rawXP.getLevel().getXpToNext() + (double)rawXP.getLevel().getLevel();
    }

    @Override
    public long getXp(UUID playerID, String skillName) {
        return this.me(playerID) ? this.mySkills.getOrDefault(skillName, new Experience()).getXp() : this.otherSkills.getOrDefault(skillName, new Experience()).getXp();
    }

    @Override
    public void setXp(UUID playerID, String skillName, long value) {
        if (!this.me(playerID)) {
            return;
        }
        this.mySkills.computeIfAbsent(skillName, s -> new Experience()).setXp(value);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.XP, "Client Side Skill Map: " + MsLoggy.mapToString(this.mySkills), new Object[0]);
    }

    @Override
    public Map<String, Experience> getXpMap(UUID playerID) {
        return this.me(playerID) ? this.mySkills : this.otherSkills;
    }

    @Override
    public void setXpMap(UUID playerID, Map<String, Experience> map) {
        if (this.me(playerID)) {
            this.mySkills = map;
        } else {
            this.otherSkills = map;
        }
    }

    @Override
    public long getLevel(String skill, UUID player) {
        long rawLevel = this.me(player) ? this.mySkills.getOrDefault(skill, new Experience()).getLevel().getLevel() : this.otherSkills.getOrDefault(skill, new Experience()).getLevel().getLevel();
        rawLevel = Core.get(LogicalSide.CLIENT).getLevelProvider().process(skill, rawLevel);
        long skillMax = Config.skills().get(skill).getMaxLevel();
        return Math.min(rawLevel, skillMax);
    }

    @Override
    public IDataStorage get() {
        return this;
    }

    public record GLM(Component header, ItemStack drop, int count, double chance, boolean perLevel, String skill, LootItemCondition[] conditions) {
        public static void add(RareDropModifier modifier) {
            DataMirror data = (DataMirror)Core.get(LogicalSide.CLIENT).getData();
            data.lootModifiers.add(new GLM((Component)LangProvider.GLM_HEADER_RARE.asComponent().withStyle(ChatFormatting.BOLD), modifier.drop, modifier.drop.getCount(), modifier.chance, modifier.perLevel, modifier.skill, modifier.getConditions()));
        }

        public static void add(TreasureLootModifier modifier) {
            DataMirror data = (DataMirror)Core.get(LogicalSide.CLIENT).getData();
            data.lootModifiers.add(new GLM((Component)LangProvider.GLM_HEADER_TREASURE.asComponent().withStyle(ChatFormatting.BOLD), modifier.drop.orElse(ItemStack.EMPTY), modifier.count, modifier.chance, modifier.perLevel, modifier.skill, modifier.getConditions()));
        }

        public List<Component> getGUILines(Core core) {
            ArrayList<Component> linesOut = new ArrayList<Component>();
            linesOut.add(this.header);
            MutableComponent dropText = this.drop.is(Items.AIR) ? Component.literal((String)"itself") : this.drop.getDisplayName();
            linesOut.add((Component)LangProvider.GLM_DROP_ITEM.asComponent(this.count, dropText));
            double actualChance = this.chance * (this.perLevel ? (double)core.getData().getLevel(this.skill, null) : 1.0);
            String actualChanceFormated = String.valueOf(actualChance * 100.0);
            linesOut.add((Component)(this.perLevel ? LangProvider.GLM_DROP_CHANCE_SKILL.asComponent(actualChanceFormated, LangProvider.skill(this.skill)) : LangProvider.GLM_DROP_CHANCE.asComponent(actualChanceFormated)));
            int otherConditions = 0;
            for (LootItemCondition condition : this.conditions) {
                long maxLevel;
                if (condition instanceof LootTableConditionMixin) {
                    LootTableConditionMixin lootCondition = (LootTableConditionMixin)condition;
                    linesOut.add((Component)LangProvider.GLM_LOOT_TABLE.asComponent(lootCondition.getTargetLootTableId().getPath()));
                    continue;
                }
                if (condition instanceof SkillLootConditionPlayer) {
                    SkillLootConditionPlayer playerSkillCondition = (SkillLootConditionPlayer)condition;
                    maxLevel = Math.min((long)playerSkillCondition.levelMax.intValue(), Config.skills().skills().getOrDefault(playerSkillCondition.skill, SkillData.Builder.getDefault()).getMaxLevel());
                    linesOut.add((Component)LangProvider.GLM_SKILL_RANGE.asComponent(LangProvider.skill(playerSkillCondition.skill), playerSkillCondition.levelMin, maxLevel));
                    continue;
                }
                if (condition instanceof SkillLootConditionHighestSkill) {
                    SkillLootConditionHighestSkill highSkillCondition = (SkillLootConditionHighestSkill)condition;
                    String skills = highSkillCondition.comparables.stream().map(str -> LangProvider.skill(str).toString()).collect(Collectors.joining(", "));
                    linesOut.add((Component)LangProvider.GLM_HIGHEST_SKILL.asComponent(LangProvider.skill(highSkillCondition.targetSkill), skills));
                    continue;
                }
                if (!(condition instanceof SkillLootConditionKill)) {
                    if (condition instanceof ValidBlockCondition) {
                        ValidBlockCondition blockCondition = (ValidBlockCondition)condition;
                        MutableComponent target = blockCondition.tag.isEmpty() ? blockCondition.block.get().getName() : Component.literal((String)blockCondition.tag.get().location().toString());
                        linesOut.add((Component)LangProvider.GLM_VALID_BLOCK.asComponent(target));
                        continue;
                    }
                    ++otherConditions;
                    continue;
                }
                SkillLootConditionKill killCondition = (SkillLootConditionKill)condition;
                maxLevel = Math.min((long)killCondition.levelMax.intValue(), Config.skills().skills().getOrDefault(killCondition.skill, SkillData.Builder.getDefault()).getMaxLevel());
                linesOut.add((Component)LangProvider.GLM_SKILL_RANGE.asComponent(LangProvider.skill(killCondition.skill), killCondition.levelMin, maxLevel));
            }
            if (otherConditions > 0) {
                linesOut.add((Component)LangProvider.GLM_OTHER_CONDITIONS.asComponent(otherConditions));
            }
            return linesOut;
        }
    }
}

