/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.utils;

import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.veinmining.VeinShapeData;
import harmonised.pmmo.setup.CommonSetup;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.LogicalSide;

public class VeinTracker {
    private static Set<BlockPos> vein;
    public static BlockPos currentTarget;
    public static VeinShapeData.ShapeType mode;

    public static void setTarget(BlockPos pos) {
        currentTarget = currentTarget == null ? pos : (currentTarget.equals((Object)pos) ? BlockPos.ZERO : pos);
    }

    public static void nextMode() {
        mode = mode.ordinal() == VeinShapeData.ShapeType.values().length - 1 ? VeinShapeData.ShapeType.values()[0] : VeinShapeData.ShapeType.values()[mode.ordinal() + 1];
    }

    public static boolean isLookingAtVeinTarget(HitResult hitResult) {
        if (!(hitResult instanceof BlockHitResult) || currentTarget == null) {
            return false;
        }
        BlockHitResult bhr = (BlockHitResult)hitResult;
        return currentTarget.equals((Object)bhr.getBlockPos());
    }

    public static Set<BlockPos> getVein() {
        if (vein == null) {
            return Collections.emptySet();
        }
        return vein;
    }

    public static void updateVein(Player player) {
        Block block = player.level().getBlockState(currentTarget).getBlock();
        int perBlock = Core.get(LogicalSide.CLIENT).getBlockConsume(block);
        int maxBlocks = perBlock <= 0 ? 0 : (int)(player.getAttribute(CommonSetup.VEIN_AMOUNT).getValue() / (double)perBlock);
        vein = new VeinShapeData(player.level(), currentTarget, maxBlocks, mode, player.getDirection()).getVein();
    }

    static {
        mode = VeinShapeData.ShapeType.AOE;
    }
}

