/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.MsLoggy;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;

public class CmdNodeParty {
    private static final String REQUEST_ID = "requestID";

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"party").then(Commands.literal((String)"create").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(CmdNodeParty::partyCreate)))).then(Commands.literal((String)"leave").executes(CmdNodeParty::partyLeave))).then(Commands.literal((String)"invite").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(CmdNodeParty::partyInvite)))).then(Commands.literal((String)"uninvite").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(CmdNodeParty::partyUninvite)))).then(Commands.literal((String)"list").executes(CmdNodeParty::listParty))).then(Commands.literal((String)"accept").then(Commands.argument((String)REQUEST_ID, (ArgumentType)UuidArgument.uuid()).executes(CmdNodeParty::partyAccept)))).then(Commands.literal((String)"decline").then(Commands.argument((String)REQUEST_ID, (ArgumentType)UuidArgument.uuid()).executes(CmdNodeParty::partyDecline)))).executes(c -> {
            System.out.println(PartyUtils.isInParty(((CommandSourceStack)c.getSource()).getPlayerOrException()));
            return 0;
        });
    }

    public static int partyCreate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        String name = StringArgumentType.getString(ctx, (String)"name");
        ServerScoreboard board = player.level().getScoreboard();
        board.addPlayerTeam(name);
        board.addPlayerToTeam(player.getScoreboardName(), board.getPlayerTeam(name));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(LangProvider.PARTY_CREATED::asComponent, false);
        return 0;
    }

    public static int partyLeave(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        PlayerTeam team = ((CommandSourceStack)ctx.getSource()).getScoreboard().getPlayersTeam(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getScoreboardName());
        ((CommandSourceStack)ctx.getSource()).getScoreboard().removePlayerFromTeam(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getScoreboardName());
        if (team != null && team.getPlayers().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).getScoreboard().removePlayerTeam(team);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(LangProvider.PARTY_LEFT::asComponent, false);
        return 0;
    }

    public static int partyInvite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        if (!PartyUtils.isInParty(((CommandSourceStack)ctx.getSource()).getPlayerOrException())) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)LangProvider.PARTY_NOT_IN.asComponent());
            return 1;
        }
        PartyUtils.inviteToParty(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (Player)player);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> LangProvider.PARTY_INVITE.asComponent(player.getDisplayName()), false);
        return 0;
    }

    public static int partyUninvite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        PartyUtils.uninviteToParty(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), (Player)player);
        return 0;
    }

    public static int listParty(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (!PartyUtils.isInParty(((CommandSourceStack)ctx.getSource()).getPlayerOrException())) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)LangProvider.PARTY_NOT_IN.asComponent());
            return 1;
        }
        List<String> memberNames = PartyUtils.getPartyMembers(((CommandSourceStack)ctx.getSource()).getPlayerOrException()).stream().map(s -> s.getName().getString()).toList();
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> LangProvider.PARTY_MEMBER_TOTAL.asComponent(memberNames.size()), false);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> LangProvider.PARTY_MEMBER_LIST.asComponent(MsLoggy.listToString(memberNames)), false);
        return 0;
    }

    public static int partyAccept(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        UUID requestID = UuidArgument.getUuid(ctx, (String)REQUEST_ID);
        PartyUtils.acceptInvite(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), requestID);
        return 0;
    }

    public static int partyDecline(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        UUID requestID = UuidArgument.getUuid(ctx, (String)REQUEST_ID);
        if (PartyUtils.declineInvite(requestID)) {
            ((CommandSourceStack)ctx.getSource()).sendSuccess(LangProvider.PARTY_DECLINE::asComponent, false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(LangProvider.PARTY_NO_INVITES::asComponent, false);
        return 0;
    }
}

