/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.neoforged.fml.LogicalSide;

public class CmdNodeStore {
    private static final String TARGET_ARG = "Target";
    private static final String SKILL_ARG = "Skill Name";

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"store").requires(p -> p.hasPermission(2))).then(Commands.argument((String)TARGET_ARG, (ArgumentType)EntityArgument.players()).then(Commands.argument((String)SKILL_ARG, (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Config.skills().skills().keySet(), (SuggestionsBuilder)builder)).executes(ctx -> CmdNodeStore.store((CommandContext<CommandSourceStack>)ctx))));
    }

    public static int store(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(ctx, (String)TARGET_ARG);
        String skillName = StringArgumentType.getString(ctx, (String)SKILL_ARG);
        MinecraftServer server = ((CommandSourceStack)ctx.getSource()).getServer();
        for (ServerPlayer player : players) {
            Long skillLevel = CmdNodeStore.getSkillLevel(skillName, player.getUUID());
            server.getScoreboard().getOrCreatePlayerScore((ScoreHolder)player, CmdNodeStore.getOrCreate(server, skillName)).set(skillLevel.intValue());
        }
        return 0;
    }

    private static Objective getOrCreate(MinecraftServer server, String objective) {
        Objective obtainedObjective = server.getScoreboard().getObjective(objective);
        if (obtainedObjective == null) {
            obtainedObjective = server.getScoreboard().addObjective(objective, ObjectiveCriteria.DUMMY, (Component)Component.translatable((String)("pmmo." + objective)), ObjectiveCriteria.RenderType.INTEGER, true, null);
        }
        return obtainedObjective;
    }

    private static long getSkillLevel(String skill, UUID pid) {
        Core core = Core.get(LogicalSide.SERVER);
        SkillData skillData = Config.skills().get(skill);
        if (skillData == null) {
            return 0L;
        }
        if (skillData.isSkillGroup()) {
            long groupLevel = 0L;
            double proportionModifier = skillData.getUseTotalLevels() ? 1.0 : skillData.groupedSkills().get().values().stream().collect(Collectors.summingDouble(Double::doubleValue));
            for (Map.Entry<String, Double> portion : skillData.groupedSkills().get().entrySet()) {
                groupLevel = (long)((double)groupLevel + (double)core.getData().getLevel(portion.getKey(), pid) * (portion.getValue() / proportionModifier));
            }
            return groupLevel;
        }
        return core.getData().getLevel(skill, pid);
    }
}

