/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.codecs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.nbt.LogicEntry;
import harmonised.pmmo.core.nbt.NBTUtils;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Items;

public record ObjectData(boolean override, Set<String> tagValues, Map<ReqType, Map<String, Long>> reqs, Map<ReqType, List<LogicEntry>> nbtReqs, Map<ResourceLocation, Integer> negativeEffects, Map<EventType, Map<String, Long>> xpValues, Map<EventType, Map<String, Map<String, Long>>> damageXpValues, Map<EventType, Map<String, List<LogicEntry>>> nbtDamageValues, Map<EventType, List<LogicEntry>> nbtXpValues, Map<ModifierDataType, Map<String, Double>> bonuses, Map<ModifierDataType, List<LogicEntry>> nbtBonuses, Map<ResourceLocation, CodecTypes.SalvageData> salvage, VeinData veinData) implements DataSource<ObjectData>
{
    private final Map<ResourceLocation, CodecTypes.SalvageData> salvage;
    public static final MapCodec<ObjectData> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("override").forGetter(od -> Optional.of(od.override())), (App)Codec.STRING.listOf().optionalFieldOf("isTagFor").forGetter(od -> Optional.of(new ArrayList<String>(od.tagValues))), (App)Codec.optionalField((String)"requirements", (Codec)Codec.simpleMap(ReqType.CODEC, CodecTypes.LONG_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])ReqType.values())).codec(), (boolean)false).forGetter(od -> Optional.of(od.reqs())), (App)Codec.optionalField((String)"nbt_requirements", (Codec)Codec.simpleMap(ReqType.CODEC, (Codec)Codec.list(LogicEntry.CODEC), (Keyable)StringRepresentable.keys((StringRepresentable[])ReqType.values())).codec(), (boolean)false).forGetter(od -> Optional.of(od.nbtReqs())), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).optionalFieldOf("negative_effect").forGetter(od -> Optional.of(od.negativeEffects())), (App)Codec.optionalField((String)"xp_values", (Codec)Codec.simpleMap(EventType.CODEC, CodecTypes.LONG_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])EventType.values())).codec(), (boolean)false).forGetter(od -> Optional.of(od.xpValues())), (App)Codec.optionalField((String)"nbt_xp_values", (Codec)Codec.simpleMap(EventType.CODEC, (Codec)Codec.list(LogicEntry.CODEC), (Keyable)StringRepresentable.keys((StringRepresentable[])EventType.values())).codec(), (boolean)false).forGetter(od -> Optional.of(od.nbtXpValues())), (App)Codec.optionalField((String)"damage_type_xp", (Codec)Codec.simpleMap(EventType.CODEC, (Codec)Codec.unboundedMap((Codec)Codec.STRING, CodecTypes.LONG_CODEC), (Keyable)StringRepresentable.keys((StringRepresentable[])EventType.DAMAGE_TYPES)).codec(), (boolean)false).forGetter(od -> Optional.of(od.damageXpValues())), (App)Codec.optionalField((String)"nbt_damage_type_xp", (Codec)Codec.simpleMap(EventType.CODEC, (Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)LogicEntry.CODEC.listOf()), (Keyable)StringRepresentable.keys((StringRepresentable[])EventType.DAMAGE_TYPES)).codec(), (boolean)false).forGetter(od -> Optional.of(od.nbtDamageValues())), (App)Codec.optionalField((String)"bonuses", (Codec)Codec.simpleMap(ModifierDataType.CODEC, CodecTypes.DOUBLE_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])ModifierDataType.values())).codec(), (boolean)false).forGetter(od -> Optional.of(od.bonuses())), (App)Codec.optionalField((String)"nbt_bonuses", (Codec)Codec.simpleMap(ModifierDataType.CODEC, (Codec)Codec.list(LogicEntry.CODEC), (Keyable)StringRepresentable.keys((StringRepresentable[])ModifierDataType.values())).codec(), (boolean)false).forGetter(od -> Optional.of(od.nbtBonuses())), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, CodecTypes.SALVAGE_CODEC).optionalFieldOf("salvage").forGetter(od -> Optional.of(od.salvage())), (App)VeinData.VEIN_DATA_CODEC.optionalFieldOf("vein_data").forGetter(od -> Optional.of(od.veinData()))).apply((Applicative)instance, (override, tags, reqs, nbtreqs, effects, xp, nbtXp, dmg, nbtdmg, bonus, nbtbonus, salvage, vein) -> new ObjectData(override.orElse(false), new HashSet<String>(tags.orElse(List.of())), DataSource.clearEmptyValues(reqs.orElse(new HashMap())), DataSource.clearEmptyValues(nbtreqs.orElse(new HashMap())), DataSource.clearEmptyValues(effects.orElse(new HashMap())), DataSource.clearEmptyValues(xp.orElse(new HashMap())), DataSource.clearEmptyValues(dmg.orElse(new HashMap())), DataSource.clearEmptyValues(nbtdmg.orElse(new HashMap())), DataSource.clearEmptyValues(nbtXp.orElse(new HashMap())), DataSource.clearEmptyValues(bonus.orElse(new HashMap())), DataSource.clearEmptyValues(nbtbonus.orElse(new HashMap())), DataSource.clearEmptyValues(salvage.orElse(new HashMap())), vein.orElse(VeinData.EMPTY))));

    public ObjectData(boolean override) {
        this(override, new HashSet<String>(), new HashMap<ReqType, Map<String, Long>>(), new HashMap<ReqType, List<LogicEntry>>(), new HashMap<ResourceLocation, Integer>(), new HashMap<EventType, Map<String, Long>>(), new HashMap<EventType, Map<String, Map<String, Long>>>(), new HashMap<EventType, Map<String, List<LogicEntry>>>(), new HashMap<EventType, List<LogicEntry>>(), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ModifierDataType, List<LogicEntry>>(), new HashMap<ResourceLocation, CodecTypes.SalvageData>(), VeinData.EMPTY);
    }

    public ObjectData() {
        this(false, new HashSet<String>(), new HashMap<ReqType, Map<String, Long>>(), new HashMap<ReqType, List<LogicEntry>>(), new HashMap<ResourceLocation, Integer>(), new HashMap<EventType, Map<String, Long>>(), new HashMap<EventType, Map<String, Map<String, Long>>>(), new HashMap<EventType, Map<String, List<LogicEntry>>>(), new HashMap<EventType, List<LogicEntry>>(), new HashMap<ModifierDataType, Map<String, Double>>(), new HashMap<ModifierDataType, List<LogicEntry>>(), new HashMap<ResourceLocation, CodecTypes.SalvageData>(), VeinData.EMPTY);
    }

    public Map<ResourceLocation, CodecTypes.SalvageData> salvage() {
        return this.salvage.entrySet().stream().filter(entry -> !BuiltInRegistries.ITEM.get((ResourceLocation)entry.getKey()).equals(Items.AIR)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public Map<String, Long> getXpValues(EventType type, CompoundTag nbt) {
        boolean isDamage = EventType.is(EventType.DAMAGE_TYPES, type);
        if (this.nbtXpValues().get(type) == null && this.nbtDamageValues().get(type) == null) {
            return isDamage ? (Map)((Map)this.damageXpValues().getOrDefault(type, new HashMap())).getOrDefault(nbt.getString("damage_type"), new HashMap()) : (Map)this.xpValues().getOrDefault(type, new HashMap());
        }
        return isDamage ? NBTUtils.getExperienceAward(((Map)this.nbtDamageValues().getOrDefault(type, new HashMap())).getOrDefault(nbt.getString("damage_type"), new ArrayList()), nbt) : NBTUtils.getExperienceAward(this.nbtXpValues().getOrDefault(type, new ArrayList()), nbt);
    }

    @Override
    public void setXpValues(EventType type, Map<String, Long> award) {
        this.xpValues().put(type, award);
    }

    @Override
    public Map<String, Double> getBonuses(ModifierDataType type, CompoundTag nbt) {
        return this.nbtBonuses().get(type) == null ? (Map)this.bonuses().getOrDefault(type, new HashMap()) : NBTUtils.getBonuses(this.nbtBonuses().get(type), nbt);
    }

    @Override
    public void setBonuses(ModifierDataType type, Map<String, Double> bonuses) {
        this.bonuses().put(type, bonuses);
    }

    @Override
    public Map<String, Long> getReqs(ReqType type, CompoundTag nbt) {
        return this.nbtReqs().get(type) == null ? (Map<String, Long>)this.reqs().getOrDefault(type, new HashMap()) : NBTUtils.getRequirement(this.nbtReqs().getOrDefault(type, new ArrayList()), nbt);
    }

    @Override
    public void setReqs(ReqType type, Map<String, Long> reqs) {
        this.reqs().put(type, reqs);
    }

    @Override
    public Map<ResourceLocation, Integer> getNegativeEffect() {
        return this.negativeEffects();
    }

    @Override
    public void setNegativeEffects(Map<ResourceLocation, Integer> neg) {
        this.negativeEffects().clear();
        this.negativeEffects().putAll(neg);
    }

    @Override
    public Set<String> getTagValues() {
        return this.tagValues();
    }

    @Override
    public ObjectData combine(ObjectData two) {
        HashSet<String> tagValues = new HashSet<String>();
        HashMap<EventType, Map<String, Long>> xpValues = new HashMap<EventType, Map<String, Long>>();
        HashMap<EventType, List<LogicEntry>> nbtXp = new HashMap<EventType, List<LogicEntry>>();
        HashMap<EventType, Map<String, Map<String, Long>>> damageXP = new HashMap<EventType, Map<String, Map<String, Long>>>();
        HashMap<EventType, Map<String, List<LogicEntry>>> nbtDamageXP = new HashMap<EventType, Map<String, List<LogicEntry>>>();
        HashMap<ModifierDataType, Map<String, Double>> bonuses = new HashMap<ModifierDataType, Map<String, Double>>();
        HashMap<ModifierDataType, List<LogicEntry>> nbtBonus = new HashMap<ModifierDataType, List<LogicEntry>>();
        HashMap<ReqType, Map<String, Long>> reqs = new HashMap<ReqType, Map<String, Long>>();
        HashMap<ReqType, List<LogicEntry>> nbtReq = new HashMap<ReqType, List<LogicEntry>>();
        HashMap<ResourceLocation, Integer> reqEffects = new HashMap<ResourceLocation, Integer>();
        HashMap<ResourceLocation, CodecTypes.SalvageData> salvage = new HashMap<ResourceLocation, CodecTypes.SalvageData>();
        VeinData[] combinedVein = new VeinData[]{this.veinData()};
        BiConsumer<ObjectData, ObjectData> bothOrNeither = (o, t) -> {
            nbtXp.putAll(o.nbtXpValues());
            t.nbtXpValues().forEach((event, logic) -> nbtXp.merge((EventType)event, (List<LogicEntry>)logic, (a, b) -> {
                ArrayList list = new ArrayList(a);
                list.addAll(b);
                return list;
            }));
            nbtDamageXP.putAll(o.nbtDamageValues());
            t.nbtDamageValues().forEach((event, map) -> map.forEach((dmg, logic) -> nbtDamageXP.computeIfAbsent((EventType)event, e -> new HashMap()).merge(dmg, logic, (oLogic, nLogic) -> {
                ArrayList list = new ArrayList(oLogic);
                list.addAll(nLogic);
                return list;
            })));
            nbtBonus.putAll(o.nbtBonuses());
            t.nbtBonuses().forEach((modifier, logic) -> nbtBonus.merge((ModifierDataType)modifier, (List<LogicEntry>)logic, (a, b) -> {
                ArrayList list = new ArrayList(a);
                list.addAll(b);
                return list;
            }));
            nbtReq.putAll(o.nbtReqs());
            t.nbtReqs().forEach((req, logic) -> nbtReq.merge((ReqType)req, (List<LogicEntry>)logic, (a, b) -> {
                ArrayList list = new ArrayList(a);
                list.addAll(b);
                return list;
            }));
            tagValues.addAll(o.tagValues());
            tagValues.addAll(t.tagValues());
            xpValues.putAll(o.xpValues());
            t.xpValues().forEach((event, map) -> xpValues.merge((EventType)event, (Map<String, Long>)map, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            damageXP.putAll(o.damageXpValues());
            t.damageXpValues().forEach((event, map) -> map.forEach((dmg, xp) -> damageXP.computeIfAbsent((EventType)event, e -> new HashMap()).merge(dmg, xp, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            })));
            bonuses.putAll(o.bonuses());
            t.bonuses().forEach((event, map) -> bonuses.merge((ModifierDataType)event, (Map<String, Double>)map, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, (o1, n1) -> o1 > n1 ? o1 : n1));
                return mergedMap;
            }));
            reqs.putAll(o.reqs());
            t.reqs().forEach((event, map) -> reqs.merge((ReqType)event, (Map<String, Long>)map, (oMap, nMap) -> {
                HashMap mergedMap = new HashMap(oMap);
                nMap.forEach((k, v) -> mergedMap.merge(k, v, Long::max));
                return mergedMap;
            }));
            reqEffects.putAll(o.negativeEffects());
            t.negativeEffects().forEach((skill, level) -> reqEffects.merge((ResourceLocation)skill, (Integer)level, Integer::max));
            salvage.putAll(o.salvage());
            t.salvage().forEach((rl, data) -> salvage.merge((ResourceLocation)rl, (CodecTypes.SalvageData)data, (oD, nD) -> CodecTypes.SalvageData.combine(oD, nD, o.override(), t.override())));
            combinedVein[0] = combinedVein[0].combine(t.veinData());
        };
        Functions.biPermutation(this, two, this.override(), two.override(), (o, t) -> {
            tagValues.addAll(o.tagValues().isEmpty() ? t.tagValues() : o.tagValues());
            xpValues.putAll(o.xpValues().isEmpty() ? t.xpValues() : o.xpValues());
            nbtXp.putAll(o.nbtXpValues().isEmpty() ? t.nbtXpValues() : o.nbtXpValues());
            damageXP.putAll(o.damageXpValues().isEmpty() ? t.damageXpValues() : o.damageXpValues());
            nbtDamageXP.putAll(o.nbtDamageValues().isEmpty() ? t.nbtDamageValues() : o.nbtDamageValues());
            bonuses.putAll(o.bonuses().isEmpty() ? t.bonuses() : o.bonuses());
            nbtBonus.putAll(o.nbtBonuses().isEmpty() ? t.nbtBonuses() : o.nbtBonuses());
            reqs.putAll(o.reqs().isEmpty() ? t.reqs() : o.reqs());
            nbtReq.putAll(o.nbtReqs().isEmpty() ? t.nbtReqs() : o.nbtReqs());
            reqEffects.putAll(o.negativeEffects().isEmpty() ? t.negativeEffects() : o.negativeEffects());
            salvage.putAll(o.salvage().isEmpty() ? t.salvage() : o.salvage());
            combinedVein[0] = o.veinData().isUnconfigured() ? t.veinData() : o.veinData();
        }, bothOrNeither, bothOrNeither);
        return new ObjectData(this.override() || two.override(), tagValues, reqs, nbtReq, reqEffects, xpValues, damageXP, nbtDamageXP, nbtXp, bonuses, nbtBonus, salvage, combinedVein[0]);
    }

    @Override
    public boolean isUnconfigured() {
        return this.reqs().values().stream().allMatch(Map::isEmpty) && this.nbtReqs().values().stream().allMatch(List::isEmpty) && this.negativeEffects().isEmpty() && this.xpValues().values().stream().allMatch(Map::isEmpty) && this.nbtXpValues().values().stream().allMatch(List::isEmpty) && this.damageXpValues().values().stream().allMatch(Map::isEmpty) && this.nbtDamageValues().values().stream().allMatch(Map::isEmpty) && this.bonuses().values().stream().allMatch(Map::isEmpty) && this.nbtBonuses().values().stream().allMatch(List::isEmpty) && this.salvage().keySet().stream().allMatch(rl -> rl.equals((Object)Reference.mc("item"))) && this.veinData().isUnconfigured();
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        boolean override = false;
        Set<String> tagValues = new HashSet<String>();
        Map<ReqType, Map<String, Long>> reqs = new HashMap<ReqType, Map<String, Long>>();
        Map<ReqType, List<LogicEntry>> nbtReqs = new HashMap<ReqType, List<LogicEntry>>();
        Map<ResourceLocation, Integer> negativeEffects = new HashMap<ResourceLocation, Integer>();
        Map<EventType, Map<String, Long>> xpValues = new HashMap<EventType, Map<String, Long>>();
        Map<EventType, Map<String, Map<String, Long>>> damageXpValues = new HashMap<EventType, Map<String, Map<String, Long>>>();
        Map<EventType, Map<String, List<LogicEntry>>> nbtDamageXpValues = new HashMap<EventType, Map<String, List<LogicEntry>>>();
        Map<EventType, List<LogicEntry>> nbtXpValues = new HashMap<EventType, List<LogicEntry>>();
        Map<ModifierDataType, Map<String, Double>> bonuses = new HashMap<ModifierDataType, Map<String, Double>>();
        Map<ModifierDataType, List<LogicEntry>> nbtBonuses = new HashMap<ModifierDataType, List<LogicEntry>>();
        Map<ResourceLocation, CodecTypes.SalvageData> salvage = new HashMap<ResourceLocation, CodecTypes.SalvageData>();
        public Optional<Integer> chargeCap = Optional.empty();
        public Optional<Double> chargeRate = Optional.empty();
        public Optional<Integer> consumeAmount = Optional.empty();

        public Builder setOverride(boolean override) {
            this.override = override;
            return this;
        }

        public Builder addTag(String ... id) {
            this.tagValues.addAll(Arrays.asList(id));
            return this;
        }

        public Builder addTag(TagKey<?> ... id) {
            List<String> ids = Arrays.stream(id).map(key -> "#" + String.valueOf(key.location())).toList();
            this.tagValues.addAll(ids);
            return this;
        }

        public Builder addReq(ReqType type, Map<String, Long> req) {
            this.reqs.put(type, req);
            return this;
        }

        public Builder addNBTReq(ReqType type, List<LogicEntry> req) {
            this.nbtReqs.put(type, req);
            return this;
        }

        public Builder addNegativeEffect(ResourceLocation id, int level) {
            this.negativeEffects.put(id, level);
            return this;
        }

        public Builder addXpValues(EventType type, Map<String, Long> awards) {
            this.xpValues.put(type, awards);
            return this;
        }

        public Builder addDamageXp(EventType type, String damageID, Map<String, Long> award) {
            this.damageXpValues.computeIfAbsent(type, t -> new HashMap()).put(damageID, award);
            return this;
        }

        public Builder addNbtDamageXp(EventType type, String damageID, List<LogicEntry> logic) {
            this.nbtDamageXpValues.computeIfAbsent(type, t -> new HashMap()).put(damageID, logic);
            return this;
        }

        public Builder addNBTXp(EventType type, List<LogicEntry> logic) {
            this.nbtXpValues.put(type, logic);
            return this;
        }

        public Builder addBonus(ModifierDataType type, Map<String, Double> bonus) {
            this.bonuses.put(type, bonus);
            return this;
        }

        public Builder addNBTBonus(ModifierDataType type, List<LogicEntry> bonus) {
            this.nbtBonuses.put(type, bonus);
            return this;
        }

        public Builder addSalvage(ResourceLocation outputID, CodecTypes.SalvageData details) {
            this.salvage.put(outputID, details);
            return this;
        }

        public Builder setVeinRate(double rate) {
            this.chargeRate = Optional.of(rate);
            return this;
        }

        public Builder setVeinCap(int cap) {
            this.chargeCap = Optional.of(cap);
            return this;
        }

        public Builder setVeinConsume(int consumed) {
            this.consumeAmount = Optional.of(consumed);
            return this;
        }

        public ObjectData end() {
            return new ObjectData(this.override, this.tagValues, this.reqs, this.nbtReqs, this.negativeEffects, this.xpValues, this.damageXpValues, this.nbtDamageXpValues, this.nbtXpValues, this.bonuses, this.nbtBonuses, this.salvage, new VeinData(this.chargeCap, this.chargeRate, this.consumeAmount));
        }
    }
}

