/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.readers;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import harmonised.pmmo.config.GlobalsConfig;
import harmonised.pmmo.config.PerksConfig;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.ConfigData;
import harmonised.pmmo.config.codecs.ServerData;
import harmonised.pmmo.features.anticheese.AntiCheeseConfig;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.network.clientpackets.CP_SyncConfig;
import harmonised.pmmo.util.MsLoggy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class ConfigListener
extends SimplePreparableReloadListener<ConfigData<?>> {
    private final Gson gson = new Gson();
    private final Map<ServerConfigs, ConfigData<?>> configs = new ConcurrentHashMap();

    public ConfigData<?> get(ServerConfigs type) {
        return this.configs.getOrDefault((Object)type, type.defaultSupplier.get());
    }

    public void set(ServerConfigs type, ConfigData<?> config) {
        this.configs.put(type, config);
    }

    public void setData(ServerConfigs type, ConfigData<?> data) {
        this.configs.put(type, data);
    }

    public ServerData server() {
        return (ServerData)this.configs.computeIfAbsent(ServerConfigs.SERVER, a -> a.defaultSupplier.get());
    }

    public AutoValueConfig autovalues() {
        return (AutoValueConfig)this.configs.computeIfAbsent(ServerConfigs.AUTOVALUES, a -> a.defaultSupplier.get());
    }

    public GlobalsConfig globals() {
        return (GlobalsConfig)this.configs.computeIfAbsent(ServerConfigs.GLOBALS, a -> a.defaultSupplier.get());
    }

    public PerksConfig perks() {
        return (PerksConfig)this.configs.computeIfAbsent(ServerConfigs.PERKS, a -> a.defaultSupplier.get());
    }

    public SkillsConfig skills() {
        return (SkillsConfig)this.configs.computeIfAbsent(ServerConfigs.SKILLS, a -> a.defaultSupplier.get());
    }

    public AntiCheeseConfig anticheese() {
        return (AntiCheeseConfig)this.configs.computeIfAbsent(ServerConfigs.ANTICHEESE, a -> a.defaultSupplier.get());
    }

    protected ConfigData<?> prepare(ResourceManager manager, ProfilerFiller profilerFiller) {
        this.configs.clear();
        for (Map.Entry entry : manager.listResources("config", file -> file.getNamespace().equals("pmmo") && file.getPath().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    String filename = ((ResourceLocation)entry.getKey()).getPath().substring(((ResourceLocation)entry.getKey()).getPath().lastIndexOf("/") + 1);
                    ServerConfigs type = ServerConfigs.fromFilename(filename.substring(0, filename.indexOf(".")));
                    if (type == null) continue;
                    JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)this.gson, (Reader)reader, JsonElement.class);
                    type.codec.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial(JsonParseException::new).ifPresent(obj -> this.configs.put(type, (ConfigData<?>)obj));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException | RuntimeException exception) {
                MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, exception.getMessage(), new Object[0]);
            }
        }
        return null;
    }

    protected void apply(ConfigData<?> p_10793_, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.DATA, "Beginning loading of data for CONFIG loader", new Object[0]);
        this.configs.forEach((type, config) -> MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.DATA, "{} config loaded with: {}", type, config));
    }

    public void subscribeAsSyncable() {
        NeoForge.EVENT_BUS.addListener(event -> {
            ServerPlayer player = event.getPlayer();
            ArrayList packets = new ArrayList();
            this.configs.forEach((key, value) -> packets.add(new CP_SyncConfig((ServerConfigs)((Object)((Object)key)), (ConfigData<?>)value)));
            if (player == null) {
                packets.forEach(x$0 -> PacketDistributor.sendToAllPlayers((CustomPacketPayload)x$0, (CustomPacketPayload[])new CustomPacketPayload[0]));
            } else {
                packets.forEach(packet -> PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]));
            }
        });
    }

    public static enum ServerConfigs implements StringRepresentable
    {
        SERVER(ServerData.CODEC, "server", ServerData::new),
        AUTOVALUES(AutoValueConfig.CODEC, "autovalues", AutoValueConfig::new),
        SKILLS(SkillsConfig.CODEC, "skills", SkillsConfig::new),
        PERKS(PerksConfig.CODEC, "perks", PerksConfig::new),
        GLOBALS(GlobalsConfig.CODEC, "globals", GlobalsConfig::new),
        ANTICHEESE(AntiCheeseConfig.CODEC, "anticheese", AntiCheeseConfig::new);

        public MapCodec<? extends ConfigData<?>> codec;
        public String filename;
        public Supplier<ConfigData<?>> defaultSupplier;
        public static final Codec<ServerConfigs> CODEC;
        private static final Map<String, ServerConfigs> BY_NAME;
        public static final Codec<ConfigData<?>> MAPPER;

        private ServerConfigs(MapCodec<? extends ConfigData<?>> codec, String filename, Supplier<ConfigData<?>> defaultSupplier) {
            this.codec = codec;
            this.filename = filename;
            this.defaultSupplier = defaultSupplier;
        }

        public MapCodec<? extends ConfigData<?>> codec() {
            return this.codec;
        }

        public String getSerializedName() {
            return this.name();
        }

        public static ServerConfigs byName(String name) {
            return BY_NAME.get(name);
        }

        public static ServerConfigs create(String name, MapCodec<? extends ConfigData<?>> codec, String filename, Supplier<ConfigData<?>> defaultSupplier) {
            throw new IllegalStateException("Enum not extended");
        }

        public static ServerConfigs fromFilename(String filename) {
            return Arrays.stream(ServerConfigs.values()).filter(sc -> sc.filename.equals(filename)).findFirst().orElse(null);
        }

        static {
            CODEC = StringRepresentable.fromEnum(ServerConfigs::values);
            BY_NAME = Arrays.stream(ServerConfigs.values()).collect(Collectors.toMap(ServerConfigs::getSerializedName, s -> s));
            MAPPER = Codec.lazyInitialized(() -> CODEC.dispatch(ConfigData::getType, ServerConfigs::codec));
        }
    }
}

