/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.config.scripting;

import com.mojang.datafixers.util.Pair;
import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.MobModifier;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.config.readers.ConfigListener;
import harmonised.pmmo.config.scripting.NodeConsumer;
import harmonised.pmmo.config.scripting.TargetSelector;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.neoforged.fml.LogicalSide;

public class Functions {
    public static final Map<String, NodeConsumer> KEYWORDS = new HashMap<String, NodeConsumer>();
    public static final Map<String, TargetSelector> TARGETORS = new HashMap<String, TargetSelector>();
    public static final Pattern operationRegex = Pattern.compile("(>=|<=|>|<|=)\\s*([-+]?\\d*\\.?\\d+(?:[eE][-+]?\\d+)?)");
    public static final Pattern attributeRegex = Pattern.compile("(.*?)(\\*\\*|\\+|\\*)(.*)");

    public static Map<String, Long> mapValue(String value) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        String[] elements = value.replaceAll("\\)", "").split(",");
        for (int i = 0; i <= elements.length - 2; i += 2) {
            outMap.put(elements[i], Long.valueOf(elements[i + 1]));
        }
        return outMap;
    }

    public static Map<String, Double> doubleMap(String value) {
        HashMap<String, Double> outMap = new HashMap<String, Double>();
        String[] elements = value.replaceAll("\\)", "").split(",");
        for (int i = 0; i <= elements.length - 2; i += 2) {
            outMap.put(elements[i], Double.valueOf(elements[i + 1]));
        }
        return outMap;
    }

    public static double getDouble(Map<String, String> values) {
        return Double.parseDouble(values.getOrDefault("value", "0"));
    }

    public static ResourceLocation getId(Map<String, String> values) {
        return Reference.of(values.getOrDefault("value", "pmmo_scripting:missing_value"));
    }

    public static boolean getBool(Map<String, String> values) {
        return Boolean.parseBoolean(values.getOrDefault("value", "false"));
    }

    public static float getFloat(Map<String, String> values) {
        return Float.parseFloat(values.getOrDefault("value", "0"));
    }

    public static long getLong(Map<String, String> values) {
        return Long.parseLong(values.getOrDefault("value", "0"));
    }

    public static int getInt(Map<String, String> values) {
        return Integer.parseInt(values.getOrDefault("value", "0"));
    }

    private static MobModifier getModifier(String raw) {
        AttributeModifier.Operation operation;
        Matcher match = attributeRegex.matcher(raw);
        if (!match.find()) {
            return null;
        }
        ResourceLocation attrId = Reference.of(match.group(1));
        switch (match.group(2)) {
            case "+": {
                AttributeModifier.Operation operation2 = AttributeModifier.Operation.ADD_VALUE;
                break;
            }
            case "*": {
                AttributeModifier.Operation operation2 = AttributeModifier.Operation.ADD_MULTIPLIED_BASE;
                break;
            }
            case "**": {
                AttributeModifier.Operation operation2 = AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL;
                break;
            }
            default: {
                AttributeModifier.Operation operation2 = operation = null;
            }
        }
        if (operation == null) {
            return null;
        }
        double modificationValue = Double.parseDouble(match.group(3));
        return new MobModifier(attrId, modificationValue, operation);
    }

    static {
        KEYWORDS.put("xp", (param, id, type, value) -> {
            EventType event = EventType.byName(param.toUpperCase());
            if (event == null) {
                return;
            }
            Map<String, Long> award = Functions.mapValue(value.getOrDefault("award", ""));
            if (award.isEmpty()) {
                return;
            }
            APIUtils.registerXpAward(type, id, event, award, true);
        });
        KEYWORDS.put("deal_damage", (param, id, type, value) -> {
            Map<String, Long> award = Functions.mapValue(value.getOrDefault("award", ""));
            if (award.isEmpty()) {
                return;
            }
            APIUtils.registerDamageXpAward(type, id, EventType.DEAL_DAMAGE, param, award, true);
        });
        KEYWORDS.put("receive_damage", (param, id, type, value) -> {
            Map<String, Long> award = Functions.mapValue(value.getOrDefault("award", ""));
            if (award.isEmpty()) {
                return;
            }
            APIUtils.registerDamageXpAward(type, id, EventType.RECEIVE_DAMAGE, param, award, true);
        });
        KEYWORDS.put("mitigate_damage", (param, id, type, value) -> {
            Map<String, Long> award = Functions.mapValue(value.getOrDefault("award", ""));
            if (award.isEmpty()) {
                return;
            }
            APIUtils.registerDamageXpAward(type, id, EventType.MITIGATE_DAMAGE, param, award, true);
        });
        KEYWORDS.put("req", (param, id, type, value) -> {
            ReqType reqType = ReqType.byName(param.toUpperCase());
            if (reqType == null) {
                return;
            }
            Map<String, Long> reqs = Functions.mapValue(value.getOrDefault("require", ""));
            if (reqs.isEmpty()) {
                return;
            }
            APIUtils.registerRequirement(type, id, reqType, reqs, true);
        });
        KEYWORDS.put("bonus", (param, id, type, value) -> {
            ModifierDataType bonusType = ModifierDataType.byName(param.toUpperCase());
            if (bonusType == null) {
                return;
            }
            Map<String, Double> bonus = Functions.doubleMap(value.getOrDefault("value", ""));
            if (bonus.isEmpty()) {
                return;
            }
            APIUtils.registerBonus(type, id, bonusType, bonus, true);
        });
        KEYWORDS.put("vein_charge", (param, id, type, value) -> {
            Object source = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            if (source instanceof ObjectData) {
                ObjectData data = (ObjectData)source;
                VeinData current = data.veinData();
                APIUtils.registerVeinData(type, id, current.chargeCap, Optional.of(Double.valueOf(param)), current.consumeAmount, true);
            }
        });
        KEYWORDS.put("vein_capacity", (param, id, type, value) -> {
            Object source = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            if (source instanceof ObjectData) {
                ObjectData data = (ObjectData)source;
                VeinData current = data.veinData();
                APIUtils.registerVeinData(type, id, Optional.of(Integer.valueOf(param)), current.chargeRate, current.consumeAmount, true);
            }
        });
        KEYWORDS.put("vein_consume", (param, id, type, value) -> {
            Object source = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            if (source instanceof ObjectData) {
                ObjectData data = (ObjectData)source;
                VeinData current = data.veinData();
                APIUtils.registerVeinData(type, id, current.chargeCap, current.chargeRate, Optional.of(Integer.valueOf(param)), true);
            }
        });
        KEYWORDS.put("mob_scale", (param, id, type, value) -> {
            ResourceLocation entityID = ResourceLocation.parse((String)param);
            ArrayList<MobModifier> modifiers = new ArrayList<MobModifier>();
            for (String raw : value.getOrDefault("attribute", "").split(",")) {
                MobModifier modifier = Functions.getModifier(raw);
                if (modifier == null) continue;
                modifiers.add(modifier);
            }
            APIUtils.registerMobModifier(type, id, Map.of(entityID, modifiers), true);
        });
        KEYWORDS.put("positive_effect", (param, id, type, value) -> {
            Object data = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            String[] splitParam = param.split(",");
            if (splitParam.length < 2) {
                return;
            }
            ResourceLocation effectID = ResourceLocation.parse((String)splitParam[0]);
            int amplifier = Integer.parseInt(splitParam[1]);
            HashMap<ResourceLocation, Integer> current = new HashMap<ResourceLocation, Integer>(data.getPositiveEffect());
            current.put(effectID, amplifier);
            APIUtils.registerPositiveEffect(type, id, current, true);
        });
        KEYWORDS.put("negative_effect", (param, id, type, value) -> {
            Object data = Core.get(LogicalSide.SERVER).getLoader().getLoader(type).getData(id);
            String[] splitParam = param.split(",");
            if (splitParam.length < 2) {
                return;
            }
            ResourceLocation effectID = ResourceLocation.parse((String)splitParam[0]);
            int amplifier = Integer.parseInt(splitParam[1]);
            HashMap<ResourceLocation, Integer> current = new HashMap<ResourceLocation, Integer>(data.getNegativeEffect());
            current.put(effectID, amplifier);
            APIUtils.registerNegativeEffect(type, id, current, true);
        });
        KEYWORDS.put("salvage", (param, id, type, value) -> {
            APIUtils.SalvageBuilder builder = APIUtils.SalvageBuilder.start();
            if (value.containsKey("chance_level")) {
                builder.setChancePerLevel(Functions.doubleMap((String)value.get("chance_level")));
            }
            if (value.containsKey("chance_base")) {
                builder.setBaseChance(Double.parseDouble((String)value.get("chance_base")));
            }
            if (value.containsKey("chance_max")) {
                builder.setMaxChance(Double.parseDouble((String)value.get("chance_max")));
            }
            if (value.containsKey("level_req")) {
                builder.setLevelReq(Functions.mapValue((String)value.get("level_req")));
            }
            if (value.containsKey("salvage_award")) {
                builder.setXpAward(Functions.mapValue((String)value.get("salvage_award")));
            }
            if (value.containsKey("max_drops")) {
                builder.setSalvageMax(Integer.parseInt((String)value.get("max_drops")));
            }
            ResourceLocation drop = ResourceLocation.parse((String)param);
            APIUtils.registerSalvage(id, Map.of(drop, builder), true);
        });
        KEYWORDS.put("set", (param, configId, type, value) -> {
            ConfigListener.ServerConfigs configType = ConfigListener.ServerConfigs.fromFilename(configId.getPath());
            if (configType == null) {
                MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, "config type value invalid: %s", configId.getPath());
            } else {
                Config.CONFIG.set(configType, Config.CONFIG.get(configType).getFromScripting(param, value));
            }
        });
        TARGETORS.put("config", (param, access) -> new TargetSelector.Selection(ObjectType.PLAYER, List.of(Reference.rl(param))));
        TARGETORS.put("food", (param, access) -> {
            String[] exprStr = param.split(",");
            float nutVal = 0.0f;
            float satVal = 0.0f;
            Operator nutOp = Operator.GTE;
            Operator satOp = Operator.GTE;
            for (String str : exprStr) {
                Matcher match = operationRegex.matcher(str);
                if (!match.find()) continue;
                if (str.startsWith("nutrition")) {
                    nutOp = Operator.fromString(match.group(1));
                    nutVal = Float.valueOf(match.group(2)).floatValue();
                    continue;
                }
                if (!str.startsWith("saturation")) continue;
                satOp = Operator.fromString(match.group(1));
                satVal = Float.valueOf(match.group(2)).floatValue();
            }
            Pair values = Pair.of((Object)Float.valueOf(nutVal), (Object)Float.valueOf(satVal));
            Pair ops = Pair.of((Object)((Object)nutOp), (Object)((Object)satOp));
            List<ResourceLocation> food = access.lookupOrThrow(Registries.ITEM).entrySet().stream().filter(entry -> {
                FoodProperties props;
                Object patt0$temp = ((Item)entry.getValue()).components().get(DataComponents.FOOD);
                return patt0$temp instanceof FoodProperties && ((Operator)((Object)((Object)((Object)ops.getFirst())))).evaluation.test(Float.valueOf(Integer.valueOf((props = (FoodProperties)patt0$temp).nutrition()).floatValue()), (Float)values.getFirst()) && ((Operator)((Object)((Object)((Object)ops.getSecond())))).evaluation.test(Float.valueOf(props.saturation()), (Float)values.getSecond());
            }).map(entry -> ((ResourceKey)entry.getKey()).location()).toList();
            return new TargetSelector.Selection(ObjectType.ITEM, food);
        });
        TARGETORS.put("tool", (param, access) -> {
            ArrayList<ResourceLocation> tools = new ArrayList<ResourceLocation>();
            if (param.isEmpty()) {
                tools.addAll(access.lookupOrThrow(Registries.ITEM).entrySet().stream().filter(entry -> ((Item)entry.getValue()).components().has(DataComponents.TOOL)).map(entry -> ((ResourceKey)entry.getKey()).location()).toList());
            } else {
                ResourceLocation tag = Reference.of(param);
                tools.addAll(RegistryUtil.getTagMemberIds(access, Registries.ITEM, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag)));
            }
            return new TargetSelector.Selection(ObjectType.ITEM, tools);
        });
        TARGETORS.put("armor", (param, access) -> {
            ArrayList<ResourceLocation> tools = new ArrayList<ResourceLocation>();
            if (param.isEmpty()) {
                tools.addAll(access.lookupOrThrow(Registries.ITEM).entrySet().stream().filter(entry -> ((Item)entry.getValue()).components().has(DataComponents.EQUIPPABLE)).map(entry -> ((ResourceKey)entry.getKey()).location()).toList());
            } else {
                ResourceLocation tag = Reference.of(param);
                tools.addAll(RegistryUtil.getTagMemberIds(access, Registries.ITEM, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag)));
            }
            return new TargetSelector.Selection(ObjectType.ITEM, tools);
        });
        TARGETORS.put("weapon", (param, access) -> {
            ArrayList<ResourceLocation> tools = new ArrayList<ResourceLocation>();
            if (param.isEmpty()) {
                tools.addAll(access.lookupOrThrow(Registries.ITEM).entrySet().stream().filter(entry -> ((Item)entry.getValue()).components().has(DataComponents.DAMAGE)).map(entry -> ((ResourceKey)entry.getKey()).location()).toList());
            } else {
                ResourceLocation tag = Reference.of(param);
                tools.addAll(RegistryUtil.getTagMemberIds(access, Registries.ITEM, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)tag)));
            }
            return new TargetSelector.Selection(ObjectType.ITEM, tools);
        });
    }

    private static enum Operator {
        GT((one, two) -> one.floatValue() > two.floatValue()),
        LT((one, two) -> one.floatValue() < two.floatValue()),
        EQ(Float::equals),
        GTE((one, two) -> one.floatValue() >= two.floatValue()),
        LTE((one, two) -> one.floatValue() <= two.floatValue());

        public final BiPredicate<Float, Float> evaluation;

        private Operator(BiPredicate<Float, Float> evaluation) {
            this.evaluation = evaluation;
        }

        public static Operator fromString(String str) {
            return switch (str) {
                case ">" -> GT;
                case "<" -> LT;
                case "=" -> EQ;
                case ">=" -> GTE;
                case "<=" -> LTE;
                default -> null;
            };
        }
    }
}

