/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.utils.DataMirror;
import harmonised.pmmo.compat.curios.CuriosCompat;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.DataSource;
import harmonised.pmmo.config.codecs.EnhancementsData;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.config.readers.CoreLoader;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.features.anticheese.CheeseTracker;
import harmonised.pmmo.features.autovalues.AutoValues;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.network.Networking;
import harmonised.pmmo.network.clientpackets.CP_ClearData;
import harmonised.pmmo.registry.EventTriggerRegistry;
import harmonised.pmmo.registry.LevelRegistry;
import harmonised.pmmo.registry.PerkRegistry;
import harmonised.pmmo.registry.PredicateRegistry;
import harmonised.pmmo.registry.TooltipRegistry;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.storage.Experience;
import harmonised.pmmo.storage.PmmoSavedData;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class Core {
    private static final Map<LogicalSide, Function<LogicalSide, Core>> INSTANCES = Map.of(LogicalSide.CLIENT, Functions.memoize(Core::new), LogicalSide.SERVER, Functions.memoize(Core::new));
    private final CoreLoader loader;
    private final PredicateRegistry predicates;
    private final EventTriggerRegistry eventReg;
    private final TooltipRegistry tooltips;
    private final PerkRegistry perks;
    private final LevelRegistry lvlProvider;
    private final IDataStorage data;
    private final LogicalSide side;
    private ResourceLocation playerID = Reference.mc("player");
    private final Map<UUID, BlockPos> markers = new HashMap<UUID, BlockPos>();

    private Core(LogicalSide side) {
        this.loader = new CoreLoader();
        this.predicates = new PredicateRegistry();
        this.eventReg = new EventTriggerRegistry();
        this.tooltips = new TooltipRegistry();
        this.perks = new PerkRegistry();
        this.lvlProvider = new LevelRegistry();
        this.data = side.equals((Object)LogicalSide.SERVER) ? new PmmoSavedData() : new DataMirror();
        this.side = side;
    }

    public static Core get(LogicalSide side) {
        return INSTANCES.get(side).apply(side);
    }

    public static Core get(Level level) {
        return Core.get(level.isClientSide() ? LogicalSide.CLIENT : LogicalSide.SERVER);
    }

    public void resetDataForReload() {
        this.tooltips.clearRegistry();
        if (this.side.equals((Object)LogicalSide.SERVER)) {
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                return;
            }
            for (ServerPlayer player : ServerLifecycleHooks.getCurrentServer().getPlayerList().getPlayers()) {
                Networking.sendToClient(new CP_ClearData(), player);
            }
        }
    }

    public CoreLoader getLoader() {
        return this.loader;
    }

    public PredicateRegistry getPredicateRegistry() {
        return this.predicates;
    }

    public EventTriggerRegistry getEventTriggerRegistry() {
        return this.eventReg;
    }

    public TooltipRegistry getTooltipRegistry() {
        return this.tooltips;
    }

    public PerkRegistry getPerkRegistry() {
        return this.perks;
    }

    public LevelRegistry getLevelProvider() {
        return this.lvlProvider;
    }

    public IDataStorage getData() {
        return this.data.get();
    }

    public LogicalSide getSide() {
        return this.side;
    }

    public void awardXP(List<ServerPlayer> players, Map<String, Long> xpValues) {
        if (players.size() > 1) {
            xpValues.replaceAll((skill, value) -> Double.valueOf((double)value.longValue() * Config.server().party().bonus().getOrDefault(skill, 1.0)).longValue());
        }
        CoreUtils.processSkillGroupXP(xpValues);
        new HashMap<String, Long>(xpValues).forEach((skill, value) -> xpValues.put((String)skill, (long)((double)value.longValue() * Config.server().levels().skillModifiers().getOrDefault(skill, Config.server().levels().globalModifier()))));
        for (int i = 0; i < players.size(); ++i) {
            if (players.get(i) instanceof FakePlayer || players.get(i).isDeadOrDying()) continue;
            for (Map.Entry<String, Long> award : xpValues.entrySet()) {
                long xpAward = award.getValue();
                if (players.size() > 1) {
                    xpAward = Double.valueOf((double)xpAward * (Config.server().party().bonus().getOrDefault(award.getKey(), 1.0) * (double)players.size())).longValue();
                }
                this.getData().addXp(players.get(i).getUUID(), award.getKey(), xpAward / (long)players.size());
            }
        }
    }

    public Map<String, Long> getExperienceAwards(EventType type, ItemStack stack, Player player, CompoundTag dataIn) {
        ResourceLocation itemID = RegistryUtil.getId(player.level().registryAccess(), stack);
        dataIn.merge(TagUtils.stackTag(stack, player.level()));
        HashMap<String, Long> xpGains = this.tooltips.xpGainTooltipExists(itemID, type) ? this.tooltips.getItemXpGainTooltipData(itemID, type, stack) : new HashMap<String, Long>();
        return this.getCommonXpAwardData(xpGains, type, itemID, player, ObjectType.ITEM, dataIn);
    }

    public Map<String, Long> getExperienceAwards(MobEffectInstance mei, Player player, CompoundTag dataIn) {
        ResourceLocation effectID = RegistryUtil.getId((MobEffect)mei.getEffect().value());
        EnhancementsData data = (EnhancementsData)this.loader.getLoader(ObjectType.EFFECT).getData().get(effectID);
        HashMap<String, Long> xpGains = new HashMap<String, Long>();
        if (data != null) {
            ((Map)data.skillArray().getOrDefault(mei.getAmplifier() + 1, new HashMap())).forEach((skill, value) -> xpGains.put((String)skill, Long.valueOf(value)));
        }
        return this.getCommonXpAwardData(xpGains, EventType.EFFECT, effectID, player, ObjectType.EFFECT, dataIn);
    }

    public Map<String, Long> getExperienceAwards(EventType type, BlockPos pos, Level level, Player player, CompoundTag dataIn) {
        ResourceLocation res = RegistryUtil.getId(level.getBlockState(pos));
        BlockEntity tile = level.getBlockEntity(pos);
        dataIn.merge(TagUtils.tileTag(tile));
        dataIn.put("state", (Tag)TagUtils.stateTag(level.getBlockState(pos)));
        HashMap<String, Long> xpGains = tile != null && this.tooltips.xpGainTooltipExists(res, type) ? this.tooltips.getBlockXpGainTooltipData(res, type, tile) : new HashMap<String, Long>();
        return this.getCommonXpAwardData(xpGains, type, res, player, ObjectType.BLOCK, dataIn);
    }

    public Map<String, Long> getExperienceAwards(EventType type, Entity entity, Player player, CompoundTag dataIn) {
        ResourceLocation entityID = entity.getType().equals(EntityType.PLAYER) ? this.playerID : RegistryUtil.getId(entity);
        dataIn.merge(TagUtils.entityTag(entity));
        HashMap<String, Long> xpGains = this.tooltips.xpGainTooltipExists(entityID, type) ? this.tooltips.getEntityXpGainTooltipData(entityID, type, entity) : new HashMap<String, Long>();
        return this.getCommonXpAwardData(xpGains, type, entityID, player, ObjectType.ENTITY, dataIn);
    }

    public Map<String, Long> getCommonXpAwardData(Map<String, Long> xpGains, EventType type, ResourceLocation objectID, Player player, ObjectType oType, CompoundTag tag) {
        Object[] loggables = new String[4];
        if (xpGains.isEmpty()) {
            xpGains = CoreUtils.mergeXpMapsWithSummateCondition(tag.contains("serialized_award_map") ? CoreUtils.deserializeAwardMap(tag.getCompoundOrEmpty("serialized_award_map")) : new HashMap(), this.getObjectExperienceMap(oType, objectID, type, tag));
            if (Config.autovalue().enabled() && xpGains.isEmpty()) {
                xpGains = AutoValues.getExperienceAward(type, objectID, oType);
            }
        }
        loggables[0] = type.name();
        loggables[1] = MsLoggy.mapToString(xpGains);
        if (player != null && !(player instanceof FakePlayer)) {
            CoreUtils.applyXpModifiers(xpGains, this.getConsolidatedModifierMap(player));
        }
        loggables[2] = MsLoggy.mapToString(xpGains);
        ArrayList<ResourceLocation> source = new ArrayList<ResourceLocation>();
        source.add(objectID);
        if (tag.contains("damage_type")) {
            source.add(Reference.of((String)tag.getString("damage_type").get()));
        }
        CheeseTracker.applyAntiCheese(type, source, player, xpGains);
        loggables[3] = MsLoggy.mapToString(xpGains);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.XP, "XP: {} base:{}, afterBonus:{}, afterAntiCheese:{}", loggables);
        return xpGains;
    }

    public Map<String, Long> getObjectExperienceMap(ObjectType type, ResourceLocation objectID, EventType eventType, CompoundTag tag) {
        DataSource data = (DataSource)this.loader.getLoader(type).getData().get(objectID);
        return new HashMap<String, Long>(data != null ? MsLoggy.DEBUG.logAndReturn(data.getXpValues(eventType, tag), MsLoggy.LOG_CODE.XP, "getObjectExperienceMap= {}", new Object[0]) : new HashMap());
    }

    public Map<String, Double> getObjectModifierMap(ObjectType type, ResourceLocation objectID, ModifierDataType modifierType, CompoundTag tag) {
        DataSource data = (DataSource)this.loader.getLoader(type).getData().get(objectID);
        return new HashMap<String, Double>(data != null ? data.getBonuses(modifierType, tag) : new HashMap());
    }

    public Map<String, Double> getConsolidatedModifierMap(Player player) {
        HashMap<String, Double> mapOut = new HashMap<String, Double>();
        if (player instanceof FakePlayer) {
            return mapOut;
        }
        ResourceLocation biomeID = RegistryUtil.getId(player.level().getBiome(player.blockPosition()));
        for (Map.Entry<String, Double> entry : this.getObjectModifierMap(ObjectType.BIOME, biomeID, ModifierDataType.BIOME, new CompoundTag()).entrySet()) {
            mapOut.merge(entry.getKey(), entry.getValue(), (o, n) -> o + (n - 1.0));
        }
        ResourceLocation dimensionID = player.level().dimension().location();
        for (Map.Entry<String, Double> entry : this.getObjectModifierMap(ObjectType.DIMENSION, dimensionID, ModifierDataType.DIMENSION, new CompoundTag()).entrySet()) {
            mapOut.merge(entry.getKey(), entry.getValue(), (o, n) -> o + (n - 1.0));
        }
        HashMap hashMap = new HashMap();
        for (ItemStack stack2 : List.of(player.getOffhandItem(), player.getMainHandItem())) {
            ResourceLocation itemID = RegistryUtil.getId(player.level().registryAccess(), stack2);
            Map<String, Double> map = this.tooltips.bonusTooltipExists(itemID, ModifierDataType.HELD) ? this.tooltips.getBonusTooltipData(itemID, ModifierDataType.HELD, stack2) : this.getObjectModifierMap(ObjectType.ITEM, itemID, ModifierDataType.HELD, TagUtils.stackTag(stack2, player.level()));
            for (Map.Entry<String, Double> modMap : map.entrySet()) {
                mapOut.merge(modMap.getKey(), modMap.getValue(), (o, n) -> o + (n - 1.0));
            }
        }
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        Reference.ARMOR_SLOTS.forEach(slot -> wornItems.add(player.getItemBySlot(slot)));
        if (CuriosCompat.hasCurio) {
            arrayList.addAll(CuriosCompat.getItems(player));
        }
        arrayList.forEach(stack -> {
            ResourceLocation itemID = RegistryUtil.getId(player.level().registryAccess(), stack);
            Map<String, Double> modifers = this.tooltips.bonusTooltipExists(itemID, ModifierDataType.WORN) ? this.tooltips.getBonusTooltipData(itemID, ModifierDataType.WORN, (ItemStack)stack) : this.getObjectModifierMap(ObjectType.ITEM, itemID, ModifierDataType.WORN, TagUtils.stackTag(stack, player.level()));
            for (Map.Entry<String, Double> modMap : modifers.entrySet()) {
                mapOut.merge(modMap.getKey(), modMap.getValue(), (o, n) -> o + (n - 1.0));
            }
        });
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.XP, "Modifier Map: {}", MsLoggy.mapToString(mapOut));
        return this.loader.PLAYER_LOADER.getData(Reference.mc(player.getUUID().toString())).mergeWithPlayerBonuses(CoreUtils.processSkillGroupBonus(mapOut));
    }

    public boolean isActionPermitted(ReqType type, ItemStack stack, Player player) {
        if (player instanceof FakePlayer || !Config.server().requirements().isEnabled(type) || this.getLoader().PLAYER_LOADER.getData(Reference.mc(player.getUUID().toString())).ignoreReq()) {
            return true;
        }
        ResourceLocation itemID = RegistryUtil.getId(player.level().registryAccess(), stack);
        return this.predicates.predicateExists(itemID, type) ? this.predicates.checkPredicateReq(player, stack, type) : this.doesPlayerMeetReq(player.getUUID(), this.getReqMap(type, stack, player.level(), false));
    }

    public boolean isActionPermitted(ReqType type, BlockPos pos, Player player) {
        if (player instanceof FakePlayer || !Config.server().requirements().isEnabled(type) || this.getLoader().PLAYER_LOADER.getData(Reference.mc(player.getUUID().toString())).ignoreReq()) {
            return true;
        }
        BlockEntity tile = player.level().getBlockEntity(pos);
        ResourceLocation res = RegistryUtil.getId(player.level().getBlockState(pos));
        return tile != null && this.predicates.predicateExists(res, type) ? this.predicates.checkPredicateReq(player, tile, type) : this.doesPlayerMeetReq(player.getUUID(), this.getReqMap(type, pos, player.level()));
    }

    public boolean isActionPermitted(ReqType type, Entity entity, Player player) {
        if (player instanceof FakePlayer || !Config.server().requirements().isEnabled(type) || this.getLoader().PLAYER_LOADER.getData(Reference.mc(player.getUUID().toString())).ignoreReq()) {
            return true;
        }
        ResourceLocation entityID = entity.getType().equals(EntityType.PLAYER) ? this.playerID : RegistryUtil.getId(entity);
        return this.predicates.predicateExists(entityID, type) ? this.predicates.checkPredicateReq(player, entity, type) : this.doesPlayerMeetReq(player.getUUID(), this.getReqMap(type, entity));
    }

    public boolean isActionPermitted(ReqType type, Holder<Biome> biome, Player player) {
        if (type != ReqType.TRAVEL) {
            return false;
        }
        if (player instanceof FakePlayer || !Config.server().requirements().isEnabled(type) || this.getLoader().PLAYER_LOADER.getData(Reference.mc(player.getUUID().toString())).ignoreReq()) {
            return true;
        }
        return this.doesPlayerMeetReq(player.getUUID(), this.getObjectSkillMap(ObjectType.BIOME, RegistryUtil.getId(biome), type, new CompoundTag()));
    }

    public boolean isActionPermitted(ReqType type, ResourceKey<Level> dimension, Player player) {
        if (type != ReqType.TRAVEL) {
            return false;
        }
        if (player instanceof FakePlayer || !Config.server().requirements().isEnabled(type) || this.getLoader().PLAYER_LOADER.getData(Reference.mc(player.getUUID().toString())).ignoreReq()) {
            return true;
        }
        return this.doesPlayerMeetReq(player.getUUID(), this.getObjectSkillMap(ObjectType.DIMENSION, dimension.location(), type, new CompoundTag()));
    }

    public boolean doesPlayerMeetReq(UUID playerID, Map<String, Long> requirements) {
        CoreUtils.processSkillGroupReqs(requirements);
        for (Map.Entry<String, Long> req : requirements.entrySet()) {
            long skillLevel = this.getData().getLevel(req.getKey(), playerID);
            if (Config.skills().get(req.getKey()).isSkillGroup()) {
                SkillData skillData = Config.skills().get(req.getKey());
                if (!skillData.getUseTotalLevels()) continue;
                long total = skillData.getGroup().keySet().stream().map(skill -> this.getData().getLevel((String)skill, playerID)).mapToLong(Long::longValue).sum();
                if (req.getValue() <= total) continue;
                return false;
            }
            if (req.getValue() <= skillLevel) continue;
            return false;
        }
        return true;
    }

    public Map<String, Long> getObjectSkillMap(ObjectType type, ResourceLocation objectID, ReqType reqType, CompoundTag nbt) {
        DataSource data = (DataSource)this.loader.getLoader(type).getData().get(objectID);
        return new HashMap<String, Long>(data != null ? data.getReqs(reqType, nbt) : new HashMap());
    }

    public Map<String, Long> getReqMap(ReqType reqType, ItemStack stack, Level level, boolean ignoreEnchants) {
        HashMap<String, Long> reqMap;
        ResourceLocation itemID = RegistryUtil.getId(level.registryAccess(), stack);
        Map<Object, Object> map = reqMap = ignoreEnchants ? new HashMap() : this.getEnchantReqs(stack);
        if (this.tooltips.requirementTooltipExists(itemID, reqType)) {
            this.tooltips.getItemRequirementTooltipData(itemID, reqType, stack).forEach((skill, lvl) -> reqMap.merge((String)skill, (Long)lvl, Long::max));
        }
        return this.getCommonReqData(reqMap, ObjectType.ITEM, itemID, reqType, TagUtils.stackTag(stack, level));
    }

    public Map<String, Long> getEnchantReqs(ItemStack stack) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        if (!stack.isEnchanted() || !Config.server().requirements().isEnabled(ReqType.USE_ENCHANTMENT)) {
            return outMap;
        }
        for (Object2IntMap.Entry enchant : stack.getEnchantments().entrySet()) {
            this.getEnchantmentReqs(((ResourceKey)((Holder)enchant.getKey()).unwrapKey().get()).location(), enchant.getValue() - 1).forEach((skill, level) -> outMap.merge((String)skill, (Long)level, Long::max));
        }
        return outMap;
    }

    public Map<String, Long> getReqMap(ReqType reqType, Entity entity) {
        ResourceLocation entityID = entity.getType().equals(EntityType.PLAYER) ? Reference.mc("player") : RegistryUtil.getId(entity);
        HashMap<String, Long> reqMap = this.tooltips.requirementTooltipExists(entityID, reqType) ? this.tooltips.getEntityRequirementTooltipData(entityID, reqType, entity) : new HashMap<String, Long>();
        return this.getCommonReqData(reqMap, ObjectType.ENTITY, entityID, reqType, TagUtils.entityTag(entity));
    }

    public Map<String, Long> getReqMap(ReqType reqType, BlockPos pos, Level level) {
        BlockEntity tile = level.getBlockEntity(pos);
        ResourceLocation blockID = RegistryUtil.getId(level.getBlockState(pos));
        HashMap<String, Long> reqMap = tile != null && this.tooltips.requirementTooltipExists(blockID, reqType) ? this.tooltips.getBlockRequirementTooltipData(blockID, reqType, tile) : new HashMap<String, Long>();
        CompoundTag dataIn = TagUtils.tileTag(tile);
        dataIn.put("state", (Tag)TagUtils.stateTag(level.getBlockState(pos)));
        return this.getCommonReqData(reqMap, ObjectType.BLOCK, blockID, reqType, dataIn);
    }

    public Map<String, Long> getCommonReqData(Map<String, Long> reqsIn, ObjectType oType, ResourceLocation objectID, ReqType type, CompoundTag tag) {
        if (reqsIn.isEmpty()) {
            reqsIn = this.getObjectSkillMap(oType, objectID, type, tag);
            if (Config.autovalue().enabled() && reqsIn.isEmpty()) {
                reqsIn = AutoValues.getRequirements(type, objectID, oType);
            }
        }
        return CoreUtils.processSkillGroupReqs(reqsIn);
    }

    public Map<String, Long> getEnchantmentReqs(ResourceLocation enchantID, int enchantLvl) {
        return ((EnhancementsData)this.loader.getLoader(ObjectType.ENCHANTMENT).getData(enchantID)).skillArray().getOrDefault(enchantLvl, new HashMap());
    }

    public void getSalvage(ServerPlayer player) {
        ItemStack salvageItem;
        boolean salvageOffHand;
        boolean salvageMainHand = !player.getMainHandItem().isEmpty();
        boolean bl = salvageOffHand = !salvageMainHand && !player.getOffhandItem().isEmpty();
        ItemStack itemStack = salvageMainHand ? player.getMainHandItem() : (salvageItem = salvageOffHand ? player.getOffhandItem() : ItemStack.EMPTY);
        if (salvageItem == ItemStack.EMPTY || salvageItem.is(Items.AIR)) {
            return;
        }
        if (!this.loader.ITEM_LOADER.getData().containsKey(RegistryUtil.getId(player.level().registryAccess(), salvageItem))) {
            return;
        }
        Map<String, Experience> playerXp = this.getData().getXpMap(player.getUUID());
        HashMap<String, Long> xpAwards = new HashMap<String, Long>();
        boolean validAttempt = false;
        block0: for (Map.Entry<ResourceLocation, CodecTypes.SalvageData> result : this.loader.ITEM_LOADER.getData(RegistryUtil.getId(player.level().registryAccess(), salvageItem)).salvage().entrySet()) {
            for (Map.Entry<String, Long> skill : result.getValue().levelReq().entrySet()) {
                if (skill.getValue() <= playerXp.getOrDefault(skill.getKey(), new Experience()).getLevel().getLevel()) continue;
                continue block0;
            }
            validAttempt = true;
            double base = result.getValue().baseChance();
            double max = result.getValue().maxChance();
            double bonus = 0.0;
            for (Map.Entry<String, Double> skill : result.getValue().chancePerLevel().entrySet()) {
                bonus += skill.getValue() * (double)playerXp.getOrDefault(skill.getKey(), new Experience()).getLevel().getLevel();
            }
            for (int i = 0; i < result.getValue().salvageMax(); ++i) {
                if (!(player.getRandom().nextDouble() < Math.min(max, base + bonus))) continue;
                player.drop(new ItemStack((ItemLike)BuiltInRegistries.ITEM.getValue(result.getKey())), false, true);
                for (Map.Entry<String, Long> award : result.getValue().xpAward().entrySet()) {
                    xpAwards.merge(award.getKey(), award.getValue(), (o, n) -> o + n);
                }
            }
        }
        if (validAttempt) {
            if (salvageMainHand) {
                player.getMainHandItem().shrink(1);
            }
            if (salvageOffHand) {
                player.getOffhandItem().shrink(1);
            }
            List<ServerPlayer> party = PartyUtils.getPartyMembersInRange(player);
            this.awardXP(party, xpAwards);
        } else {
            player.sendSystemMessage((Component)LangProvider.DENIAL_SALVAGE.asComponent(salvageItem.getDisplayName()));
        }
    }

    public void setMarkedPos(UUID playerID, BlockPos pos) {
        BlockPos finalPos = pos.equals((Object)this.getMarkedPos(playerID)) ? BlockPos.ZERO : pos;
        this.markers.put(playerID, finalPos);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Player " + playerID.toString() + " Marked Pos: " + finalPos.toString(), new Object[0]);
    }

    public BlockPos getMarkedPos(UUID playerID) {
        return this.markers.getOrDefault(playerID, BlockPos.ZERO);
    }

    public int getBlockConsume(Block block) {
        return this.loader.BLOCK_LOADER.getData((ResourceLocation)RegistryUtil.getId((Block)block)).veinData().consumeAmount.orElseGet(() -> Config.server().veinMiner().requireSettings() ? -1 : Config.server().veinMiner().defaultConsume());
    }
}

