/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core;

import com.mojang.serialization.DynamicOps;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class CoreUtils {
    public static Map<String, Long> deserializeAwardMap(CompoundTag nbt) {
        return new HashMap<String, Long>(CodecTypes.LONG_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt).resultOrPartial(str -> MsLoggy.ERROR.log(MsLoggy.LOG_CODE.API, "Error Deserializing Award Map from API: {}", str)).orElse(new HashMap()));
    }

    public static Map<String, Long> mergeXpMapsWithSummateCondition(Map<String, Long> ogMap, Map<String, Long> newMap) {
        boolean summate = Config.server().xpGains().perksPlusConfig();
        if (!summate) {
            return newMap;
        }
        for (Map.Entry<String, Long> entry : newMap.entrySet()) {
            ogMap.merge(entry.getKey(), entry.getValue(), (a, b) -> a > b ? a : b);
        }
        return ogMap;
    }

    public static Map<String, Long> applyXpModifiers(Map<String, Long> mapIn, Map<String, Double> modifiers) {
        modifiers.forEach((skill, modifier) -> mapIn.computeIfPresent((String)skill, (key, xp) -> (long)((double)xp.longValue() * modifier)));
        return mapIn;
    }

    public static Map<String, Long> processSkillGroupXP(Map<String, Long> map) {
        new HashMap<String, Long>(map).forEach((skill, baseXP) -> {
            SkillData data = Config.skills().get((String)skill);
            if (data.isSkillGroup()) {
                map.remove(skill);
                data.getGroupXP((long)baseXP).forEach((member, xp) -> map.merge((String)member, (Long)xp, Long::sum));
            }
        });
        return map;
    }

    public static Map<String, Long> processSkillGroupReqs(Map<String, Long> map) {
        new HashMap<String, Long>(map).forEach((skill, level) -> {
            SkillData data = Config.skills().get((String)skill);
            if (data.isSkillGroup() && !data.getUseTotalLevels()) {
                map.remove(skill);
                data.getGroupReq((long)level).forEach((member, xp) -> map.merge((String)member, (Long)xp, Long::sum));
            }
        });
        return map;
    }

    public static Map<String, Double> processSkillGroupBonus(Map<String, Double> map) {
        new HashMap<String, Double>(map).forEach((skill, level) -> {
            SkillData data = Config.skills().get((String)skill);
            if (data.isSkillGroup()) {
                map.remove(skill);
                map.putAll(data.getGroupBonus((double)level));
            }
        });
        return map;
    }

    public static int getSkillColor(String skill) {
        return 0xFF000000 | Config.skills().get(skill).getColor();
    }

    public static Style getSkillStyle(String skill) {
        return Style.EMPTY.withColor(CoreUtils.getSkillColor(skill));
    }

    public static int setTransparency(int color, double transparency) {
        int alpha = (int)(transparency * 255.0);
        return color & 0xFFFFFF | (alpha & 0xFF) << 24;
    }

    public static List<MobEffectInstance> getEffects(Map<ResourceLocation, Integer> config, boolean applyDefaultNegatives) {
        ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
        if (applyDefaultNegatives && config.isEmpty()) {
            config = Config.autovalue().reqs().penalties();
        }
        for (Map.Entry<ResourceLocation, Integer> effect : config.entrySet()) {
            Holder effectRoot = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)BuiltInRegistries.MOB_EFFECT.getValue(effect.getKey())));
            if (effectRoot == null) continue;
            effects.add(new MobEffectInstance(effectRoot, 75, effect.getValue().intValue(), true, true));
        }
        return effects;
    }
}

