/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.core.perks;

import com.google.common.collect.LinkedListMultimap;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.apache.commons.lang3.function.TriFunction;

@EventBusSubscriber(modid="pmmo")
public class FeaturePerks {
    private static final CompoundTag NONE = new CompoundTag();
    private static final Map<String, Holder.Reference<Attribute>> attributeCache = new HashMap<String, Holder.Reference<Attribute>>();
    public static final Perk ATTRIBUTE = Perk.begin().addDefaults(TagBuilder.start().withDouble("max_boost", 0.0).withDouble("per_level", 0.0).withDouble("base", 0.0).withBool("multiplicative", false).build()).setStart((player, nbt) -> {
        double perLevel = nbt.getDoubleOr("per_level", 0.0);
        double maxBoost = nbt.getDoubleOr("max_boost", 0.0);
        AttributeInstance instance = player.getAttribute(FeaturePerks.getAttribute(nbt));
        if (instance == null) {
            return NONE;
        }
        double boost = Math.min(perLevel * (double)nbt.getIntOr("level", 0), maxBoost) + nbt.getDoubleOr("base", 0.0);
        AttributeModifier.Operation operation = nbt.getBooleanOr("multiplicative", true) ? AttributeModifier.Operation.ADD_MULTIPLIED_BASE : AttributeModifier.Operation.ADD_VALUE;
        ResourceLocation attributeID = FeaturePerks.attributeID(nbt.getStringOr("attribute", ""), nbt.getStringOr("skill", "asdf"));
        AttributeModifier modifier = new AttributeModifier(attributeID, boost, operation);
        instance.removeModifier(attributeID);
        instance.addPermanentModifier(modifier);
        return NONE;
    }).setDescription(LangProvider.PERK_ATTRIBUTE_DESC.asComponent()).setStatus((player, settings) -> {
        double perLevel = settings.getDouble("per_level").orElse(0.0);
        String skillname = settings.getString("skill").orElse("missing");
        int skillLevel = settings.getInt("level").orElse(0);
        String attrName = FeaturePerks.getAttribute(settings) == null ? settings.getString("attribute").orElse("missing") : ((Attribute)FeaturePerks.getAttribute(settings).value()).getDescriptionId();
        return List.of(LangProvider.PERK_ATTRIBUTE_STATUS_1.asComponent(Component.translatable((String)attrName)), LangProvider.PERK_ATTRIBUTE_STATUS_2.asComponent(perLevel, Component.translatable((String)("pmmo." + skillname))), LangProvider.PERK_ATTRIBUTE_STATUS_3.asComponent(perLevel * (double)skillLevel));
    }).build();
    private static final LinkedListMultimap<Player, AttributeRecord> respawnAttributes = LinkedListMultimap.create();
    public static final Perk TEMP_ATTRIBUTE = Perk.begin().addDefaults(ATTRIBUTE.propertyDefaults()).setStart((player, nbt) -> {
        double perLevel = nbt.getDoubleOr("per_level", 0.0);
        double maxBoost = nbt.getDoubleOr("max_boost", 0.0);
        AttributeInstance instance = player.getAttribute(FeaturePerks.getAttribute(nbt));
        double boost = Math.min(perLevel * (double)nbt.getIntOr("level", 0), maxBoost) + nbt.getDoubleOr("base", 0.0);
        AttributeModifier.Operation operation = nbt.getBooleanOr("multiplicative", true) ? AttributeModifier.Operation.ADD_MULTIPLIED_BASE : AttributeModifier.Operation.ADD_VALUE;
        ResourceLocation attributeID = Reference.rl("temp+perk/" + nbt.getStringOr("attribute", "").replace(':', '_') + "/" + nbt.getStringOr("skill", "asdf"));
        AttributeModifier modifier = new AttributeModifier(attributeID, boost, operation);
        if (instance.hasModifier(modifier.id())) {
            instance.removeModifier(attributeID);
        }
        instance.addTransientModifier(modifier);
        return NONE;
    }).setStop((player, nbt) -> {
        ResourceLocation attributeID = Reference.rl("temp+perk/" + nbt.getStringOr("attribute", "").replace(':', '_') + "/" + nbt.getStringOr("skill", "asdf"));
        player.getAttribute(FeaturePerks.getAttribute(nbt)).removeModifier(attributeID);
        return NONE;
    }).setDescription(ATTRIBUTE.description()).setStatus(ATTRIBUTE.status()).build();
    public static BiFunction<Player, CompoundTag, CompoundTag> EFFECT_SETTER = (player, nbt) -> {
        Holder effect = BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)((MobEffect)BuiltInRegistries.MOB_EFFECT.getValue(Reference.of(nbt.getStringOr("effect", "missing")))));
        if (effect != null) {
            int skillLevel = nbt.getIntOr("level", 0);
            int configDuration = nbt.getIntOr("duration", 0);
            double perLevel = nbt.getDoubleOr("per_level", 0.0);
            int base = nbt.getIntOr("base", 0);
            int calculatedDuration = (int)((double)skillLevel * (double)configDuration * perLevel) + base;
            calculatedDuration = Math.min(nbt.getIntOr("max_boost", 0), calculatedDuration);
            int duration = player.hasEffect(effect) && player.getEffect(effect).getDuration() > calculatedDuration ? player.getEffect(effect).getDuration() : calculatedDuration;
            int amplifier = nbt.getIntOr("modifier", 0);
            boolean ambient = nbt.getBooleanOr("ambient", true);
            boolean visible = nbt.getBooleanOr("visible", true);
            boolean showIcon = nbt.getBooleanOr("show_icon", true);
            player.addEffect(new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon));
        }
        return NONE;
    };
    public static final Perk EFFECT = Perk.begin().addDefaults(TagBuilder.start().withString("effect", "modid:effect").withInt("duration", 100).withDouble("base", 0.0).withInt("per_level", 1).withInt("min_level", 1).withInt("max_boost", Integer.MAX_VALUE).withInt("modifier", 0).withBool("ambient", false).withBool("visible", true).withBool("show_icon", true).build()).setStart(EFFECT_SETTER).setTick((TriFunction<Player, CompoundTag, Integer, CompoundTag>)((TriFunction)(player, nbt, ticks) -> EFFECT_SETTER.apply((Player)player, (CompoundTag)nbt))).setDescription(LangProvider.PERK_EFFECT_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_EFFECT_STATUS_1.asComponent(Component.translatable((String)((MobEffect)BuiltInRegistries.MOB_EFFECT.getValue(Reference.of(nbt.getStringOr("effect", "missing")))).getDescriptionId())), LangProvider.PERK_EFFECT_STATUS_2.asComponent(nbt.getInt("modifier"), (double)nbt.getIntOr("duration", 0) * nbt.getDoubleOr("per_level", 0.0) * (double)nbt.getIntOr("level", 0) / 20.0))).build();
    private static final BiFunction<Player, CompoundTag, List<MutableComponent>> JUMP_LINES = (player, nbt) -> List.of(LangProvider.PERK_JUMP_BOOST_STATUS_1.asComponent(nbt.getIntOr("per_level", 0) * nbt.getIntOr("level", 0)));
    private static final CompoundTag JUMP_DEFAULTS = TagBuilder.start().withDouble("base", 0.0).withDouble("per_level", 5.0E-4).withDouble("max_boost", 0.25).build();
    public static final Perk JUMP_CLIENT = Perk.begin().addDefaults(JUMP_DEFAULTS).setStart((player, nbt) -> {
        double jumpBoost = Math.min(nbt.getDoubleOr("max_boost", 0.0), -0.011 + (double)nbt.getIntOr("level", 0) * nbt.getDoubleOr("per_level", 0.0)) + nbt.getDoubleOr("base", 0.0);
        player.setDeltaMovement(player.getDeltaMovement().add(0.0, jumpBoost, 0.0));
        player.hurtMarked = true;
        return NONE;
    }).setDescription(LangProvider.PERK_JUMP_BOOST_DESC.asComponent()).setStatus(JUMP_LINES).build();
    public static final Perk JUMP_SERVER = Perk.begin().addDefaults(JUMP_DEFAULTS).setStart((player, nbt) -> {
        double jumpBoost = Math.min(nbt.getDoubleOr("max_boost", 0.0), -0.011 + (double)nbt.getIntOr("level", 0) * nbt.getDoubleOr("per_level", 0.0)) + nbt.getDoubleOr("base", 0.0);
        return TagBuilder.start().withDouble("jump_boost_output", player.getDeltaMovement().y + jumpBoost).build();
    }).setDescription(LangProvider.PERK_JUMP_BOOST_DESC.asComponent()).setStatus(JUMP_LINES).build();
    public static final Perk BREATH = Perk.begin().addConditions((player, nbt) -> player.getAirSupply() < 2).addDefaults(TagBuilder.start().withLong("cooldown", 600L).withDouble("base", 0.0).withDouble("per_level", 1.0).withInt("max_boost", Integer.MAX_VALUE).build()).setStart((player, nbt) -> {
        int perLevel = Math.max(1, (int)((double)nbt.getIntOr("level", 0) * nbt.getDoubleOr("per_level", 0.0)) + nbt.getIntOr("base", 0));
        perLevel = Math.min(nbt.getIntOr("max_boost", 0), perLevel);
        player.setAirSupply(player.getAirSupply() + perLevel);
        player.displayClientMessage((Component)LangProvider.PERK_BREATH_REFRESH.asComponent(), false);
        return NONE;
    }).setDescription(LangProvider.PERK_BREATH_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_BREATH_STATUS_1.asComponent((int)((double)nbt.getIntOr("level", 0) * nbt.getDoubleOr("per_level", 0.0))), LangProvider.PERK_BREATH_STATUS_2.asComponent(nbt.getIntOr("cooldown", 0) / 20))).build();
    public static final Perk DAMAGE_REDUCE = Perk.begin().addConditions((player, nbt) -> {
        String perkApplicableDamageType = nbt.getStringOr("for_damage", "missing");
        Registry damageRegistry = player.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE);
        DamageType damageType = (DamageType)damageRegistry.getValue(Reference.of(nbt.getStringOr("damage_type", "missing")));
        if (perkApplicableDamageType.startsWith("#") && damageRegistry.get(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Reference.of(perkApplicableDamageType.substring(1)))).stream().anyMatch(typeTag -> typeTag.contains(damageRegistry.wrapAsHolder((Object)damageType)))) {
            return true;
        }
        if (perkApplicableDamageType.endsWith(":*") && perkApplicableDamageType.substring(0, perkApplicableDamageType.indexOf(58)).equals(nbt.getStringOr("damage_type".substring(0, nbt.getStringOr("damage_type", ":").indexOf(58)), ":"))) {
            return true;
        }
        return perkApplicableDamageType.equals(nbt.getStringOr("damage_type", ""));
    }).addDefaults(TagBuilder.start().withDouble("per_level", 0.025).withDouble("base", 0.0).withFloat("damageIn", 0.0f).withString("damage_type", "missing").withInt("max_boost", Integer.MAX_VALUE).withString("for_damage", "omitted").build()).setStart((player, nbt) -> {
        float saved = nbt.getFloatOr("per_level", 0.0f) * (float)nbt.getIntOr("level", 0) + nbt.getFloatOr("base", 0.0f);
        saved = Math.min(nbt.getFloatOr("max_boost", 0.0f), saved);
        float baseDamage = nbt.contains("damage") ? nbt.getFloatOr("damage", 0.0f) : nbt.getFloatOr("damageIn", 0.0f);
        nbt.putFloat("damage", Math.max(baseDamage - saved, 0.0f));
        return nbt;
    }).setDescription(LangProvider.PERK_FALL_SAVE_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_FALL_SAVE_STATUS_1.asComponent((double)nbt.getIntOr("level", 0) * nbt.getDoubleOr("per_level", 0.0)), LangProvider.PERK_BREATH_STATUS_2.asComponent(nbt.getIntOr("cooldown", 0) / 20))).build();
    public static final String APPLICABLE_TO = "applies_to";
    public static final Perk DAMAGE_BOOST = Perk.begin().addConditions((player, nbt) -> {
        String perkApplicableDamageType = nbt.getStringOr("damage_type", "missing");
        List<String> dmgType = nbt.getList("for_damage").stream().map(Tag::asString).map(Optional::get).toList();
        boolean damageMatch = dmgType.isEmpty() || dmgType.stream().anyMatch(key -> {
            if (key.startsWith("#") && RegistryUtil.isInTag(player.level().registryAccess(), Registries.DAMAGE_TYPE, perkApplicableDamageType, key.substring(1))) {
                return true;
            }
            if (key.endsWith(":*") && Reference.of(perkApplicableDamageType).getNamespace().equals(key.replace(":*", ""))) {
                return true;
            }
            return key.equals(perkApplicableDamageType);
        });
        List<String> type = nbt.getList(APPLICABLE_TO).orElse(new ListTag()).stream().map(tag -> tag.asString().orElse("error")).toList();
        boolean weaponMatch = type.isEmpty() || type.stream().anyMatch(key -> {
            if (key.startsWith("#") && RegistryUtil.isInTag(player.level().registryAccess(), Registries.ITEM, RegistryUtil.getId(player.level().registryAccess(), player.getMainHandItem()), key.substring(1))) {
                return true;
            }
            if (key.endsWith(":*") && RegistryUtil.getId(player.getMainHandItem().getItemHolder()).getNamespace().equals(key.replace(":*", ""))) {
                return true;
            }
            return key.equals(RegistryUtil.getId(player.level().registryAccess(), player.getMainHandItem()).toString());
        });
        return weaponMatch && damageMatch;
    }).addDefaults(TagBuilder.start().withFloat("damageIn", 0.0f).withFloat("damage", 0.0f).withList("applies_to", new Tag[0]).withDouble("per_level", 0.05).withDouble("base", 1.0).withInt("max_boost", Integer.MAX_VALUE).withBool("multiplicative", true).build()).setStart((player, nbt) -> {
        float damageModification = (float)(nbt.getDoubleOr("base", 0.0) + nbt.getDoubleOr("per_level", 0.0) * (double)nbt.getIntOr("level", 0));
        damageModification = Math.min((float)nbt.getIntOr("max_boost", 0), damageModification);
        float damage = nbt.getBooleanOr("multiplicative", true) ? nbt.getFloatOr("damage", 0.0f) * damageModification : nbt.getFloatOr("damage", 0.0f) + damageModification;
        return TagBuilder.start().withFloat("damage", damage).build();
    }).setDescription(LangProvider.PERK_DAMAGE_BOOST_DESC.asComponent()).setStatus((player, nbt) -> {
        ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
        MutableComponent line1 = LangProvider.PERK_DAMAGE_BOOST_STATUS_1.asComponent();
        for (Tag entry : nbt.getListOrEmpty(APPLICABLE_TO)) {
            Item item;
            MutableComponent description = Component.literal((String)entry.asString().orElse(""));
            if (ResourceLocation.tryParse((String)entry.asString().orElse("")) != null && !(item = (Item)BuiltInRegistries.ITEM.getValue(Reference.of(entry.asString().orElse("")))).equals(Items.AIR)) {
                description = item.getDefaultInstance().getDisplayName();
            }
            line1.append((Component)description);
            line1.append((Component)Component.literal((String)", "));
        }
        lines.add(line1);
        lines.add(LangProvider.PERK_DAMAGE_BOOST_STATUS_2.asComponent(nbt.getBooleanOr("multiplicative", true) ? "x" : "+", (double)nbt.getIntOr("level", 0) * nbt.getDoubleOr("per_level", 0.0)));
        return lines;
    }).build();
    private static final String COMMAND = "command";
    private static final String FUNCTION = "function";
    public static final Perk RUN_COMMAND = Perk.begin().setStart((p, nbt) -> {
        if (!(p instanceof ServerPlayer)) {
            return NONE;
        }
        ServerPlayer player = (ServerPlayer)p;
        if (nbt.contains(FUNCTION)) {
            player.level().getServer().getFunctions().execute((CommandFunction)player.level().getServer().getFunctions().get(Reference.of(nbt.getStringOr(FUNCTION, ""))).get(), player.createCommandSourceStack().withSuppressedOutput().withMaximumPermission(2));
        } else if (nbt.contains(COMMAND)) {
            player.level().getServer().getCommands().performPrefixedCommand(player.createCommandSourceStack().withSuppressedOutput().withMaximumPermission(2), nbt.getStringOr(COMMAND, ""));
        }
        return NONE;
    }).setDescription(LangProvider.PERK_COMMAND_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_COMMAND_STATUS_1.asComponent(nbt.contains(FUNCTION) ? "Function" : "Command", nbt.contains(FUNCTION) ? nbt.getStringOr(FUNCTION, "missing") : nbt.getStringOr(COMMAND, "missing")))).build();
    public static final Perk VILLAGER_TRADING = Perk.begin().addConditions((player, tag) -> tag.getString("target").equals("minecraft:villager")).addDefaults(TagBuilder.start().withString("target", "missing").withDouble("base", 0.0).withInt("entity_id", -1).withDouble("per_level", 0.05).withLong("cooldown", 1000L).build()).setStart((player, nbt) -> {
        int villagerID = nbt.getIntOr("entity_id", 0);
        Villager villager = (Villager)player.level().getEntity(villagerID);
        villager.onReputationEventFrom(ReputationEventType.ZOMBIE_VILLAGER_CURED, (Entity)player);
        player.displayClientMessage((Component)LangProvider.PERK_VILLAGE_FEEDBACK.asComponent(), false);
        return NONE;
    }).setDescription(LangProvider.PERK_VILLAGER_DESC.asComponent()).setStatus((player, nbt) -> List.of(LangProvider.PERK_VILLAGE_STATUS_1.asComponent((double)nbt.getIntOr("level", 0) * nbt.getDoubleOr("per_level", 0.0)))).build();

    private static Holder.Reference<Attribute> getAttribute(CompoundTag nbt) {
        return attributeCache.computeIfAbsent(nbt.getString("attribute").orElse("missing"), name -> (Holder.Reference)BuiltInRegistries.ATTRIBUTE.wrapAsHolder((Object)((Attribute)BuiltInRegistries.ATTRIBUTE.getValue(Reference.of(name)))));
    }

    private static ResourceLocation attributeID(String attribute, String skill) {
        return Reference.rl("perk/" + attribute.replace(':', '_') + "/" + skill);
    }

    @SubscribeEvent
    public static void saveAttributesOnDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (CompoundTag nbt : ((List)Config.perks().perks().getOrDefault(EventType.SKILL_UP, new ArrayList())).stream().filter(tag -> tag.getString("perk").orElse("").equals("pmmo:attribute")).toList()) {
                Holder.Reference<Attribute> attribute = FeaturePerks.getAttribute(nbt);
                AttributeInstance instance = player.getAttributes().getInstance(attribute);
                if (instance == null) continue;
                instance.getModifiers().stream().filter(mod -> mod.id().equals((Object)FeaturePerks.attributeID(nbt.getString("attribute").orElse("missing"), nbt.getString("skill").orElse("missing")))).forEach(mod -> respawnAttributes.put((Object)player, (Object)new AttributeRecord((Holder<Attribute>)attribute, (AttributeModifier)mod)));
            }
        }
    }

    @SubscribeEvent
    public static void restoreAttributesOnSpawn(PlayerEvent.PlayerRespawnEvent event) {
        if (respawnAttributes.containsKey((Object)event.getEntity())) {
            respawnAttributes.get((Object)event.getEntity()).stream().filter(mod -> {
                AttributeInstance instance = event.getEntity().getAttribute(mod.attribute());
                return instance != null && !instance.hasModifier(mod.modifier().id());
            }).forEach(mod -> {
                AttributeInstance instance = event.getEntity().getAttribute(mod.attribute());
                if (instance != null) {
                    instance.addPermanentModifier(mod.modifier());
                }
            });
            respawnAttributes.get((Object)event.getEntity()).clear();
        }
    }

    private record AttributeRecord(Holder<Attribute> attribute, AttributeModifier modifier) {
    }
}

