/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.features.veinmining.VeinMiningLogic;
import harmonised.pmmo.storage.DataAttachmentTypes;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.level.BlockEvent;

public class BreakHandler {
    public static void handle(BlockEvent.BreakEvent event) {
        boolean serverSide;
        Core core = Core.get(event.getPlayer().level());
        boolean bl = serverSide = !event.getPlayer().level().isClientSide();
        if (!core.isActionPermitted(ReqType.BREAK, event.getPos(), event.getPlayer())) {
            event.setCanceled(true);
            Messenger.sendDenialMsg(ReqType.BREAK, event.getPlayer(), event.getState().getBlock().getName());
            return;
        }
        CompoundTag eventHookOutput = new CompoundTag();
        if (serverSide && ((Boolean)(eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.BLOCK_BREAK, (Event)event, new CompoundTag())).getBoolean("is_cancelled").get()).booleanValue()) {
            event.setCanceled(true);
            return;
        }
        CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(EventType.BLOCK_BREAK, event.getPlayer(), eventHookOutput));
        if (serverSide) {
            Map<String, Long> xpAward = BreakHandler.calculateXpAward(core, event, perkOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.getPlayer());
            core.awardXP(partyMembersInRange, xpAward);
            LevelChunk chunk = (LevelChunk)event.getLevel().getChunk(event.getPos());
            ((Map)chunk.getData(DataAttachmentTypes.PLACED_MAP.get())).remove(event.getPos());
            if (event.getLevel().getBlockState(event.getPos()).is(Reference.CASCADING_BREAKABLES)) {
                ((Map)chunk.getData(DataAttachmentTypes.BREAK_MAP.get())).put(event.getPos(), event.getPlayer().getUUID());
            }
            chunk.markUnsaved();
        }
        if (core.getMarkedPos(event.getPlayer().getUUID()).equals((Object)event.getPos())) {
            BlockState block = event.getLevel().getBlockState(event.getPos());
            Item tool = event.getPlayer().getMainHandItem().getItem();
            if (!Config.server().veinMiner().blacklist().contains(RegistryUtil.getId(event.getLevel().registryAccess(), tool))) {
                VeinMiningLogic.applyVein((ServerPlayer)event.getPlayer(), event.getPos());
            }
        }
    }

    private static Map<String, Long> calculateXpAward(Core core, BlockEvent.BreakEvent event, CompoundTag dataIn) {
        Map<String, Long> outMap = core.getExperienceAwards(EventType.BLOCK_BREAK, event.getPos(), (Level)event.getLevel(), event.getPlayer(), dataIn);
        LevelChunk chunk = (LevelChunk)event.getLevel().getChunk(event.getPos());
        Map placeMap = (Map)chunk.getData(DataAttachmentTypes.PLACED_MAP);
        if (placeMap.containsKey(event.getPos()) && ((UUID)placeMap.get(event.getPos())).equals(event.getPlayer().getUUID())) {
            BlockState cropState = event.getLevel().getBlockState(event.getPos());
            if (cropState.getBlock() instanceof CropBlock && ((CropBlock)cropState.getBlock()).isMaxAge(cropState)) {
                return outMap;
            }
            double xpModifier = Config.server().xpGains().reusePenalty();
            if (xpModifier == 0.0) {
                return new HashMap<String, Long>();
            }
            HashMap<String, Long> modifiedOutMap = new HashMap<String, Long>();
            outMap.forEach((k, v) -> modifiedOutMap.put((String)k, (long)((double)v.longValue() * xpModifier)));
            return modifiedOutMap;
        }
        return outMap;
    }
}

