/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.util.MsLoggy;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class BreakSpeedHandler {
    private static Map<UUID, DetailsCache> resultCache = new HashMap<UUID, DetailsCache>();

    public static void handle(PlayerEvent.BreakSpeed event) {
        Core core = Core.get(event.getEntity().level());
        if (resultCache.containsKey(event.getEntity().getUUID()) && BreakSpeedHandler.usingCache(event)) {
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Cache Used. Supplied: {}", Float.valueOf(event.getNewSpeed()));
            return;
        }
        if (!core.isActionPermitted(ReqType.TOOL, event.getEntity().getMainHandItem(), event.getEntity())) {
            event.setCanceled(true);
            resultCache.put(event.getEntity().getUUID(), new DetailsCache(event.getEntity().getMainHandItem(), event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getState(), true, event.getNewSpeed()));
            return;
        }
        if (!core.isActionPermitted(ReqType.BREAK, event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getEntity())) {
            event.setCanceled(true);
            resultCache.put(event.getEntity().getUUID(), new DetailsCache(event.getEntity().getMainHandItem(), event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getState(), true, event.getNewSpeed()));
            return;
        }
        CompoundTag eventHookOutput = new CompoundTag();
        if (!event.getEntity().level().isClientSide() && ((Boolean)(eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.BREAK_SPEED, (Event)event, new CompoundTag())).getBoolean("is_cancelled").get()).booleanValue()) {
            event.setCanceled(true);
            resultCache.put(event.getEntity().getUUID(), new DetailsCache(event.getEntity().getMainHandItem(), event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getState(), true, event.getNewSpeed()));
            return;
        }
        CompoundTag perkDataIn = eventHookOutput;
        perkDataIn.putFloat("speedIn", event.getNewSpeed());
        perkDataIn.putLong("block_pos", event.getPosition().orElse(new BlockPos(0, 0, 0)).asLong());
        CompoundTag perkDataOut = core.getPerkRegistry().executePerk(EventType.BREAK_SPEED, event.getEntity(), perkDataIn);
        if (perkDataOut.contains("speed")) {
            float newSpeed = event.getNewSpeed() * (1.0f + Math.max(0.0f, ((Float)perkDataOut.getFloat("speed").get()).floatValue()));
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.EVENT, "BreakSpeed Original{}, New:{}", Float.valueOf(event.getOriginalSpeed()), Float.valueOf(newSpeed));
            event.setNewSpeed(newSpeed);
            resultCache.put(event.getEntity().getUUID(), new DetailsCache(event.getEntity().getMainHandItem(), event.getPosition().orElse(new BlockPos(0, 0, 0)), event.getState(), event.getEntity().onGround(), false, newSpeed));
        }
    }

    private static boolean usingCache(PlayerEvent.BreakSpeed event) {
        DetailsCache cachedData = resultCache.get(event.getEntity().getUUID());
        if (event.getEntity().onGround() == cachedData.isPlayerStanding() && event.getPosition().orElse(new BlockPos(0, 0, 0)).equals((Object)cachedData.pos) && event.getState().equals((Object)cachedData.state) && event.getEntity().getMainHandItem().equals(cachedData.item)) {
            if (cachedData.cancelled) {
                event.setCanceled(true);
            } else {
                event.setNewSpeed(cachedData.newSpeed);
            }
            return true;
        }
        return false;
    }

    private record DetailsCache(ItemStack item, BlockPos pos, BlockState state, boolean isPlayerStanding, boolean cancelled, float newSpeed) {
        public DetailsCache(ItemStack item, BlockPos pos, BlockState state, boolean cancelled, float newSpeed) {
            this(item, pos, state, true, cancelled, newSpeed);
        }
    }
}

