/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.features.anticheese.CheeseTracker;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.event.entity.living.LivingBreatheEvent;

public class BreathHandler {
    public static void handle(LivingBreatheEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.tickCount % 10 == 0) {
                int diff;
                int n = diff = event.canBreathe() ? event.getRefillAirAmount() : event.getConsumeAirAmount();
                if (diff == 0) {
                    return;
                }
                Core core = Core.get(player.level());
                boolean serverSide = core.getSide() == LogicalSide.SERVER;
                CompoundTag eventHookOutput = new CompoundTag();
                if (serverSide) {
                    eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.BREATH_CHANGE, (Event)event, new CompoundTag());
                }
                CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(EventType.BREATH_CHANGE, player, eventHookOutput));
                if (serverSide) {
                    Map<String, Double> ratio = Config.server().xpGains().playerXp(EventType.BREATH_CHANGE);
                    ResourceLocation source = Reference.mc("player");
                    HashMap<String, Long> xpAward = perkOutput.contains("serialized_award_map") ? CoreUtils.deserializeAwardMap((CompoundTag)perkOutput.getCompound("serialized_award_map").get()) : new HashMap<String, Long>();
                    ratio.keySet().forEach(skill -> {
                        Double value = ratio.getOrDefault(skill, 0.0) * (double)diff;
                        xpAward.put((String)skill, value.longValue());
                    });
                    CoreUtils.applyXpModifiers(xpAward, core.getConsolidatedModifierMap(player));
                    CheeseTracker.applyAntiCheese(EventType.BREATH_CHANGE, source, player, xpAward);
                    List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                    core.awardXP(partyMembersInRange, xpAward);
                }
            }
        }
    }
}

