/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.TagUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;

public class BreedHandler {
    public static void handle(BabyEntitySpawnEvent event) {
        Player player = event.getCausedByPlayer();
        if (player == null || event.getChild() == null) {
            return;
        }
        Core core = Core.get(player.level());
        if (!core.isActionPermitted(ReqType.BREED, (Entity)event.getChild(), player)) {
            event.setCanceled(true);
            Messenger.sendDenialMsg(ReqType.BREED, player, event.getChild().getName());
            return;
        }
        boolean serverSide = !player.level().isClientSide();
        CompoundTag eventHookOutput = new CompoundTag();
        if (serverSide && ((Boolean)(eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.BREED, (Event)event, new CompoundTag())).getBoolean("is_cancelled").get()).booleanValue()) {
            event.setCanceled(true);
            return;
        }
        CompoundTag perkOutput = TagUtils.mergeTags(eventHookOutput, core.getPerkRegistry().executePerk(EventType.BREED, player, eventHookOutput));
        if (serverSide) {
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.BREED, (Entity)event.getChild(), player, perkOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
            core.awardXP(partyMembersInRange, xpAward);
        }
    }
}

