/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Functions;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.damagesource.DamageContainer;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class DamageReceivedHandler {
    public static void handle(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            DamageContainer container = event.getContainer();
            DamageSource source = container.getSource();
            if (player.equals((Object)source.getEntity())) {
                return;
            }
            Core core = Core.get(player.level());
            String damageType = RegistryUtil.getId(player.level().registryAccess(), Registries.DAMAGE_TYPE, source.type()).toString();
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Source Type: " + damageType + " | Source Raw: " + source.getMsgId(), new Object[0]);
            boolean serverSide = player instanceof ServerPlayer;
            CompoundTag eventHookOutput = new CompoundTag();
            if (serverSide && ((Boolean)(eventHookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.RECEIVE_DAMAGE, (Event)event, new CompoundTag())).getBoolean("is_cancelled").get()).booleanValue()) {
                container.setNewDamage(0.0f);
                return;
            }
            CompoundTag perkDataIn = eventHookOutput.copy();
            perkDataIn.putString("damage_type", damageType);
            perkDataIn.putFloat("damageIn", container.getNewDamage());
            CompoundTag perkOutput = TagUtils.mergeTags(perkDataIn, core.getPerkRegistry().executePerk(EventType.RECEIVE_DAMAGE, player, perkDataIn));
            if (perkOutput.contains("damage")) {
                float damageOut = ((Float)perkOutput.getFloat("damage").get()).floatValue();
                MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.EVENT, "Damage Modified from %s to %s".formatted(Float.valueOf(container.getNewDamage()), Float.valueOf(damageOut)), new Object[0]);
                container.setNewDamage(damageOut);
            }
            if (serverSide) {
                perkOutput.putString("damage_type", damageType);
                Map<String, Long> xpAward = DamageReceivedHandler.getExperienceAwards(core, source, container.getNewDamage(), player, perkOutput);
                List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                core.awardXP(partyMembersInRange, xpAward);
            }
        }
    }

    private static Map<String, Long> getExperienceAwards(Core core, DamageSource source, float damage, Player player, CompoundTag dataIn) {
        HashMap<String, Long> mapOut = new HashMap<String, Long>();
        float ultimateDamage = Mth.clamp((float)damage, (float)0.0f, (float)player.getHealth());
        if (source.getEntity() != null) {
            core.getExperienceAwards(EventType.RECEIVE_DAMAGE, source.getEntity(), player, dataIn).forEach((skill, value) -> mapOut.put((String)skill, (long)(value.floatValue() * ultimateDamage)));
        }
        Map<String, Map<String, Long>> config = Config.server().xpGains().receivedDamage();
        List<String> tags = config.keySet().stream().filter(str -> {
            if (!str.contains("#")) {
                return false;
            }
            Registry registry = player.level().registryAccess().lookupOrThrow(Registries.DAMAGE_TYPE);
            Optional tag = registry.get(TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)Reference.of(str.substring(1))));
            return tag.map(type -> type.contains(source.typeHolder())).orElse(false);
        }).toList();
        Map tagXp = tags.stream().map(str -> (Map)config.get(str)).reduce((mapA, mapB) -> Functions.mergeMaps(mapA, mapB)).orElse(new HashMap());
        Functions.mergeMaps((Map)config.getOrDefault(RegistryUtil.getId(player.level().registryAccess(), Registries.DAMAGE_TYPE, source.type()).toString(), new HashMap()), tagXp).forEach((skill, xp) -> mapOut.putIfAbsent((String)skill, (long)(xp.floatValue() * ultimateDamage)));
        CoreUtils.applyXpModifiers(mapOut, core.getConsolidatedModifierMap(player));
        return mapOut;
    }
}

