/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.events.FurnaceBurnEvent;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.storage.DataAttachmentTypes;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.TagUtils;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class FurnaceHandler {
    public static void handle(FurnaceBurnEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        UUID pid = ((Map)event.getLevel().getChunkAt(event.getPos()).getData(DataAttachmentTypes.PLACED_MAP.get())).getOrDefault(event.getPos(), Reference.NIL);
        if (pid == null) {
            return;
        }
        ServerPlayer player = event.getLevel().getServer().getPlayerList().getPlayer(pid);
        if (player == null) {
            return;
        }
        Core core = Core.get(event.getLevel());
        CompoundTag eventHook = core.getEventTriggerRegistry().executeEventListeners(EventType.SMELT, event, new CompoundTag());
        eventHook.putString("stack", TagUtils.stackTag(event.getInput(), event.getLevel()).asString().orElse("missing"));
        eventHook = TagUtils.mergeTags(eventHook, core.getPerkRegistry().executePerk(EventType.SMELT, (Player)player, eventHook));
        Map<String, Long> xpAwards = core.getExperienceAwards(EventType.SMELT, event.getInput(), (Player)player, eventHook);
        List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange(player);
        core.awardXP(partyMembersInRange, xpAwards);
    }
}

