/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.storage.DataAttachmentTypes;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.TagUtils;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.player.BonemealEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.event.level.block.CropGrowEvent;

public class GrowHandler {
    public static void handle(CropGrowEvent.Post event) {
        GrowHandler.handle((Level)event.getLevel(), event.getState(), event.getPos(), (Event)event);
    }

    public static void handle(BlockGrowFeatureEvent event) {
        GrowHandler.handle((Level)event.getLevel(), event.getLevel().getBlockState(event.getPos()), event.getPos(), (Event)event);
    }

    public static void handle(BonemealEvent event) {
        if (!event.isCanceled() && event.isValidBonemealTarget()) {
            GrowHandler.handle(event.getLevel(), event.getState(), event.getPos(), (Event)event);
        }
    }

    public static void handle(Level level, BlockState state, BlockPos pos, Event event) {
        if (!level.isClientSide()) {
            Core core = Core.get(level);
            BlockPos sourcePos = GrowHandler.getParentPos(level, state, pos);
            LevelChunk chunk = level.getChunkAt(sourcePos);
            Map placeMap = (Map)chunk.getData(DataAttachmentTypes.PLACED_MAP.get());
            UUID placerID = placeMap.getOrDefault(sourcePos, Reference.NIL);
            ServerPlayer player = level.getServer().getPlayerList().getPlayer(placerID);
            if (player == null) {
                return;
            }
            placeMap.put(pos, placerID);
            chunk.markUnsaved();
            CompoundTag hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.GROW, event, new CompoundTag());
            hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.GROW, (Player)player, new CompoundTag()));
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.GROW, pos, level, (Player)player, hookOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange(player);
            core.awardXP(partyMembersInRange, xpAward);
        }
    }

    private static BlockPos getParentPos(Level level, BlockState state, BlockPos posIn) {
        if (state.is(Reference.CASCADING_BREAKABLES)) {
            return level.getBlockState(posIn.above()).isAir() && level.getBlockState(posIn.below()).is(Reference.CASCADING_BREAKABLES) ? posIn.below() : (level.getBlockState(posIn.below()).isAir() && level.getBlockState(posIn.above()).is(Reference.CASCADING_BREAKABLES) ? posIn.above() : posIn);
        }
        return posIn;
    }
}

