/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.TriState;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class PlayerClickHandler {
    public static void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        boolean serverSide;
        Player player = event.getEntity();
        Core core = Core.get(player.level());
        boolean bl = serverSide = !player.level().isClientSide();
        if (!core.isActionPermitted(ReqType.BREAK, event.getPos(), player)) {
            event.setUseBlock(TriState.FALSE);
            Messenger.sendDenialMsg(ReqType.BREAK, player, new ItemStack((ItemLike)player.level().getBlockState(event.getPos()).getBlock().asItem()).getDisplayName());
        }
        if (!core.isActionPermitted(ReqType.INTERACT, event.getItemStack(), player)) {
            event.setUseItem(TriState.FALSE);
            Messenger.sendDenialMsg(ReqType.INTERACT, player, player.getMainHandItem().getDisplayName());
        }
        if (event.getUseBlock().equals((Object)TriState.FALSE)) {
            return;
        }
        CompoundTag hookOutput = new CompoundTag();
        if (serverSide) {
            hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.HIT_BLOCK, (Event)event, hookOutput);
            if (hookOutput.getBooleanOr("is_cancelled", false)) {
                event.setCanceled(true);
                return;
            }
            if (hookOutput.getBooleanOr("deny_block", false)) {
                event.setUseBlock(TriState.FALSE);
            }
            if (hookOutput.getBooleanOr("deny_item", false)) {
                event.setUseItem(TriState.FALSE);
            }
        }
        hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.HIT_BLOCK, player, new CompoundTag()));
        if (serverSide) {
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.HIT_BLOCK, event.getPos(), player.level(), event.getEntity(), hookOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.getEntity());
            core.awardXP(partyMembersInRange, xpAward);
        }
    }

    public static void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isSalvage;
        boolean serverSide;
        Player player = event.getEntity();
        Core core = Core.get(player.level());
        boolean bl = serverSide = !player.level().isClientSide();
        if (!core.isActionPermitted(ReqType.INTERACT, event.getPos(), player)) {
            event.setUseBlock(TriState.FALSE);
        }
        if (!core.isActionPermitted(ReqType.INTERACT, event.getItemStack(), player)) {
            event.setUseItem(TriState.FALSE);
        }
        if (event.getUseBlock().equals((Object)TriState.FALSE) && !serverSide && event.getHand().equals((Object)InteractionHand.MAIN_HAND)) {
            Messenger.sendDenialMsg(ReqType.INTERACT, player, event.getLevel().getBlockState(event.getPos()).getBlock().getName());
            return;
        }
        CompoundTag hookOutput = new CompoundTag();
        boolean bl2 = isSalvage = player.isCrouching() && RegistryUtil.getId(event.getLevel().getBlockState(event.getPos()).getBlock()).equals((Object)Config.server().general().salvageBlock());
        if (serverSide) {
            hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.ACTIVATE_BLOCK, (Event)event, hookOutput);
            if (hookOutput.getBooleanOr("is_cancelled", false)) {
                event.setCanceled(true);
                return;
            }
            if (isSalvage && event.getHand().equals((Object)InteractionHand.MAIN_HAND)) {
                core.getSalvage((ServerPlayer)player);
            }
        }
        if (isSalvage) {
            event.setCanceled(true);
        }
        hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.ACTIVATE_BLOCK, player, new CompoundTag()));
        if (serverSide) {
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.ACTIVATE_BLOCK, event.getPos(), player.level(), event.getEntity(), hookOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.getEntity());
            core.awardXP(partyMembersInRange, xpAward);
        }
    }

    public static void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        boolean serverSide;
        Player player = event.getEntity();
        Core core = Core.get(player.level());
        boolean bl = serverSide = !player.level().isClientSide();
        if (!core.isActionPermitted(ReqType.USE, event.getItemStack(), player)) {
            event.setCancellationResult((InteractionResult)InteractionResult.FAIL);
            event.setCanceled(true);
            Messenger.sendDenialMsg(ReqType.USE, player, event.getItemStack().getDisplayName());
            return;
        }
        CompoundTag hookOutput = new CompoundTag();
        if (serverSide && (hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.ACTIVATE_ITEM, (Event)event, hookOutput)).getBooleanOr("is_cancelled", false)) {
            event.setCanceled(true);
            return;
        }
        hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.ACTIVATE_ITEM, player, new CompoundTag()));
        if (serverSide) {
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.ACTIVATE_ITEM, event.getItemStack(), event.getEntity(), hookOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)event.getEntity());
            core.awardXP(partyMembersInRange, xpAward);
        }
    }
}

