/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.TagUtils;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.living.LivingShieldBlockEvent;

public class ShieldBlockHandler {
    public static void handle(LivingShieldBlockEvent event) {
        LivingEntity livingEntity;
        if (event.getBlocked() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            livingEntity = event.getDamageSource().getEntity();
            if (livingEntity instanceof Entity) {
                ItemStack shield;
                LivingEntity attacker = livingEntity;
                Core core = Core.get(player.level());
                if (!core.isActionPermitted(ReqType.WEAPON, shield = player.getUseItem(), player)) {
                    event.setBlocked(false);
                    Messenger.sendDenialMsg(ReqType.WEAPON, player, shield.getDisplayName());
                    return;
                }
                boolean serverSide = !player.level().isClientSide();
                CompoundTag hookOutput = new CompoundTag();
                if (serverSide && ((Boolean)(hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.SHIELD_BLOCK, (Event)event, new CompoundTag())).getBoolean("is_cancelled").get()).booleanValue()) {
                    event.setBlocked(false);
                    return;
                }
                hookOutput.putFloat("damageIn", event.getBlockedDamage());
                hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.SHIELD_BLOCK, player, hookOutput));
                if (serverSide) {
                    HashMap<String, Long> xpAward = new HashMap<String, Long>();
                    core.getExperienceAwards(EventType.SHIELD_BLOCK, (Entity)attacker, player, hookOutput).forEach((skill, value) -> xpAward.put((String)skill, (long)((float)value.longValue() * event.getBlockedDamage())));
                    List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
                    core.awardXP(partyMembersInRange, xpAward);
                }
            }
        }
    }
}

