/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.events.impl;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.util.Messenger;
import harmonised.pmmo.util.TagUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.event.entity.living.AnimalTameEvent;

public class TameHandler {
    public static void handle(AnimalTameEvent event) {
        Core core = Core.get(event.getTamer().level());
        Player player = event.getTamer();
        Animal target = event.getAnimal();
        if (!core.isActionPermitted(ReqType.TAME, (Entity)target, player)) {
            event.setCanceled(true);
            Messenger.sendDenialMsg(ReqType.TAME, player, target.getName());
            return;
        }
        boolean serverSide = !player.level().isClientSide();
        CompoundTag hookOutput = new CompoundTag();
        if (serverSide && ((Boolean)(hookOutput = core.getEventTriggerRegistry().executeEventListeners(EventType.TAMING, (Event)event, new CompoundTag())).getBoolean("is_cancelled").get()).booleanValue()) {
            event.setCanceled(true);
            return;
        }
        hookOutput.putString("tamed", event.getAnimal().getUUID().toString());
        hookOutput = TagUtils.mergeTags(hookOutput, core.getPerkRegistry().executePerk(EventType.TAMING, player, hookOutput));
        if (serverSide) {
            Map<String, Long> xpAward = core.getExperienceAwards(EventType.TAMING, (Entity)target, player, hookOutput);
            List<ServerPlayer> partyMembersInRange = PartyUtils.getPartyMembersInRange((ServerPlayer)player);
            core.awardXP(partyMembersInRange, xpAward);
        }
    }
}

