/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.anticheese;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="pmmo")
public class CheeseTracker {
    private static final Map<Player, Map<EventType, AFKTracker>> AFK_DATA = new HashMap<Player, Map<EventType, AFKTracker>>();
    private static final Map<Player, Map<EventType, DiminishTracker>> DIMINISH_DATA = new HashMap<Player, Map<EventType, DiminishTracker>>();
    private static final Map<Player, Map<EventType, NormTracker>> NORMALIZED_DATA = new HashMap<Player, Map<EventType, NormTracker>>();

    public static void applyAntiCheese(EventType event, ResourceLocation source, Player player, Map<String, Long> awardIn) {
        CheeseTracker.applyAntiCheese(event, List.of(source), player, awardIn);
    }

    public static void applyAntiCheese(EventType event, List<ResourceLocation> source, Player player, Map<String, Long> awardIn) {
        if (!(player instanceof ServerPlayer) || event == null) {
            return;
        }
        Setting setting = Config.anticheese().afk().get(event);
        if (setting != null) {
            for (ResourceLocation src : source) {
                setting.applyAFK(event, src, player, awardIn);
            }
        }
        if ((setting = Config.anticheese().diminish().get(event)) != null) {
            for (ResourceLocation src : source) {
                setting.applyDiminuation(event, src, player, awardIn);
            }
        }
        if ((setting = Config.anticheese().normal().get(event)) != null) {
            for (ResourceLocation src : source) {
                setting.applyNormalization(event, src, player, awardIn);
            }
        }
    }

    @SubscribeEvent
    public static void playerWatcher(ServerTickEvent.Pre event) {
        AFK_DATA.forEach((player, map) -> map.forEach((type, tracker) -> {
            if (player != null && !tracker.meetsAFKCriteria((Player)player)) {
                tracker.cooldown();
            }
        }));
        DIMINISH_DATA.forEach((player, map) -> map.forEach((type, tracker) -> tracker.cooloff()));
        NORMALIZED_DATA.forEach((player, map) -> map.forEach((type, tracker) -> --tracker.retainTimeRemaining));
    }

    public record Setting(List<String> source, int minTime, int retention, int toleranceFlat, double reduction, int cooloff, double tolerancePercent, boolean strictTolerance) {
        public static final String SOURCE = "source";
        public static final String MIN_TIME_TO_APPLY = "min_time_to_apply";
        public static final String REDUCTION = "reduction";
        public static final String COOLOFF = "cooloff_amount";
        public static final String TOLERANCE_PERCENT = "tolerance_percent";
        public static final String TOLERANCE_FLAT = "tolerance_flat";
        public static final String RETENTION = "retention_duration";
        public static final String STRICT = "strict_tolerance";
        public static final Codec<Setting> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.listOf().optionalFieldOf(SOURCE).forGetter(s -> Optional.of(s.source)), (App)Codec.INT.optionalFieldOf(MIN_TIME_TO_APPLY).forGetter(s -> Optional.of(s.minTime)), (App)Codec.INT.optionalFieldOf(RETENTION).forGetter(s -> Optional.of(s.retention)), (App)Codec.INT.optionalFieldOf(TOLERANCE_FLAT).forGetter(s -> Optional.of(s.toleranceFlat)), (App)Codec.DOUBLE.optionalFieldOf(REDUCTION).forGetter(s -> Optional.of(s.reduction)), (App)Codec.INT.optionalFieldOf(COOLOFF).forGetter(s -> Optional.of(s.cooloff)), (App)Codec.DOUBLE.optionalFieldOf(TOLERANCE_PERCENT).forGetter(s -> Optional.of(s.tolerancePercent)), (App)Codec.BOOL.optionalFieldOf(STRICT).forGetter(s -> Optional.of(s.strictTolerance))).apply((Applicative)instance, (src, min, ret, flat, red, cool, per, strict) -> new Setting(src.orElse(new ArrayList()), min.orElse(0), ret.orElse(0), flat.orElse(0), red.orElse(1.0), cool.orElse(1), per.orElse(0.0), strict.orElse(true))));

        public static Builder build() {
            return new Builder();
        }

        public void applyAFK(EventType event, ResourceLocation source, Player player, Map<String, Long> awardIn) {
            AFKTracker afkData = AFK_DATA.computeIfAbsent(player, p -> new HashMap()).computeIfAbsent(event, e -> new AFKTracker(player, this.minTime(), this.cooloff(), this.toleranceFlat(), this.strictTolerance())).update(player);
            if ((this.source().isEmpty() || this.source().contains(source.toString())) && afkData.isAFK()) {
                awardIn.keySet().forEach(skill -> {
                    MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.XP, "AFK reduction factor: {}", this.reduction * (double)afkData.getAFKDuration());
                    awardIn.compute((String)skill, (key, xp) -> {
                        long reductionAmount = Double.valueOf((double)xp.longValue() * (this.reduction * (double)afkData.getAFKDuration())).longValue();
                        return xp - (Config.anticheese().afkSubtract() ? reductionAmount : (reductionAmount > xp ? xp : reductionAmount));
                    });
                });
            }
        }

        public void applyDiminuation(EventType event, ResourceLocation source, Player player, Map<String, Long> awardIn) {
            DiminishTracker tracker = DIMINISH_DATA.computeIfAbsent(player, p -> new HashMap()).computeIfAbsent(event, e -> new DiminishTracker(this.retention));
            if (this.source().isEmpty() || this.source().contains(source.toString())) {
                tracker.diminish();
                awardIn.keySet().forEach(skill -> {
                    double reductionScale = 1.0 - this.reduction * (double)tracker.persistedTime;
                    awardIn.compute((String)skill, (key, xp) -> Double.valueOf((double)xp.longValue() * Math.max(0.0, reductionScale)).longValue());
                });
            }
        }

        public void applyNormalization(EventType event, ResourceLocation source, Player player, Map<String, Long> awardIn) {
            if (this.source().isEmpty() || this.source().contains(source.toString())) {
                NormTracker norms = NORMALIZED_DATA.computeIfAbsent(player, p -> new HashMap()).computeIfAbsent(event, e -> new NormTracker(this.retention));
                norms.retainTimeRemaining = this.retention;
                awardIn.forEach((skill, value) -> {
                    long norm = norms.norms.computeIfAbsent((String)skill, s -> value);
                    long acceptableVariance = Double.valueOf(Math.min((double)norm + Math.max(1.0, (double)norm * this.tolerancePercent), (double)(norm + (long)this.toleranceFlat))).longValue();
                    norms.norms.put((String)skill, value > acceptableVariance ? acceptableVariance : value);
                });
                awardIn.putAll(norms.norms);
            }
        }

        public static class Builder {
            private final List<String> source = new ArrayList<String>();
            private int minTime = 0;
            private int retention = 0;
            private int toleranceFlat = 0;
            private double reduction = 0.0;
            private int cooloff = 0;
            private double tolerancePercent = 0.0;
            private boolean strictTolerance = true;

            protected Builder() {
            }

            public Builder source(String entry) {
                this.source.add(entry);
                return this;
            }

            public Builder source(String ... entries) {
                this.source.addAll(Arrays.asList(entries));
                return this;
            }

            public Builder minTime(int min) {
                this.minTime = min;
                return this;
            }

            public Builder retention(int ret) {
                this.retention = ret;
                return this;
            }

            public Builder reduction(double red) {
                this.reduction = red;
                return this;
            }

            public Builder cooloff(int cool) {
                this.cooloff = cool;
                return this;
            }

            public Builder tolerance(int flat) {
                this.toleranceFlat = flat;
                return this;
            }

            public Builder tolerance(double percent) {
                this.tolerancePercent = percent;
                return this;
            }

            public Builder setStrictness(boolean isStrict) {
                this.strictTolerance = isStrict;
                return this;
            }

            public Setting build() {
                return new Setting(this.source, this.minTime, this.retention, this.toleranceFlat, this.reduction, this.cooloff, this.tolerancePercent, this.strictTolerance);
            }

            public Setting fromScripting(Map<String, String> values) {
                if (values.containsKey(Setting.SOURCE)) {
                    this.source(values.get(Setting.SOURCE).split(","));
                }
                if (values.containsKey(Setting.MIN_TIME_TO_APPLY)) {
                    this.minTime(Integer.parseInt(values.get(Setting.MIN_TIME_TO_APPLY)));
                }
                if (values.containsKey(Setting.REDUCTION)) {
                    this.reduction(Double.parseDouble(values.get(Setting.REDUCTION)));
                }
                if (values.containsKey(Setting.COOLOFF)) {
                    this.cooloff(Integer.parseInt(values.get(Setting.COOLOFF)));
                }
                if (values.containsKey(Setting.TOLERANCE_PERCENT)) {
                    this.tolerance(Double.parseDouble(values.get(Setting.TOLERANCE_PERCENT)));
                }
                if (values.containsKey(Setting.TOLERANCE_FLAT)) {
                    this.tolerance(Integer.parseInt(values.get(Setting.TOLERANCE_FLAT)));
                }
                if (values.containsKey(Setting.RETENTION)) {
                    this.retention(Integer.parseInt(values.get(Setting.RETENTION)));
                }
                if (values.containsKey(Setting.STRICT)) {
                    this.setStrictness(Boolean.parseBoolean(values.get(Setting.STRICT)));
                }
                return this.build();
            }
        }
    }

    private static class NormTracker {
        public final Map<String, Long> norms = new HashMap<String, Long>();
        public int retainTimeRemaining;

        public NormTracker(int defaultRetention) {
            this.retainTimeRemaining = defaultRetention;
        }
    }

    private static class DiminishTracker {
        public int persistedTime;
        public int cooloffLeft;
        private final int timeToClearReduction;

        public DiminishTracker(int timeToClear) {
            this.timeToClearReduction = timeToClear;
        }

        public void cooloff() {
            if (--this.cooloffLeft <= 0) {
                this.persistedTime = 0;
            }
        }

        public void diminish() {
            ++this.persistedTime;
            this.cooloffLeft = this.timeToClearReduction;
        }
    }

    private static class AFKTracker {
        int durationAFK = 0;
        int minDuration = 0;
        int cooldownBy = 1;
        int tolerance = 0;
        boolean strictFacing;
        BlockPos lastPos;
        Vec3 lastLookAngle;

        public AFKTracker(Player player, int minDuration, int cooldownBy, int tolerance, boolean strictFacing) {
            this.lastPos = player.blockPosition();
            this.lastLookAngle = player.getLookAngle();
            this.minDuration = minDuration;
            this.cooldownBy = cooldownBy;
            this.tolerance = tolerance;
            this.strictFacing = strictFacing;
        }

        public AFKTracker update(Player player) {
            if (this.meetsAFKCriteria(player)) {
                ++this.durationAFK;
            } else if (this.durationAFK <= 0) {
                this.lastLookAngle = player.getLookAngle();
                this.lastPos = player.blockPosition();
            }
            return this;
        }

        public void cooldown() {
            if (this.durationAFK > 0) {
                this.durationAFK -= this.cooldownBy;
            }
        }

        public boolean meetsAFKCriteria(Player player) {
            BlockPos curPos = player.blockPosition();
            return (!this.strictFacing || this.lastLookAngle.equals((Object)player.getLookAngle())) && Math.abs(this.lastPos.getX() - curPos.getX()) < this.tolerance && Math.abs(this.lastPos.getY() - curPos.getY()) < this.tolerance && Math.abs(this.lastPos.getZ() - curPos.getZ()) < this.tolerance;
        }

        public boolean isAFK() {
            return MsLoggy.DEBUG.logAndReturn(this.durationAFK >= this.minDuration, MsLoggy.LOG_CODE.FEATURE, "isAFK:{}({}:{})", this.durationAFK, this.minDuration);
        }

        public int getAFKDuration() {
            return this.durationAFK - this.minDuration;
        }
    }
}

