/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.autovalues;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.util.Reference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.neoforged.neoforge.common.Tags;

public class AutoBlock {
    private static final double BASE_HARDNESS = 4.0;
    public static final ReqType[] REQTYPES = new ReqType[]{ReqType.BREAK};
    public static final EventType[] EVENTTYPES = new EventType[]{EventType.BLOCK_BREAK, EventType.BLOCK_PLACE, EventType.GROW};
    private static final List<String> WORLD_SENSITIVE_MOD_IDS = List.of("dynamictrees", "dtbop");

    public static Map<String, Long> processReqs(ReqType type, ResourceLocation blockID) {
        if (!type.blockApplicable || AutoBlock.isWorldSensitive(blockID) || !Config.autovalue().reqEnabled(type)) {
            return new HashMap<String, Long>();
        }
        Block block = (Block)BuiltInRegistries.BLOCK.getValue(blockID);
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        switch (type) {
            case BREAK: {
                if (block.equals(Blocks.WATER)) break;
                float breakSpeed = block.defaultBlockState().getDestroySpeed((BlockGetter)EmptyBlockGetter.INSTANCE, null);
                Config.autovalue().reqs().blockDefault().forEach((skill, level) -> outMap.put((String)skill, (long)Math.max(0.0, ((double)breakSpeed - 4.0) * Config.autovalue().tweaks().hardnessModifier())));
                break;
            }
        }
        return outMap;
    }

    public static Map<String, Long> processXpGains(EventType type, ResourceLocation blockID) {
        if (!type.blockApplicable || AutoBlock.isWorldSensitive(blockID) || !Config.autovalue().xpEnabled(type)) {
            return new HashMap<String, Long>();
        }
        Holder block = BuiltInRegistries.BLOCK.wrapAsHolder((Object)((Block)BuiltInRegistries.BLOCK.getValue(blockID)));
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        if (block == null) {
            return outMap;
        }
        switch (type) {
            case BLOCK_BREAK: 
            case BLOCK_PLACE: {
                if (block.is(Reference.CROPS)) {
                    outMap.putAll(Config.autovalue().xpAwards().block(EventType.GROW));
                    break;
                }
                if (block.is(Reference.MINABLE_AXE)) {
                    outMap.putAll(Config.autovalue().xpAwards().axeOverride());
                    break;
                }
                if (block.is(Reference.MINABLE_HOE)) {
                    outMap.putAll(Config.autovalue().xpAwards().hoeOverride());
                    break;
                }
                if (block.is(Reference.MINABLE_SHOVEL)) {
                    outMap.putAll(Config.autovalue().xpAwards().shovelOverride());
                    break;
                }
                Config.autovalue().xpAwards().block(type).forEach((skill, level) -> {
                    float breakSpeed = Math.max(1.0f, ((Block)block.value()).defaultBlockState().getDestroySpeed(null, null));
                    long xpOut = Double.valueOf(Math.max(1.0, (double)breakSpeed * Config.autovalue().tweaks().hardnessModifier() * (double)level.longValue())).longValue();
                    if (block.is(Tags.Blocks.ORES)) {
                        xpOut *= Config.autovalue().xpAwards().raritiesMultiplier().longValue();
                    }
                    outMap.put((String)skill, xpOut);
                });
                break;
            }
            case GROW: {
                if (!(block.value() instanceof CropBlock)) break;
                outMap.putAll(Config.autovalue().xpAwards().block(type));
                break;
            }
        }
        return outMap;
    }

    private static boolean isWorldSensitive(ResourceLocation id) {
        return WORLD_SENSITIVE_MOD_IDS.contains(id.getNamespace());
    }
}

