/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.autovalues;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.util.Reference;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;

public class AutoEntity {
    public static final EventType[] EVENTTYPES = new EventType[]{EventType.BREED, EventType.DEATH, EventType.ENTITY, EventType.RIDING, EventType.SHIELD_BLOCK, EventType.TAMING};

    public static Map<String, Long> processReqs(ReqType type, ResourceLocation entityID) {
        return new HashMap<String, Long>();
    }

    public static Map<String, Long> processXpGains(EventType type, ResourceLocation entityID) {
        if (!type.entityApplicable || !Config.autovalue().xpEnabled(type)) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(entityID);
        switch (type) {
            case RIDING: {
                if (!entityType.is(Reference.RIDEABLE_TAG)) break;
                outMap.putAll(AutoEntity.getXpMap(entityID, type));
                break;
            }
            case DEATH: 
            case ENTITY: 
            case SHIELD_BLOCK: {
                outMap.putAll(AutoEntity.getXpMap(entityID, type));
                break;
            }
            case BREED: {
                if (!entityType.is(Reference.BREEDABLE_TAG)) break;
                outMap.putAll(AutoEntity.getXpMap(entityID, type));
                break;
            }
            case TAMING: {
                if (!entityType.is(Reference.TAMABLE_TAG)) break;
                outMap.putAll(AutoEntity.getXpMap(entityID, type));
                break;
            }
        }
        return outMap;
    }

    private static Map<String, Long> getXpMap(ResourceLocation entityID, EventType type) {
        EntityType entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.getValue(entityID);
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double healthScale = AutoEntity.getAttribute((EntityType<? extends LivingEntity>)entity, (Holder<Attribute>)Attributes.MAX_HEALTH) * Config.autovalue().tweaks().entityTweaks().getOrDefault(AutoValueConfig.AttributeKey.HEALTH.key, 0.0);
        double speedScale = AutoEntity.getAttribute((EntityType<? extends LivingEntity>)entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED) * Config.autovalue().tweaks().entityTweaks().getOrDefault(AutoValueConfig.AttributeKey.SPEED.key, 0.0);
        double damageScale = AutoEntity.getAttribute((EntityType<? extends LivingEntity>)entity, (Holder<Attribute>)Attributes.ATTACK_DAMAGE) * Config.autovalue().tweaks().entityTweaks().getOrDefault(AutoValueConfig.AttributeKey.DMG.key, 0.0);
        double scale = healthScale + speedScale + damageScale;
        Config.autovalue().xpAwards().entity(type).forEach((skill, value) -> outMap.put((String)skill, Double.valueOf((double)value.longValue() * scale).longValue()));
        return outMap;
    }

    private static double getAttribute(EntityType<? extends LivingEntity> entity, Holder<Attribute> attribute) {
        if (!DefaultAttributes.hasSupplier(entity)) {
            return 0.0;
        }
        AttributeSupplier attSup = DefaultAttributes.getSupplier(entity);
        if (attSup == null) {
            return 0.0;
        }
        return attSup.hasAttribute(attribute) ? attSup.getBaseValue(attribute) : 0.0;
    }
}

