/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.autovalues;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.features.autovalues.AutoBlock;
import harmonised.pmmo.features.autovalues.AutoValueConfig;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Repairable;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class AutoItem {
    private static final double BASE_ATK_SPD = 1.6;
    private static final double BASE_DURABILITY = 59.0;
    private static final double BASE_DAMAGE = 4.0;
    public static final ReqType[] REQTYPES = new ReqType[]{ReqType.WEAR, ReqType.USE_ENCHANTMENT, ReqType.TOOL, ReqType.WEAPON};
    public static final EventType[] EVENTTYPES = new EventType[]{EventType.ANVIL_REPAIR, EventType.BLOCK_PLACE, EventType.CRAFT, EventType.CONSUME, EventType.ENCHANT, EventType.FISH, EventType.SMELT};

    public static Map<String, Long> processReqs(ReqType type, ResourceLocation stackID) {
        if (!type.itemApplicable || !Config.autovalue().reqEnabled(type)) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        ItemStack stack = ((Item)BuiltInRegistries.ITEM.getValue(stackID)).getDefaultInstance();
        switch (type) {
            case WEAR: {
                if (stack.is(Tags.Items.TOOLS)) {
                    if (stack.is(ItemTags.SWORDS)) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, true));
                        break;
                    }
                    if (stack.is(ItemTags.AXES)) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, false));
                        break;
                    }
                    if (stack.is(ItemTags.PICKAXES)) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, false));
                        break;
                    }
                    if (stack.is(ItemTags.SHOVELS)) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, false));
                        break;
                    }
                    if (!stack.is(ItemTags.HOES)) break;
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, false));
                    break;
                }
                if (stack.is(Tags.Items.ARMORS)) {
                    outMap.putAll(AutoItem.getWearableData(type, stack, true));
                    break;
                }
                if (!stack.getItem().equals(Items.ELYTRA)) break;
                outMap.putAll(AutoItem.getWearableData(type, stack, false));
                break;
            }
            case USE_ENCHANTMENT: {
                double scale = 0.0;
                for (Object2IntMap.Entry entry : stack.getEnchantments().entrySet()) {
                    scale += (double)entry.getIntValue() / (double)((Enchantment)((Holder)entry.getKey()).value()).getMaxLevel();
                }
                for (Map.Entry entry : Config.autovalue().reqs().req(type).entrySet()) {
                    outMap.put((String)entry.getKey(), (long)((double)((Long)entry.getValue()).longValue() * scale));
                }
                break;
            }
            case TOOL: {
                if (!stack.is(Tags.Items.TOOLS)) break;
                if (stack.is(ItemTags.SWORDS)) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, false));
                    break;
                }
                if (stack.is(ItemTags.AXES)) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, false));
                    break;
                }
                if (stack.is(ItemTags.PICKAXES)) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, false));
                    break;
                }
                if (stack.is(ItemTags.SHOVELS)) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, false));
                    break;
                }
                if (!stack.is(ItemTags.HOES)) break;
                outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, false));
                break;
            }
            case WEAPON: {
                if (!stack.is(Tags.Items.TOOLS)) break;
                if (stack.is(ItemTags.SWORDS)) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, true));
                    break;
                }
                if (stack.is(ItemTags.AXES)) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, true));
                    break;
                }
                if (stack.is(ItemTags.PICKAXES)) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, true));
                    break;
                }
                if (stack.is(ItemTags.SHOVELS)) {
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, true));
                    break;
                }
                if (!stack.is(ItemTags.HOES)) break;
                outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, true));
                break;
            }
            case BREAK: {
                if (!(stack.getItem() instanceof BlockItem)) break;
                outMap.putAll(AutoBlock.processReqs(type, stackID));
                break;
            }
        }
        return outMap;
    }

    public static Map<String, Long> processXpGains(EventType type, ResourceLocation stackID) {
        if (!type.itemApplicable || !Config.autovalue().xpEnabled(type)) {
            return new HashMap<String, Long>();
        }
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        ItemStack stack = ((Item)BuiltInRegistries.ITEM.getValue(stackID)).getDefaultInstance();
        switch (type) {
            case ANVIL_REPAIR: {
                if (!stack.getComponents().has(DataComponents.REPAIRABLE)) break;
                Config.autovalue().xpAwards().item(type).forEach((skill, xp) -> outMap.put((String)skill, (long)((double)xp.longValue() * ((double)stack.getMaxDamage() * 0.25))));
                break;
            }
            case BLOCK_PLACE: 
            case BLOCK_BREAK: {
                if (!(stack.getItem() instanceof BlockItem)) break;
                outMap.putAll(AutoBlock.processXpGains(type, RegistryUtil.getId(((BlockItem)stack.getItem()).getBlock())));
                break;
            }
            case CRAFT: {
                if (stack.is(Tags.Items.TOOLS)) {
                    if (stack.is(ItemTags.SWORDS)) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SWORD, type, stack, true));
                        break;
                    }
                    if (stack.is(ItemTags.AXES)) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.AXE, type, stack, false));
                        break;
                    }
                    if (stack.is(ItemTags.PICKAXES)) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.PICKAXE, type, stack, false));
                        break;
                    }
                    if (stack.is(ItemTags.SHOVELS)) {
                        outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.SHOVEL, type, stack, false));
                        break;
                    }
                    if (!stack.is(ItemTags.HOES)) break;
                    outMap.putAll(AutoItem.getUtensilData(AutoValueConfig.UtensilTypes.HOE, type, stack, false));
                    break;
                }
                if (stack.is(Tags.Items.ARMORS)) {
                    outMap.putAll(AutoItem.getWearableData(type, stack, true));
                    break;
                }
                if (stack.getItem().equals(Items.ELYTRA)) {
                    outMap.putAll(AutoItem.getWearableData(type, stack, false));
                    break;
                }
                outMap.putAll(Config.autovalue().xpAwards().item(type));
                break;
            }
            case CONSUME: {
                Object object = stack.get(DataComponents.FOOD);
                if (object instanceof FoodProperties) {
                    FoodProperties properties = (FoodProperties)object;
                    Config.autovalue().xpAwards().item(type).forEach((skill, xp) -> {
                        Float nutritionScale = Float.valueOf((float)properties.nutrition() * properties.saturation());
                        Float xpAward = Float.valueOf(nutritionScale.floatValue() * (float)xp.longValue());
                        outMap.put((String)skill, xpAward.longValue());
                    });
                }
            }
            case BREW: {
                if (!stack.is(Reference.BREWABLES)) break;
                outMap.putAll(Config.autovalue().xpAwards().item(type));
                break;
            }
            case SMELT: {
                if (!stack.is(Reference.SMELTABLES)) break;
                outMap.putAll(Config.autovalue().xpAwards().item(type));
                break;
            }
            case ENCHANT: 
            case FISH: {
                outMap.putAll(Config.autovalue().xpAwards().item(type));
                break;
            }
        }
        return outMap;
    }

    private static Map<String, Long> getUtensilData(AutoValueConfig.UtensilTypes utensil, ReqType type, ItemStack stack, boolean asWeapon) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        if (stack.is(Tags.Items.TOOLS) && AutoItem.getTier(stack) <= 0.0) {
            return outMap;
        }
        double scale = AutoItem.getUtensilAttributes(utensil, stack, asWeapon);
        Map<String, Long> configValue = type == ReqType.TOOL || type == ReqType.WEAR && !asWeapon ? Config.autovalue().reqs().getToolReq(stack) : (type == ReqType.WEAR && asWeapon ? Config.autovalue().reqs().req(ReqType.WEAPON) : Config.autovalue().reqs().req(type));
        configValue.forEach((skill, level) -> outMap.put((String)skill, (long)Math.max(0.0, (double)level.longValue() * scale)));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem Req Map: " + MsLoggy.mapToString(outMap), new Object[0]);
        return outMap;
    }

    private static Map<String, Long> getUtensilData(AutoValueConfig.UtensilTypes utensil, EventType type, ItemStack stack, boolean asWeapon) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double scale = AutoItem.getUtensilAttributes(utensil, stack, asWeapon);
        Config.autovalue().xpAwards().item(type).forEach((skill, level) -> outMap.put((String)skill, Double.valueOf(Math.max(0.0, (double)level.longValue() * scale)).longValue()));
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem XpGain Map: " + MsLoggy.mapToString(outMap), new Object[0]);
        return outMap;
    }

    private static Map<String, Long> getWearableData(ReqType type, ItemStack stack, boolean isArmor) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        if (stack.is(Tags.Items.ARMORS) && ((Repairable)stack.getOrDefault(DataComponents.REPAIRABLE, (Object)new Repairable((HolderSet)HolderSet.direct((Holder[])new Holder[0])))).isValidRepairItem(Items.LEATHER.getDefaultInstance())) {
            return outMap;
        }
        double scale = AutoItem.getWearableAttributes(AutoValueConfig.WearableTypes.fromSlot(stack.getEquipmentSlot(), !isArmor), stack, isArmor);
        Config.autovalue().reqs().req(type).forEach((skill, level) -> outMap.put((String)skill, (long)Math.max(0.0, (double)level.longValue() * scale)));
        return outMap;
    }

    private static Map<String, Long> getWearableData(EventType type, ItemStack stack, boolean isArmor) {
        HashMap<String, Long> outMap = new HashMap<String, Long>();
        double scale = AutoItem.getWearableAttributes(AutoValueConfig.WearableTypes.fromSlot(stack.getEquipmentSlot(), !isArmor), stack, isArmor);
        Config.autovalue().xpAwards().item(type).forEach((skill, level) -> outMap.put((String)skill, Double.valueOf(Math.max(0.0, (double)level.longValue() * scale)).longValue()));
        return outMap;
    }

    private static double getAttributeAmount(ItemStack stack, EquipmentSlot slot, Holder<Attribute> attribute) {
        return stack.getAttributeModifiers().modifiers().stream().filter(entry -> entry.attribute().is(attribute)).mapToDouble(a -> a.modifier().amount()).sum();
    }

    private static double getTier(ItemStack item) {
        return ((Integer)item.getOrDefault(DataComponents.DAMAGE, (Object)0)).doubleValue();
    }

    private static double getDamage(ItemStack stack) {
        return AutoItem.getAttributeAmount(stack, EquipmentSlot.MAINHAND, (Holder<Attribute>)Attributes.ATTACK_DAMAGE) - 4.0;
    }

    private static double getAttackSpeed(ItemStack stack) {
        return Math.abs(AutoItem.getAttributeAmount(stack, EquipmentSlot.MAINHAND, (Holder<Attribute>)Attributes.ATTACK_SPEED)) - 1.6;
    }

    private static double getDurability(ItemStack stack) {
        return (double)stack.getMaxDamage() - 59.0;
    }

    private static double getUtensilAttributes(AutoValueConfig.UtensilTypes type, ItemStack stack, boolean asWeapon) {
        double durabilityScale = AutoItem.getDurability(stack) * Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.DUR);
        double tierScale = AutoItem.getTier(stack) * Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.TIER);
        double damageScale = asWeapon ? AutoItem.getDamage(stack) * Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.DMG) : 0.0;
        double atkSpdScale = asWeapon ? AutoItem.getAttackSpeed(stack) * Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.SPD) : 0.0;
        double digSpeedScale = asWeapon ? 0.0 : (double)stack.getDestroySpeed(Blocks.COBWEB.defaultBlockState()) + Config.autovalue().tweaks().utensil(type, AutoValueConfig.AttributeKey.DIG);
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem Attributes: DUR=" + durabilityScale + " TIER=" + tierScale + " DMG=" + damageScale + " SPD=" + atkSpdScale + " DIG=" + digSpeedScale, new Object[0]);
        return damageScale + atkSpdScale + digSpeedScale + durabilityScale + tierScale;
    }

    private static double getWearableAttributes(AutoValueConfig.WearableTypes type, ItemStack stack, boolean isArmor) {
        if (type == null) {
            return 1.0;
        }
        double durabilityScale = (double)stack.getMaxDamage() * Config.autovalue().tweaks().wearable(type, AutoValueConfig.AttributeKey.DUR);
        double armorScale = isArmor ? AutoItem.getArmorValue(stack, (Attribute)Attributes.ARMOR.value()) * Config.autovalue().tweaks().wearable(type, AutoValueConfig.AttributeKey.AMR) : 0.0;
        double toughnessScale = isArmor ? AutoItem.getArmorValue(stack, (Attribute)Attributes.ARMOR_TOUGHNESS.value()) * Config.autovalue().tweaks().wearable(type, AutoValueConfig.AttributeKey.TUF) : 0.0;
        double knockbackScale = isArmor ? AutoItem.getArmorValue(stack, (Attribute)Attributes.KNOCKBACK_RESISTANCE.value()) * Config.autovalue().tweaks().wearable(type, AutoValueConfig.AttributeKey.KBR) : 0.0;
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.AUTO_VALUES, "AutoItem Attributes: DUR=" + durabilityScale + " ARM=" + armorScale + " TUF=" + toughnessScale + " KBR=" + knockbackScale, new Object[0]);
        return durabilityScale + armorScale + toughnessScale + knockbackScale;
    }

    private static double getArmorValue(ItemStack stack, Attribute attribute) {
        return ((ItemAttributeModifiers)stack.get(DataComponents.ATTRIBUTE_MODIFIERS)).modifiers().stream().filter(entry -> entry.attribute().equals((Object)attribute)).findAny().map(attr -> attr.modifier().amount()).orElse(0.0);
    }
}

