/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.autovalues;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.ConfigData;
import harmonised.pmmo.config.readers.ConfigListener;
import harmonised.pmmo.config.scripting.Functions;
import harmonised.pmmo.features.autovalues.AutoBlock;
import harmonised.pmmo.features.autovalues.AutoEntity;
import harmonised.pmmo.features.autovalues.AutoItem;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.Reference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public record AutoValueConfig(boolean enabled, Map<ReqType, Boolean> reqEnabled, Map<EventType, Boolean> xpEnabled, XpAwards xpAwards, Requirements reqs, Tweaks tweaks) implements ConfigData<AutoValueConfig>
{
    private static final String ENABLED = "enabled";
    private static final String REQ_ENABLE = "enabled_requirements";
    private static final String XP_ENABLE = "enabled_xp_awards";
    private static final String REQ = "requirement";
    private static final String EVENT = "event";
    public static final MapCodec<AutoValueConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf(ENABLED).forGetter(AutoValueConfig::enabled), (App)Codec.simpleMap(ReqType.CODEC, (Codec)Codec.BOOL, (Keyable)StringRepresentable.keys((StringRepresentable[])ReqType.values())).fieldOf(REQ_ENABLE).forGetter(AutoValueConfig::reqEnabled), (App)Codec.simpleMap(EventType.CODEC, (Codec)Codec.BOOL, (Keyable)StringRepresentable.keys((StringRepresentable[])EventType.values())).fieldOf(XP_ENABLE).forGetter(AutoValueConfig::xpEnabled), (App)XpAwards.CODEC.fieldOf("xp_awards").forGetter(AutoValueConfig::xpAwards), (App)Requirements.CODEC.fieldOf("requirements").forGetter(AutoValueConfig::reqs), (App)Tweaks.CODEC.fieldOf("tweaks").forGetter(AutoValueConfig::tweaks)).apply((Applicative)instance, AutoValueConfig::new));

    public AutoValueConfig() {
        this(true, Arrays.stream(ReqType.values()).collect(Collectors.toMap(req -> req, r -> true)), Arrays.stream(EventType.values()).collect(Collectors.toMap(event -> event, event -> true)), XpAwards.DEFAULT, Requirements.DEFAULT, Tweaks.DEFAULT);
    }

    @Override
    public MapCodec<AutoValueConfig> getCodec() {
        return null;
    }

    @Override
    public ConfigListener.ServerConfigs getType() {
        return ConfigListener.ServerConfigs.AUTOVALUES;
    }

    @Override
    public ConfigData<AutoValueConfig> getFromScripting(String param, Map<String, String> value) {
        boolean enabled = param.equals(ENABLED) ? Functions.getBool(value) : this.enabled();
        HashMap<ReqType, Boolean> reqEnable = new HashMap<ReqType, Boolean>(this.reqEnabled());
        HashMap<EventType, Boolean> xpEnable = new HashMap<EventType, Boolean>(this.xpEnabled());
        XpAwards awards = XpAwards.fromValues(param, value, this);
        Requirements reqs = Requirements.fromValues(param, value, this);
        Tweaks tweaks = Tweaks.fromValues(param, value, this);
        AutoValueConfig config = new AutoValueConfig(enabled, reqEnable, xpEnable, awards, reqs, tweaks);
        switch (param) {
            case "enabled_requirements": {
                ReqType type = ReqType.byName(value.getOrDefault(REQ, ""));
                if (type == null) {
                    MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, "ReqType in autovalue req enabled script invalid: %s", value.getOrDefault(EVENT, "not_provided"));
                    break;
                }
                config.reqEnabled.put(type, Functions.getBool(value));
                break;
            }
            case "enabled_xp_awards": {
                EventType type = EventType.byName(value.getOrDefault(EVENT, ""));
                if (type == null) {
                    MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, "EventType in autovalue req enabled script invalid: %s", value.getOrDefault(EVENT, "not_provided"));
                    break;
                }
                config.xpEnabled.put(type, Functions.getBool(value));
                break;
            }
        }
        return config;
    }

    @Override
    public AutoValueConfig combine(AutoValueConfig two) {
        return two;
    }

    @Override
    public boolean isUnconfigured() {
        return false;
    }

    public boolean reqEnabled(ReqType type) {
        return this.reqEnabled().getOrDefault(type, false);
    }

    public boolean xpEnabled(EventType type) {
        return this.xpEnabled().getOrDefault(type, false);
    }

    public record XpAwards(Double raritiesMultiplier, Map<EventType, Map<String, Long>> itemXp, Map<EventType, Map<String, Long>> blockXp, Map<String, Long> axeOverride, Map<String, Long> hoeOverride, Map<String, Long> shovelOverride, Map<EventType, Map<String, Long>> entityXp) {
        public static final XpAwards DEFAULT = new XpAwards(10.0, Arrays.stream(AutoItem.EVENTTYPES).collect(Collectors.toMap(event -> event, event -> Map.of(event.autoValueSkill, event == EventType.SMELT || event == EventType.BREW ? 100L : 10L))), Arrays.stream(AutoBlock.EVENTTYPES).collect(Collectors.toMap(event -> event, event -> Map.of(event.autoValueSkill, 1L))), Map.of("woodcutting", 10L), Map.of("farming", 10L), Map.of("excavation", 10L), Arrays.stream(AutoEntity.EVENTTYPES).collect(Collectors.toMap(event -> event, event -> Map.of(event.autoValueSkill, 1L))));
        private static final String RARITIES = "rarities_multiplier";
        private static final String ITEM_XP = "item_xp";
        private static final String BLOCK_XP = "block_xp";
        private static final String AXE_OVERRIDE = "axe_breakable_override";
        private static final String HOE_OVERRIDE = "hoe_breakable_override";
        private static final String SHOVEL_OVERRIDE = "shovel_breakable_override";
        private static final String ENTITY_XP = "entity_xp";
        private static final String EVENT = "event";
        public static final Codec<XpAwards> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf(RARITIES).forGetter(XpAwards::raritiesMultiplier), (App)Codec.simpleMap(EventType.CODEC, CodecTypes.LONG_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])EventType.values())).fieldOf(ITEM_XP).forGetter(XpAwards::itemXp), (App)Codec.simpleMap(EventType.CODEC, CodecTypes.LONG_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])EventType.values())).fieldOf(BLOCK_XP).forGetter(XpAwards::blockXp), (App)CodecTypes.LONG_CODEC.fieldOf(AXE_OVERRIDE).forGetter(XpAwards::axeOverride), (App)CodecTypes.LONG_CODEC.fieldOf(HOE_OVERRIDE).forGetter(XpAwards::hoeOverride), (App)CodecTypes.LONG_CODEC.fieldOf(SHOVEL_OVERRIDE).forGetter(XpAwards::shovelOverride), (App)Codec.simpleMap(EventType.CODEC, CodecTypes.LONG_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])EventType.values())).fieldOf(ENTITY_XP).forGetter(XpAwards::entityXp)).apply((Applicative)instance, XpAwards::new));

        public static XpAwards fromValues(String param, Map<String, String> values, AutoValueConfig current) {
            double raritiesMult = param.equals(RARITIES) ? Functions.getDouble(values) : current.xpAwards().raritiesMultiplier();
            Map<String, Long> axe = param.equals(AXE_OVERRIDE) ? Functions.mapValue(values.get(AXE_OVERRIDE)) : current.xpAwards().axeOverride();
            Map<String, Long> hoe = param.equals(HOE_OVERRIDE) ? Functions.mapValue(values.get(HOE_OVERRIDE)) : current.xpAwards().hoeOverride();
            Map<String, Long> shovel = param.equals(SHOVEL_OVERRIDE) ? Functions.mapValue(values.get(SHOVEL_OVERRIDE)) : current.xpAwards().shovelOverride();
            XpAwards config = new XpAwards(raritiesMult, new HashMap<EventType, Map<String, Long>>(current.xpAwards().itemXp()), new HashMap<EventType, Map<String, Long>>(current.xpAwards().blockXp()), axe, hoe, shovel, new HashMap<EventType, Map<String, Long>>(current.xpAwards().entityXp()));
            if (!(param.equals(ITEM_XP) || param.equals(BLOCK_XP) || param.equals(ENTITY_XP))) {
                return config;
            }
            EventType type = EventType.byName(values.getOrDefault("event", ""));
            if (type == null) {
                MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, "AutoValue script event value invalid [%s]", values.getOrDefault("event", param));
            } else {
                switch (param) {
                    case "item_xp": {
                        config.itemXp.put(type, Functions.mapValue(values.getOrDefault("value", "")));
                        break;
                    }
                    case "block_xp": {
                        config.blockXp.put(type, Functions.mapValue(values.getOrDefault("value", "")));
                        break;
                    }
                    case "entity_xp": {
                        config.entityXp.put(type, Functions.mapValue(values.getOrDefault("value", "")));
                        break;
                    }
                }
            }
            return config;
        }

        public Map<String, Long> item(EventType type) {
            return this.itemXp().getOrDefault(type, new HashMap());
        }

        public Map<String, Long> block(EventType type) {
            return this.blockXp().getOrDefault(type, new HashMap());
        }

        public Map<String, Long> entity(EventType type) {
            return this.entityXp().getOrDefault(type, new HashMap());
        }
    }

    public record Requirements(Map<ReqType, Map<String, Long>> itemReqs, Map<String, Long> shovelOverride, Map<String, Long> swordOverride, Map<String, Long> axeOverride, Map<String, Long> hoeOverride, Map<ResourceLocation, Integer> penalties, Map<String, Long> blockDefault) {
        public static final Requirements DEFAULT = new Requirements(Map.of(ReqType.WEAR, Map.of("endurance", 1L), ReqType.USE_ENCHANTMENT, Map.of("magic", 1L), ReqType.TOOL, Map.of("mining", 1L), ReqType.WEAPON, Map.of("combat", 1L)), Map.of("excavation", 1L), Map.of("farming", 1L), Map.of("woodcutting", 1L), Map.of("farming", 1L), Map.of(Reference.mc("mining_fatigue"), 1, Reference.mc("weakness"), 1, Reference.mc("slowness"), 1), Map.of("mining", 1L));
        private static final String SHOVEL_OVERRIDE = "shovel_override";
        private static final String SWORD_OVERRIDE = "sword_override";
        private static final String AXE_OVERRIDE = "axe_override";
        private static final String HOE_OVERRIDE = "hoe_override";
        private static final String BLOCK_DEFAULT = "block_default";
        private static final String PENALTIES = "penalties";
        private static final String ITEMS = "items";
        private static final String REQ = "requirement";
        public static final Codec<Requirements> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.simpleMap(ReqType.CODEC, CodecTypes.LONG_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])ReqType.values())).fieldOf(ITEMS).forGetter(Requirements::itemReqs), (App)CodecTypes.LONG_CODEC.fieldOf(SHOVEL_OVERRIDE).forGetter(Requirements::shovelOverride), (App)CodecTypes.LONG_CODEC.fieldOf(SWORD_OVERRIDE).forGetter(Requirements::swordOverride), (App)CodecTypes.LONG_CODEC.fieldOf(AXE_OVERRIDE).forGetter(Requirements::axeOverride), (App)CodecTypes.LONG_CODEC.fieldOf(HOE_OVERRIDE).forGetter(Requirements::hoeOverride), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, (Codec)Codec.INT).fieldOf(PENALTIES).forGetter(Requirements::penalties), (App)CodecTypes.LONG_CODEC.fieldOf(BLOCK_DEFAULT).forGetter(Requirements::blockDefault)).apply((Applicative)instance, Requirements::new));

        public static Requirements fromValues(String param, Map<String, String> values, AutoValueConfig current) {
            Map<String, Long> shovel = param.equals(SHOVEL_OVERRIDE) ? Functions.mapValue(values.getOrDefault("value", "")) : current.reqs().shovelOverride;
            Map<String, Long> sword = param.equals(SWORD_OVERRIDE) ? Functions.mapValue(values.getOrDefault("value", "")) : current.reqs().swordOverride;
            Map<String, Long> axe = param.equals(AXE_OVERRIDE) ? Functions.mapValue(values.getOrDefault("value", "")) : current.reqs().axeOverride;
            Map<String, Long> hoe = param.equals(HOE_OVERRIDE) ? Functions.mapValue(values.getOrDefault("value", "")) : current.reqs().hoeOverride;
            Map<String, Long> block = param.equals(BLOCK_DEFAULT) ? Functions.mapValue(values.getOrDefault("value", "")) : current.reqs().blockDefault;
            Map<ResourceLocation, Integer> penalties = param.equals(PENALTIES) ? Requirements.rlMap(values) : current.reqs().penalties;
            HashMap<ReqType, Map<String, Long>> items = new HashMap<ReqType, Map<String, Long>>(current.reqs().itemReqs);
            if (param.equals(ITEMS)) {
                ReqType type = ReqType.byName(values.getOrDefault("requirement", ""));
                if (type == null) {
                    MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, "Autovalue script items requirement value invalid: %s", values.getOrDefault("requirement", "missing value"));
                } else {
                    items.put(type, Functions.mapValue(values.getOrDefault("value", "")));
                }
            }
            return new Requirements(items, shovel, sword, axe, hoe, penalties, block);
        }

        private static Map<ResourceLocation, Integer> rlMap(Map<String, String> values) {
            HashMap<ResourceLocation, Integer> outMap = new HashMap<ResourceLocation, Integer>();
            String[] elements = values.getOrDefault("value", "").replaceAll("\\)", "").split(",");
            for (int i = 0; i <= elements.length - 2; i += 2) {
                outMap.put(Reference.of(elements[i]), Integer.parseInt(elements[i + 1]));
            }
            return outMap;
        }

        public Map<String, Long> req(ReqType type) {
            return this.itemReqs().getOrDefault(type, new HashMap());
        }

        public Map<String, Long> getToolReq(ItemStack stack) {
            if (stack.is(ItemTags.SHOVELS)) {
                return this.shovelOverride();
            }
            if (stack.is(ItemTags.SWORDS)) {
                return this.swordOverride();
            }
            if (stack.is(ItemTags.AXES)) {
                return this.axeOverride();
            }
            if (stack.is(ItemTags.HOES)) {
                return this.hoeOverride();
            }
            return this.req(ReqType.TOOL);
        }
    }

    public record Tweaks(double hardnessModifier, Map<UtensilTypes, Map<String, Double>> utensilTweaks, Map<WearableTypes, Map<String, Double>> wearableTweaks, Map<String, Double> entityTweaks) {
        public static final Tweaks DEFAULT = new Tweaks(0.65, Arrays.stream(UtensilTypes.values()).collect(Collectors.toMap(t -> t, t -> Map.of(AttributeKey.DUR.key, AttributeKey.DUR.value, AttributeKey.TIER.key, AttributeKey.TIER.value, AttributeKey.DMG.key, AttributeKey.DMG.value, AttributeKey.SPD.key, AttributeKey.SPD.value, AttributeKey.DIG.key, AttributeKey.DIG.value))), Arrays.stream(WearableTypes.values()).collect(Collectors.toMap(t -> t, t -> Map.of(AttributeKey.DUR.key, AttributeKey.DUR.value, AttributeKey.AMR.key, AttributeKey.AMR.value, AttributeKey.KBR.key, AttributeKey.KBR.value, AttributeKey.TUF.key, AttributeKey.TUF.value))), Map.of(AttributeKey.DMG.key, AttributeKey.DMG.value, AttributeKey.HEALTH.key, AttributeKey.HEALTH.value, AttributeKey.SPEED.key, AttributeKey.SPEED.value));
        private static final String HARDNESS = "hardness_modifier";
        private static final String TOOL_TWEAKS = "tool_tweaks";
        private static final String WEAR_TWEAKS = "wearable_tweaks";
        private static final String ENTITY_TWEAK = "entity_tweaks";
        private static final String TYPE = "type";
        public static final Codec<Tweaks> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf(HARDNESS).forGetter(Tweaks::hardnessModifier), (App)Codec.simpleMap(UtensilTypes.CODEC, CodecTypes.DOUBLE_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])UtensilTypes.values())).fieldOf(TOOL_TWEAKS).forGetter(Tweaks::utensilTweaks), (App)Codec.simpleMap(WearableTypes.CODEC, CodecTypes.DOUBLE_CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])WearableTypes.values())).fieldOf(WEAR_TWEAKS).forGetter(Tweaks::wearableTweaks), (App)CodecTypes.DOUBLE_CODEC.fieldOf(ENTITY_TWEAK).forGetter(Tweaks::entityTweaks)).apply((Applicative)instance, Tweaks::new));

        public static Tweaks fromValues(String param, Map<String, String> values, AutoValueConfig current) {
            double hardness = param.equals(HARDNESS) ? Functions.getDouble(values) : current.tweaks().hardnessModifier();
            HashMap<UtensilTypes, Map<String, Double>> utensil = new HashMap<UtensilTypes, Map<String, Double>>(current.tweaks().utensilTweaks);
            if (param.equals(TOOL_TWEAKS)) {
                UtensilTypes type = UtensilTypes.byName(values.getOrDefault(TYPE, ""));
                if (type == null) {
                    MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, "tool tweaks type invalid: %s", values.getOrDefault(TYPE, "no value provided"));
                } else {
                    utensil.put(type, Functions.doubleMap(values.getOrDefault("value", "")));
                }
            }
            HashMap<WearableTypes, Map<String, Double>> wearable = new HashMap<WearableTypes, Map<String, Double>>(current.tweaks().wearableTweaks);
            if (param.equals(WEAR_TWEAKS)) {
                WearableTypes type = WearableTypes.byName(values.getOrDefault(TYPE, ""));
                if (type == null) {
                    MsLoggy.ERROR.log(MsLoggy.LOG_CODE.DATA, "wearable tweaks type invalide: %s", values.getOrDefault(TYPE, "no value provided"));
                } else {
                    wearable.put(type, Functions.doubleMap(values.getOrDefault("value", "")));
                }
            }
            Map<String, Double> entitweak = param.equals(ENTITY_TWEAK) ? Functions.doubleMap(values.getOrDefault("value", "")) : current.tweaks().entityTweaks;
            return new Tweaks(hardness, utensil, wearable, entitweak);
        }

        public Double utensil(UtensilTypes type, AttributeKey key) {
            return ((Map)this.utensilTweaks().getOrDefault((Object)type, new HashMap())).getOrDefault(key.key, 0.0);
        }

        public Double wearable(WearableTypes type, AttributeKey key) {
            return ((Map)this.wearableTweaks().getOrDefault((Object)type, new HashMap())).getOrDefault(key.key, 0.0);
        }
    }

    public static enum AttributeKey {
        DUR("Durability", 0.01),
        TIER("Tier", 10.0),
        DMG("Damage", 1.5),
        SPD("Attack_Speed", 10.0),
        DIG("Dig_Speed", 10.0),
        AMR("Armor", 10.0),
        KBR("Knockback_Resistance", 10.0),
        TUF("Toughness", 10.0),
        HEALTH("Health", 0.5),
        SPEED("Move_Speed", 0.15);

        String key;
        double value;

        private AttributeKey(String key, double value) {
            this.key = key;
            this.value = value;
        }
    }

    public static enum WearableTypes implements StringRepresentable
    {
        HEAD,
        CHEST,
        LEGS,
        BOOTS,
        WINGS;

        public static final Codec<WearableTypes> CODEC;
        public static final Map<String, WearableTypes> BY_NAME;

        public static WearableTypes byName(String name) {
            return BY_NAME.get(name);
        }

        public String getSerializedName() {
            return this.name();
        }

        public static WearableTypes create(String name) {
            throw new IllegalStateException("Enum not extended");
        }

        public static WearableTypes fromSlot(EquipmentSlot slot, boolean isElytra) {
            if (slot == null) {
                return null;
            }
            return switch (slot) {
                case EquipmentSlot.HEAD -> HEAD;
                case EquipmentSlot.CHEST -> {
                    if (isElytra) {
                        yield WINGS;
                    }
                    yield CHEST;
                }
                case EquipmentSlot.LEGS -> LEGS;
                case EquipmentSlot.FEET -> BOOTS;
                default -> null;
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(WearableTypes::values);
            BY_NAME = Arrays.stream(WearableTypes.values()).collect(Collectors.toMap(WearableTypes::getSerializedName, s -> s));
        }
    }

    public static enum UtensilTypes implements StringRepresentable
    {
        SWORD,
        PICKAXE,
        AXE,
        SHOVEL,
        HOE;

        public static final Codec<UtensilTypes> CODEC;
        public static final Map<String, UtensilTypes> BY_NAME;

        public static UtensilTypes byName(String name) {
            return BY_NAME.get(name);
        }

        public String getSerializedName() {
            return this.name();
        }

        public static UtensilTypes create(String name) {
            throw new IllegalStateException("Enum not extended");
        }

        static {
            CODEC = StringRepresentable.fromEnum(UtensilTypes::values);
            BY_NAME = Arrays.stream(UtensilTypes.values()).collect(Collectors.toMap(UtensilTypes::getSerializedName, s -> s));
        }
    }
}

