/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.fireworks;

import harmonised.pmmo.api.perks.Perk;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.features.fireworks.PMMOFireworkEntity;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.TagBuilder;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireworkHandler {
    public static final String FIREWORK_SKILL = "firework_skill";
    public static final Perk FIREWORK = Perk.begin().addDefaults(TagBuilder.start().withString("firework_skill", "none").build()).setStart((player, nbt) -> {
        BlockPos pos = player.blockPosition();
        FireworkHandler.spawnRocket(player.level(), new Vec3((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()), (String)nbt.getString(FIREWORK_SKILL).get());
        return new CompoundTag();
    }).setDescription(LangProvider.PERK_FIREWORK_DESC.asComponent()).setStatus((p, nbt) -> List.of(LangProvider.PERK_FIREWORK_STATUS_1.asComponent(Component.translatable((String)("pmmo." + String.valueOf(nbt.getString("skill")))).withStyle(CoreUtils.getSkillStyle((String)nbt.getString("skill").get()))))).build();

    public static void spawnRocket(Level world, Vec3 pos, String skill) {
        IntList colors = IntList.of((int)CoreUtils.getSkillColor(skill));
        ItemStack itemStack = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        FireworkExplosion explosion = new FireworkExplosion(FireworkExplosion.DEFAULT.shape(), colors, colors, false, true);
        itemStack.set(DataComponents.FIREWORKS, (Object)new Fireworks(0, List.of(explosion)));
        PMMOFireworkEntity fireworkRocketEntity = new PMMOFireworkEntity(world, pos.x() + 0.5, pos.y() + 0.5, pos.z() + 0.5, itemStack);
        world.addFreshEntity((Entity)fireworkRocketEntity);
    }
}

