/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.loot_modifiers.GLMRegistry;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class SkillLootConditionHighestSkill
implements LootItemCondition {
    public String targetSkill;
    public List<String> comparables;
    public static final MapCodec<SkillLootConditionHighestSkill> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("target_skill").forGetter(SkillLootConditionHighestSkill::getTargetSkill), (App)Codec.list((Codec)Codec.STRING).fieldOf("comparable_skills").forGetter(SkillLootConditionHighestSkill::getComparables)).apply((Applicative)instance, SkillLootConditionHighestSkill::new));

    public SkillLootConditionHighestSkill(String skill, List<String> comparables) {
        this.targetSkill = skill;
        this.comparables = comparables;
    }

    public boolean test(LootContext t) {
        Entity player = (Entity)t.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (player == null || this.targetSkill == null || this.comparables.isEmpty()) {
            return false;
        }
        long targetLevel = Core.get(player.level()).getData().getLevel(this.targetSkill, player.getUUID());
        for (String comparable : this.comparables) {
            if (comparable.equals(this.targetSkill) || targetLevel >= Core.get(player.level()).getData().getLevel(comparable, player.getUUID())) continue;
            return false;
        }
        return true;
    }

    public String getTargetSkill() {
        return this.targetSkill;
    }

    public List<String> getComparables() {
        return this.comparables;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)GLMRegistry.HIGHEST_SKILL.get();
    }
}

