/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.loot_modifiers.GLMRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class SkillLootConditionPlayer
implements LootItemCondition {
    public String skill;
    public Integer levelMin;
    public Integer levelMax;
    public static final MapCodec<SkillLootConditionPlayer> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("level_min").forGetter(SkillLootConditionPlayer::getLevelMin), (App)Codec.INT.fieldOf("level_max").forGetter(SkillLootConditionPlayer::getLevelMax), (App)Codec.STRING.fieldOf("skill").forGetter(SkillLootConditionPlayer::getSkill)).apply((Applicative)instance, SkillLootConditionPlayer::new));

    public SkillLootConditionPlayer(Integer levelMin, Integer levelMax, String skill) {
        this.levelMin = levelMin;
        this.levelMax = levelMax;
        this.skill = skill;
    }

    public boolean test(LootContext t) {
        Entity player = (Entity)t.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if (player == null || this.skill == null) {
            return false;
        }
        long actualLevel = Core.get(player.level()).getData().getLevel(this.skill, player.getUUID());
        return !(this.levelMin != null && actualLevel < (long)this.levelMin.intValue() || this.levelMax != null && actualLevel > (long)this.levelMax.intValue());
    }

    public String getSkill() {
        return this.skill;
    }

    public Integer getLevelMin() {
        return this.levelMin;
    }

    public Integer getLevelMax() {
        return this.levelMax;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)GLMRegistry.SKILL_PLAYER.get();
    }
}

