/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.loot_modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.features.loot_modifiers.GLMRegistry;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public class ValidBlockCondition
implements LootItemCondition {
    public Optional<TagKey<Block>> tag = Optional.empty();
    public Optional<Block> block = Optional.empty();
    public static final MapCodec<ValidBlockCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("tag").xmap(s -> s.map(v -> TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)Reference.of(v))), t -> t.map(k -> k.location().toString())).forGetter(c -> c.tag), (App)Codec.STRING.optionalFieldOf("block").xmap(s -> s.map(v -> (Block)BuiltInRegistries.BLOCK.getValue(Reference.of(v))), t -> t.map(k -> RegistryUtil.getId(k).toString())).forGetter(c -> c.block)).apply((Applicative)instance, ValidBlockCondition::new));

    public ValidBlockCondition(Optional<TagKey<Block>> tag, Optional<Block> block) {
        this.tag = tag;
        this.block = block;
    }

    public ValidBlockCondition(TagKey<Block> tag) {
        this.tag = Optional.of(tag);
    }

    public ValidBlockCondition(Block block) {
        this.block = Optional.of(block);
    }

    public boolean test(LootContext t) {
        if (t.getOptionalParameter(LootContextParams.THIS_ENTITY) == null) {
            return false;
        }
        BlockState brokenBlock = (BlockState)t.getOptionalParameter(LootContextParams.BLOCK_STATE);
        if (brokenBlock != null) {
            if (this.tag.isPresent()) {
                return brokenBlock.is(this.tag.get());
            }
            if (this.block.isPresent()) {
                return brokenBlock.getBlock().equals(this.block.get());
            }
        }
        return false;
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)GLMRegistry.VALID_BLOCK.get();
    }
}

