/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.features.veinmining;

import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.compat.curios.CuriosCompat;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.features.veinmining.VeinShapeData;
import harmonised.pmmo.setup.CommonSetup;
import harmonised.pmmo.util.MsLoggy;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class VeinMiningLogic {
    public static final String VEIN_DATA = "vein_data";
    public static final Map<UUID, Integer> maxBlocksPerPlayer = new HashMap<UUID, Integer>();
    public static final Map<UUID, VeinShapeData.ShapeType> shapePerPlayer = new HashMap<UUID, VeinShapeData.ShapeType>();

    public static void applyVein(ServerPlayer player, BlockPos pos) {
        if (!Config.server().veinMiner().enabled()) {
            return;
        }
        ServerLevel level = player.level();
        Block block = level.getBlockState(pos).getBlock();
        int cost = Core.get((Level)level).getBlockConsume(block);
        if (cost <= 0) {
            return;
        }
        double charge = player.getAttribute(CommonSetup.VEIN_AMOUNT).getValue();
        int consumed = 0;
        int maxBlocks = Math.min((int)charge / cost, maxBlocksPerPlayer.computeIfAbsent(player.getUUID(), id -> 64));
        VeinShapeData.ShapeType mode = shapePerPlayer.computeIfAbsent(player.getUUID(), id -> VeinShapeData.ShapeType.AOE);
        VeinShapeData veinData = new VeinShapeData((Level)level, pos, maxBlocks, mode, player.getDirection());
        for (BlockPos veinable : veinData.getVein()) {
            consumed += cost;
            player.gameMode.destroyAndAck(veinable, 1, "Vein Break");
        }
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Vein Consumed: " + consumed + " charge", new Object[0]);
        VeinMiningLogic.setAmount((Player)player, charge - (double)consumed);
    }

    public static void regenerateVein(ServerPlayer player) {
        if (!Config.server().veinMiner().enabled()) {
            return;
        }
        Inventory inv = player.getInventory();
        List<ItemStack> items = List.of(inv.getItem(36), inv.getItem(37), inv.getItem(38), inv.getItem(39), player.getMainHandItem(), player.getOffhandItem());
        if (CuriosCompat.hasCurio) {
            items = new ArrayList<ItemStack>(items);
            items.addAll(CuriosCompat.getItems((Player)player));
        }
        Core core = Core.get((Level)player.level());
        double currentCharge = VeinMiningLogic.veinAmount((Player)player);
        int chargeCap = VeinMiningLogic.getCap((Player)player);
        double chargeRate = VeinMiningLogic.getCharge((Player)player);
        for (ItemStack stack : items) {
            if (!core.isActionPermitted(ReqType.WEAR, stack, (Player)player)) continue;
            VeinData data = core.getLoader().ITEM_LOADER.getData(RegistryUtil.getId(player.level().registryAccess(), stack)).veinData();
            chargeCap += data.chargeCap.orElse(0).intValue();
            chargeRate += data.chargeRate.orElse(0.0).doubleValue();
        }
        if (chargeRate == 0.0 || chargeCap == 0 || currentCharge >= (double)chargeCap) {
            return;
        }
        int fCap = chargeCap;
        double fRate = chargeRate * Config.server().veinMiner().chargeModifier();
        if (currentCharge + fRate >= (double)fCap) {
            VeinMiningLogic.setAmount((Player)player, fCap);
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Regen at Cap: " + fCap, new Object[0]);
        } else {
            VeinMiningLogic.setAmount((Player)player, currentCharge + fRate);
            MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Regen: " + (currentCharge + fRate), new Object[0]);
        }
    }

    public static int getMaxChargeFromAllItems(Player player) {
        Inventory inv = player.getInventory();
        List<ItemStack> items = List.of(inv.getItem(36), inv.getItem(37), inv.getItem(38), inv.getItem(39), player.getMainHandItem(), player.getOffhandItem());
        if (CuriosCompat.hasCurio) {
            items = new ArrayList<ItemStack>(items);
            items.addAll(CuriosCompat.getItems(player));
        }
        int totalCapacity = VeinMiningLogic.getCap(player) + items.stream().filter(stack -> Core.get(player.level()).isActionPermitted(ReqType.WEAR, (ItemStack)stack, player)).mapToInt(stack -> Core.get((Level)player.level()).getLoader().ITEM_LOADER.getData((ResourceLocation)RegistryUtil.getId((RegistryAccess)player.level().registryAccess(), (ItemStack)stack)).veinData().chargeCap.orElse(0)).sum();
        MsLoggy.DEBUG.log(MsLoggy.LOG_CODE.FEATURE, "Vein Capacity: " + totalCapacity, new Object[0]);
        return totalCapacity;
    }

    public static double veinAmount(Player player) {
        AttributeInstance attribute = player.getAttribute(CommonSetup.VEIN_AMOUNT);
        return attribute == null ? 0.0 : attribute.getValue();
    }

    public static void setAmount(Player player, double amount) {
        AttributeInstance attribute = player.getAttribute(CommonSetup.VEIN_AMOUNT);
        if (attribute != null) {
            attribute.setBaseValue(amount);
        }
    }

    public static int getCap(Player player) {
        AttributeInstance attribute = player.getAttribute(CommonSetup.VEIN_CAPACITY);
        return attribute == null ? 0 : (int)attribute.getValue();
    }

    public static int getCharge(Player player) {
        AttributeInstance attribute = player.getAttribute(CommonSetup.VEIN_RECHARGE);
        return attribute == null ? 0 : (int)attribute.getValue();
    }
}

