/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.mixin;

import harmonised.pmmo.storage.DataAttachmentTypes;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public class ServerLevelMixin {
    @Inject(method={"destroyBlock(Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/entity/Entity;I)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;II)Z")})
    public void setBlockInvocation(BlockPos pos, boolean p_46627_, @Nullable Entity entity, int p_46629_, CallbackInfoReturnable<?> ci) {
        if ((Level)this instanceof ServerLevel) {
            ServerLevelMixin.execute(pos, (Level)this);
        }
    }

    private static void execute(BlockPos pos, Level level) {
        BlockState state = level.getBlockState(pos);
        Map breakMap = (Map)level.getChunkAt(pos).getData(DataAttachmentTypes.BREAK_MAP.get());
        for (BlockPos neighbor : ServerLevelMixin.getNeighbors(pos)) {
            ServerPlayer player;
            UUID playerID = (UUID)breakMap.get(neighbor);
            if (playerID == null || (player = level.getServer().getPlayerList().getPlayer(playerID)) == null) continue;
            NeoForge.EVENT_BUS.post((Event)new BlockEvent.BreakEvent(level, pos, state, (Player)player));
            breakMap.put(neighbor, playerID);
            level.getChunkAt(pos).markUnsaved();
            break;
        }
    }

    private static Set<BlockPos> getNeighbors(BlockPos src) {
        return Set.of(src.above(), src.below(), src.north(), src.south(), src.west(), src.east());
    }
}

