/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.util.MsLoggy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TooltipRegistry {
    private Map<ReqType, HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>> itemReqTooltips = new HashMap<ReqType, HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>>();
    private Map<ReqType, HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>> blockReqTooltips = new HashMap<ReqType, HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>>();
    private Map<ReqType, HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>> entityReqTooltips = new HashMap<ReqType, HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>>();
    private Map<EventType, HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>> itemXpGainTooltips = new HashMap<EventType, HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>>();
    private Map<EventType, HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>> blockXpGainTooltips = new HashMap<EventType, HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>>();
    private Map<EventType, HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>> entityXpGainTooltips = new HashMap<EventType, HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>>();
    private Map<ModifierDataType, HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Double>>>> itemBonusTooltips = new HashMap<ModifierDataType, HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Double>>>>();

    public void clearRegistry() {
        this.itemReqTooltips = new HashMap<ReqType, HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>>();
        this.blockReqTooltips = new HashMap<ReqType, HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>>();
        this.entityReqTooltips = new HashMap<ReqType, HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>>();
        this.itemXpGainTooltips = new HashMap<EventType, HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>>();
        this.blockXpGainTooltips = new HashMap<EventType, HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>>();
        this.entityXpGainTooltips = new HashMap<EventType, HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>>();
        this.itemBonusTooltips = new HashMap<ModifierDataType, HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Double>>>>();
    }

    public void registerItemRequirementTooltipData(ResourceLocation res, ReqType reqType, Function<ItemStack, Map<String, Long>> func) {
        if (func == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied Function Null", new Object[0]);
            return;
        }
        if (reqType == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied ReqType Null", new Object[0]);
            return;
        }
        if (res == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied ResourceLocation Null", new Object[0]);
            return;
        }
        if (!this.itemReqTooltips.containsKey(reqType)) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip category created for: " + reqType.toString(), new Object[0]);
            this.itemReqTooltips.put(reqType, (HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>)HashMultimap.create());
        }
        this.itemReqTooltips.get(reqType).get((Object)res).add(func);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip registered for: " + reqType.toString() + " " + res.toString(), new Object[0]);
    }

    public void registerBlockRequirementTooltipData(ResourceLocation res, ReqType reqType, Function<BlockEntity, Map<String, Long>> func) {
        if (func == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied Function Null", new Object[0]);
            return;
        }
        if (reqType == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied ReqType Null", new Object[0]);
            return;
        }
        if (res == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied ResourceLocation Null", new Object[0]);
            return;
        }
        if (!this.blockReqTooltips.containsKey(reqType)) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip category created for: " + reqType.toString(), new Object[0]);
            this.blockReqTooltips.put(reqType, (HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>)HashMultimap.create());
        }
        this.blockReqTooltips.get(reqType).get((Object)res).add(func);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip registered for: " + reqType.toString() + " " + res.toString(), new Object[0]);
    }

    public void registerEntityRequirementTooltipData(ResourceLocation res, ReqType reqType, Function<Entity, Map<String, Long>> func) {
        if (func == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied Function Null", new Object[0]);
            return;
        }
        if (reqType == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied ReqType Null", new Object[0]);
            return;
        }
        if (res == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied ResourceLocation Null", new Object[0]);
            return;
        }
        if (!this.blockReqTooltips.containsKey(reqType)) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip category created for: " + reqType.toString() + " " + res.toString(), new Object[0]);
            this.entityReqTooltips.put(reqType, (HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>)HashMultimap.create());
        }
        this.entityReqTooltips.get(reqType).get((Object)res).add(func);
    }

    public boolean requirementTooltipExists(ResourceLocation res, ReqType reqType) {
        Preconditions.checkNotNull((Object)res);
        Preconditions.checkNotNull((Object)reqType);
        return this.blockReqTooltips.getOrDefault(reqType, (HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>)HashMultimap.create()).containsKey((Object)res) || this.entityReqTooltips.getOrDefault(reqType, (HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>)HashMultimap.create()).containsKey((Object)res) || this.itemReqTooltips.getOrDefault(reqType, (HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>)HashMultimap.create()).containsKey((Object)res);
    }

    public Map<String, Long> getItemRequirementTooltipData(ResourceLocation res, ReqType reqType, ItemStack stack) {
        if (this.requirementTooltipExists(res, reqType)) {
            HashMap<String, Long> suppliedData = new HashMap<String, Long>();
            ArrayList<Map> rawData = new ArrayList<Map>();
            for (Function func : this.itemReqTooltips.get(reqType).get((Object)res)) {
                rawData.add((Map)func.apply(stack));
            }
            for (int i = 0; i < rawData.size(); ++i) {
                for (Map.Entry entry : ((Map)rawData.get(i)).entrySet()) {
                    suppliedData.merge((String)entry.getKey(), (Long)entry.getValue(), Long::max);
                }
            }
            return suppliedData;
        }
        return new HashMap<String, Long>();
    }

    public Map<String, Long> getBlockRequirementTooltipData(ResourceLocation res, ReqType reqType, BlockEntity tile) {
        if (this.requirementTooltipExists(res, reqType)) {
            HashMap<String, Long> suppliedData = new HashMap<String, Long>();
            ArrayList<Map> rawData = new ArrayList<Map>();
            for (Function func : this.blockReqTooltips.get(reqType).get((Object)res)) {
                rawData.add((Map)func.apply(tile));
            }
            for (int i = 0; i < rawData.size(); ++i) {
                for (Map.Entry entry : ((Map)rawData.get(i)).entrySet()) {
                    suppliedData.merge((String)entry.getKey(), (Long)entry.getValue(), Long::max);
                }
            }
            return suppliedData;
        }
        return new HashMap<String, Long>();
    }

    public Map<String, Long> getEntityRequirementTooltipData(ResourceLocation res, ReqType reqType, Entity entity) {
        if (this.requirementTooltipExists(res, reqType)) {
            HashMap<String, Long> suppliedData = new HashMap<String, Long>();
            ArrayList<Map> rawData = new ArrayList<Map>();
            for (Function func : this.entityReqTooltips.get(reqType).get((Object)res)) {
                rawData.add((Map)func.apply(entity));
            }
            for (int i = 0; i < rawData.size(); ++i) {
                for (Map.Entry entry : ((Map)rawData.get(i)).entrySet()) {
                    suppliedData.merge((String)entry.getKey(), (Long)entry.getValue(), Long::max);
                }
            }
            return suppliedData;
        }
        return new HashMap<String, Long>();
    }

    public void registerItemXpGainTooltipData(ResourceLocation res, EventType eventType, Function<ItemStack, Map<String, Long>> func) {
        Preconditions.checkNotNull((Object)res);
        Preconditions.checkNotNull((Object)eventType);
        Preconditions.checkNotNull(func);
        if (!this.itemXpGainTooltips.containsKey(eventType)) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip category created for: " + eventType.toString() + " " + res.toString(), new Object[0]);
            this.itemXpGainTooltips.put(eventType, (HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>)HashMultimap.create());
        }
        this.itemXpGainTooltips.get(eventType).get((Object)res).add(func);
    }

    public void registerBlockXpGainTooltipData(ResourceLocation res, EventType eventType, Function<BlockEntity, Map<String, Long>> func) {
        Preconditions.checkNotNull((Object)res);
        Preconditions.checkNotNull((Object)eventType);
        Preconditions.checkNotNull(func);
        if (!this.blockXpGainTooltips.containsKey(eventType)) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip category created for: " + eventType.toString() + " " + res.toString(), new Object[0]);
            this.blockXpGainTooltips.put(eventType, (HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>)HashMultimap.create());
        }
        this.blockXpGainTooltips.get(eventType).get((Object)res).add(func);
    }

    public void registerEntityXpGainTooltipData(ResourceLocation res, EventType eventType, Function<Entity, Map<String, Long>> func) {
        Preconditions.checkNotNull((Object)res);
        Preconditions.checkNotNull((Object)eventType);
        Preconditions.checkNotNull(func);
        if (!this.entityXpGainTooltips.containsKey(eventType)) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip category created for: " + eventType.toString() + " " + res.toString(), new Object[0]);
            this.entityXpGainTooltips.put(eventType, (HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>)HashMultimap.create());
        }
        this.entityXpGainTooltips.get(eventType).get((Object)res).add(func);
    }

    public boolean xpGainTooltipExists(ResourceLocation res, EventType eventType) {
        Preconditions.checkNotNull((Object)res);
        Preconditions.checkNotNull((Object)eventType);
        return this.blockXpGainTooltips.getOrDefault(eventType, (HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>)HashMultimap.create()).containsKey((Object)res) || this.entityXpGainTooltips.getOrDefault(eventType, (HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>)HashMultimap.create()).containsKey((Object)res) || this.itemXpGainTooltips.getOrDefault(eventType, (HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>)HashMultimap.create()).containsKey((Object)res);
    }

    public Map<String, Long> getItemXpGainTooltipData(ResourceLocation itemID, EventType eventType, ItemStack stack) {
        ArrayList<Map> rawData = new ArrayList<Map>();
        HashMap<String, Long> outData = new HashMap<String, Long>();
        Set functions = this.itemXpGainTooltips.getOrDefault(eventType, (HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Long>>>)HashMultimap.create()).get((Object)itemID);
        for (Function func : functions) {
            rawData.add((Map)func.apply(stack));
        }
        for (Map map : rawData) {
            for (Map.Entry entry : map.entrySet()) {
                outData.merge((String)entry.getKey(), (Long)entry.getValue(), Long::max);
            }
        }
        return outData;
    }

    public Map<String, Long> getBlockXpGainTooltipData(ResourceLocation blockID, EventType eventType, BlockEntity tile) {
        ArrayList<Map> rawData = new ArrayList<Map>();
        HashMap<String, Long> outData = new HashMap<String, Long>();
        Set functions = this.blockXpGainTooltips.getOrDefault(eventType, (HashMultimap<ResourceLocation, Function<BlockEntity, Map<String, Long>>>)HashMultimap.create()).get((Object)blockID);
        for (Function func : functions) {
            rawData.add((Map)func.apply(tile));
        }
        for (Map map : rawData) {
            for (Map.Entry entry : map.entrySet()) {
                outData.merge((String)entry.getKey(), (Long)entry.getValue(), Long::max);
            }
        }
        return outData;
    }

    public Map<String, Long> getEntityXpGainTooltipData(ResourceLocation entityID, EventType eventType, Entity entity) {
        ArrayList<Map> rawData = new ArrayList<Map>();
        HashMap<String, Long> outData = new HashMap<String, Long>();
        Set functions = this.entityXpGainTooltips.getOrDefault(eventType, (HashMultimap<ResourceLocation, Function<Entity, Map<String, Long>>>)HashMultimap.create()).get((Object)entityID);
        for (Function func : functions) {
            rawData.add((Map)func.apply(entity));
        }
        for (Map map : rawData) {
            for (Map.Entry entry : map.entrySet()) {
                outData.merge((String)entry.getKey(), (Long)entry.getValue(), Long::max);
            }
        }
        return outData;
    }

    public void registerItemBonusTooltipData(ResourceLocation res, ModifierDataType type, Function<ItemStack, Map<String, Double>> func) {
        if (func == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied Function Null", new Object[0]);
            return;
        }
        if (type == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied ModifierType Null", new Object[0]);
            return;
        }
        if (res == null) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "Supplied ResourceLocation Null", new Object[0]);
            return;
        }
        if (!this.itemBonusTooltips.containsKey(type)) {
            MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip category created for: " + type.toString(), new Object[0]);
            this.itemBonusTooltips.put(type, (HashMultimap<ResourceLocation, Function<ItemStack, Map<String, Double>>>)HashMultimap.create());
        }
        this.itemBonusTooltips.get(type).get((Object)res).add(func);
        MsLoggy.INFO.log(MsLoggy.LOG_CODE.API, "New tooltip registered for: " + type.toString() + " " + res.toString(), new Object[0]);
    }

    public boolean bonusTooltipExists(ResourceLocation res, ModifierDataType type) {
        if (res == null) {
            return false;
        }
        if (type == null) {
            return false;
        }
        if (this.itemBonusTooltips.containsKey(type)) {
            return this.itemBonusTooltips.get(type).containsKey((Object)res);
        }
        return false;
    }

    public Map<String, Double> getBonusTooltipData(ResourceLocation res, ModifierDataType type, ItemStack stack) {
        if (this.bonusTooltipExists(res, type)) {
            HashMap<String, Double> suppliedData = new HashMap<String, Double>();
            ArrayList<Map> rawData = new ArrayList<Map>();
            for (Function func : this.itemBonusTooltips.get(type).get((Object)res)) {
                rawData.add((Map)func.apply(stack));
            }
            for (int i = 0; i < rawData.size(); ++i) {
                for (Map.Entry entry : ((Map)rawData.get(i)).entrySet()) {
                    suppliedData.merge((String)entry.getKey(), (Double)entry.getValue(), Double::max);
                }
            }
            return suppliedData;
        }
        return new HashMap<String, Double>();
    }
}

