/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.setup.datagen.defaultpacks;

import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.setup.datagen.PmmoDataProvider;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class DefaultBlockConfigProvider
extends PmmoDataProvider<ObjectData> {
    Map<ResourceLocation, ObjectData.Builder> data = new HashMap<ResourceLocation, ObjectData.Builder>();

    public DefaultBlockConfigProvider(PackOutput gen) {
        super(gen, "default", "pmmo/blocks", ObjectData.CODEC.codec());
    }

    @Override
    protected void start() {
        this.populateData();
        this.data.forEach((id, builder) -> this.add((ResourceLocation)id, builder.end()));
    }

    private void populateData() {
        this.miningBreak(Blocks.COAL_ORE, 25L, Tags.Blocks.ORES_COAL);
        this.miningBreak(Blocks.DEEPSLATE_COAL_ORE, 50L, new TagKey[0]);
        this.miningBreak(Blocks.COPPER_ORE, 30L, Tags.Blocks.ORES_COPPER);
        this.miningBreak(Blocks.DEEPSLATE_COPPER_ORE, 60L, new TagKey[0]);
        this.miningBreak(Blocks.IRON_ORE, 150L, Tags.Blocks.ORES_IRON);
        this.miningBreak(Blocks.DEEPSLATE_IRON_ORE, 300L, new TagKey[0]);
        this.miningBreak(Blocks.GOLD_ORE, 200L, Tags.Blocks.ORES_GOLD);
        this.miningBreak(Blocks.DEEPSLATE_GOLD_ORE, 400L, new TagKey[0]);
        this.miningBreak(Blocks.NETHER_GOLD_ORE, 400L, new TagKey[0]);
        this.miningBreak(Blocks.REDSTONE_ORE, 150L, Tags.Blocks.ORES_REDSTONE);
        this.miningBreak(Blocks.DEEPSLATE_REDSTONE_ORE, 300L, new TagKey[0]);
        this.miningBreak(Blocks.DIAMOND_ORE, 750L, Tags.Blocks.ORES_DIAMOND);
        this.miningBreak(Blocks.DEEPSLATE_DIAMOND_ORE, 750L, new TagKey[0]);
        this.miningBreak(Blocks.EMERALD_ORE, 400L, Tags.Blocks.ORES_EMERALD);
        this.miningBreak(Blocks.DEEPSLATE_EMERALD_ORE, 10000L, new TagKey[0]);
        this.miningBreak(Blocks.LAPIS_ORE, 50L, Tags.Blocks.ORES_LAPIS);
        this.miningBreak(Blocks.DEEPSLATE_LAPIS_ORE, 100L, new TagKey[0]);
        this.miningBreak(Blocks.NETHER_QUARTZ_ORE, 100L, Tags.Blocks.ORES_QUARTZ);
        this.miningBreak(Blocks.ANCIENT_DEBRIS, 1500L, new TagKey[0]);
        this.tagGet((TagKey<Block>)BlockTags.BASE_STONE_OVERWORLD).addTag(BlockTags.BASE_STONE_NETHER).addTag("polished_andesite", "polished_deepslate", "polished_diorite", "polished_granite", "cobblestone", "cobbled_deepslate", "calcite", "infested_deepslate", "infested_stone", "nether_bricks", "magma_block").addXpValues(EventType.BLOCK_BREAK, Map.of("mining", 10L));
        this.tagGet((TagKey<Block>)Tags.Blocks.OBSIDIANS).addXpValues(EventType.BLOCK_BREAK, Map.of("mining", 2000L)).addReq(ReqType.BREAK, Map.of("mining", 30L)).setVeinConsume(25);
        this.excavationBreak(Blocks.DIRT, 150L, BlockTags.DIRT);
        for (Block block : List.of(Blocks.BONE_BLOCK, Blocks.CRIMSON_NYLIUM, Blocks.DIRT_PATH, Blocks.FARMLAND, Blocks.GRAVEL, Blocks.RED_SAND, Blocks.SAND, Blocks.SOUL_SAND, Blocks.SOUL_SOIL, Blocks.WARPED_NYLIUM)) {
            this.excavationBreak(block, 150L, new TagKey[0]);
        }
        this.tagGet((TagKey<Block>)BlockTags.LOGS).addXpValues(EventType.BLOCK_BREAK, Map.of("woodcutting", 80L)).addXpValues(EventType.BLOCK_PLACE, Map.of("building", 10L)).addReq(ReqType.BREAK, Map.of("woodcutting", 0L));
        this.tagGet((TagKey<Block>)BlockTags.LEAVES).addXpValues(EventType.BLOCK_BREAK, Map.of("woodcutting", 11L)).addReq(ReqType.BREAK, Map.of("woodcutting", 0L));
        this.tagGet((TagKey<Block>)BlockTags.PLANKS).addXpValues(EventType.BLOCK_BREAK, Map.of("woodcutting", 50L)).addXpValues(EventType.BLOCK_PLACE, Map.of("building", 10L)).addReq(ReqType.BREAK, Map.of("woodcutting", 0L)).addReq(ReqType.PLACE, Map.of("woodcutting", 0L));
        this.tagGet((TagKey<Block>)BlockTags.SAPLINGS).addXpValues(EventType.GROW, Map.of("farming", 300L)).addReq(ReqType.PLACE, Map.of("farming", 5L, "woodcutting", 10L));
        this.tagGet((TagKey<Block>)Tags.Blocks.BOOKSHELVES).addXpValues(EventType.BLOCK_BREAK, Map.of("woodcutting", 500L));
        this.doFor(builder -> builder.addXpValues(EventType.BLOCK_BREAK, Map.of("farming", 20L, "woodcutting", 40L)).addXpValues(EventType.GROW, Map.of("farming", 12L)), Blocks.BAMBOO, Blocks.BAMBOO_SAPLING);
        this.farmingXp(150L, 120L, Blocks.BEETROOTS);
        this.farmingXp(100L, 0L, Blocks.BROWN_MUSHROOM, Blocks.BROWN_MUSHROOM_BLOCK);
        this.farmingXp(20L, 60L, Blocks.CACTUS);
        this.farmingXp(10L, 80L, Blocks.CARROTS);
        this.farmingXp(350L, 80L, Blocks.CHORUS_FLOWER);
        this.farmingXp(25L, 80L, Blocks.CHORUS_PLANT);
        this.farmingXp(10L, 170L, Blocks.COCOA);
        this.farmingXp(100L, 300L, Blocks.CRIMSON_FUNGUS);
        this.farmingXp(0L, 20L, Blocks.KELP, Blocks.KELP_PLANT);
        this.farmingXp(100L, 0L, Blocks.MUSHROOM_STEM);
        this.farmingXp(0L, 110L, Blocks.NETHER_WART);
        this.farmingXp(66L, 66L, Blocks.POTATOES);
        this.farmingXp(100L, 0L, Blocks.RED_MUSHROOM, Blocks.RED_MUSHROOM_BLOCK);
        this.farmingXp(0L, 40L, Blocks.SEA_PICKLE);
        this.farmingXp(1L, 1L, Blocks.SEAGRASS, Blocks.TALL_SEAGRASS);
        this.farmingXp(10L, 50L, Blocks.SUGAR_CANE);
        this.farmingXp(100L, 300L, Blocks.WARPED_FUNGUS);
        this.farmingXp(10L, 90L, Blocks.WHEAT);
        this.get(Blocks.BLAST_FURNACE).addReq(ReqType.PLACE, Map.of("building", 10L));
        this.get(Blocks.ENCHANTING_TABLE).addReq(ReqType.PLACE, Map.of("building", 25L));
        this.get(Blocks.SCAFFOLDING).addReq(ReqType.PLACE, Map.of("building", 10L));
        this.get(Blocks.SMOKER).addReq(ReqType.PLACE, Map.of("building", 10L));
        this.get(Blocks.STONECUTTER).addReq(ReqType.PLACE, Map.of("building", 10L));
        this.get(Blocks.FROSTED_ICE).addXpValues(EventType.BLOCK_PLACE, Map.of("magic", 1L));
        for (String first : List.of("blood", "earth", "ender", "ichor", "sky")) {
            for (String second : List.of("earth", "ender", "ichor", "sky", "vanilla")) {
                this.get("tconstruct:" + first + "_" + second + "_slime_grass").addXpValues(EventType.BLOCK_BREAK, Map.of("excavation", 50L)).addXpValues(EventType.BLOCK_PLACE, Map.of("building", 5L)).setVeinConsume(1);
            }
            this.get("tconstruct:" + first + "_slime_tall_grass").addXpValues(EventType.BLOCK_BREAK, Map.of("excavation", 50L)).addXpValues(EventType.BLOCK_PLACE, Map.of("building", 5L)).setVeinConsume(1);
        }
        this.get("tconstruct:cobalt_ore").addXpValues(EventType.BLOCK_BREAK, Map.of("mining", 250L));
        for (String id : List.of("tconstruct:bloodshroom_button", "tconstruct:bloodshroom_door", "tconstruct:bloodshroom_fence", "tconstruct:bloodshroom_fence_gate", "tconstruct:bloodshroom_planks", "tconstruct:bloodshroom_pressure_plate", "tconstruct:bloodshroom_sign", "tconstruct:bloodshroom_planks_slab", "tconstruct:bloodshroom_planks_stairs", "tconstruct:bloodshroom_trapdoor", "tconstruct:bloodshroom_wall_sign", "tconstruct:bloodshroom_wood", "tconstruct:bloodshroom_sapling", "tconstruct:greenheart_sapling", "tconstruct:greenheart_button", "tconstruct:greenheart_door", "tconstruct:greenheart_fence", "tconstruct:greenheart_fence_gate", "tconstruct:greenheart_planks", "tconstruct:greenheart_pressure_plate", "tconstruct:greenheart_sign", "tconstruct:greenheart_planks_slab", "tconstruct:greenheart_planks_stairs", "tconstruct:greenheart_trapdoor", "tconstruct:greenheart_wall_sign", "tconstruct:greenheart_wood", "tconstruct:skyroot_button", "tconstruct:skyroot_door", "tconstruct:skyroot_fence", "tconstruct:skyroot_fence_gate", "tconstruct:skyroot_planks", "tconstruct:skyroot_pressure_plate", "tconstruct:skyroot_sign", "tconstruct:skyroot_planks_slab", "tconstruct:skyroot_planks_stairs", "tconstruct:skyroot_trapdoor", "tconstruct:skyroot_wall_sign", "tconstruct:skyroot_wood", "tconstruct:bloodshroom_log", "tconstruct:stripped_bloodshroom_wood", "tconstruct:skyroot_log", "tconstruct:stripped_skyroot_wood", "tconstruct:greenheart_log", "tconstruct:stripped_greenheart_wood")) {
            this.get(id).addXpValues(EventType.BLOCK_BREAK, Map.of("woodcutting", 90L)).addXpValues(EventType.BLOCK_PLACE, Map.of("building", 10L)).addReq(ReqType.BREAK, Map.of("woodcutting", 0L)).addReq(ReqType.PLACE, Map.of("woodcutting", 0L)).setVeinConsume(1);
        }
    }

    private void miningBreak(Block block, long xp, TagKey<?> ... tags) {
        this.breakBlock(block, xp, "mining", tags);
    }

    private void excavationBreak(Block block, long xp, TagKey<?> ... tags) {
        this.breakBlock(block, xp, "excavation", tags);
    }

    private void farmingXp(long mine, long grow, Block ... blocks) {
        this.doFor(builder -> builder.addXpValues(EventType.BLOCK_BREAK, Map.of("farming", mine)).addXpValues(EventType.GROW, Map.of("farming", grow)), blocks);
    }

    private void breakBlock(Block block, long xp, String skill, TagKey<?> ... tags) {
        this.get(block).addXpValues(EventType.BLOCK_BREAK, Map.of(skill, xp)).addTag(tags).addReq(ReqType.BREAK, Map.of(skill, 0L));
    }

    private ObjectData.Builder get(String id) {
        return this.data.computeIfAbsent(Reference.of(id), i -> ObjectData.build());
    }

    private ObjectData.Builder get(Block block) {
        return this.data.computeIfAbsent(RegistryUtil.getId(block), i -> ObjectData.build());
    }

    private ObjectData.Builder tagGet(TagKey<Block> tag) {
        return this.data.computeIfAbsent(tag.location(), i -> ObjectData.build()).addTag(tag);
    }

    private void doFor(Consumer<ObjectData.Builder> builder, Block ... blocks) {
        for (Block block : blocks) {
            builder.accept(this.get(block));
        }
    }

    public String getName() {
        return "Project MMO Default Block Generator";
    }
}

