/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.setup.datagen.defaultpacks;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.config.codecs.ObjectData;
import harmonised.pmmo.core.nbt.BehaviorToPrevious;
import harmonised.pmmo.core.nbt.LogicEntry;
import harmonised.pmmo.core.nbt.Operator;
import harmonised.pmmo.setup.datagen.PmmoDataProvider;
import harmonised.pmmo.util.QuadFunction;
import harmonised.pmmo.util.Reference;
import harmonised.pmmo.util.RegistryUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public class DefaultItemConfigProvider
extends PmmoDataProvider<ObjectData> {
    Map<ResourceLocation, ObjectData.Builder> data = new HashMap<ResourceLocation, ObjectData.Builder>();

    public DefaultItemConfigProvider(PackOutput gen) {
        super(gen, "default", "pmmo/items", ObjectData.CODEC.codec());
    }

    @Override
    protected void start() {
        this.populateData();
        this.data.forEach((id, builder) -> this.add((ResourceLocation)id, builder.end()));
    }

    private void populateData() {
        this.get(Items.ANCIENT_DEBRIS).addTag("#c:ores/netherite_scrap").addXpValues(EventType.SMELT, Map.of("smithing", 2500L));
        this.get(Items.RAW_COPPER).addTag("#c:raw_materials/copper", "#c:/ores/copper").addXpValues(EventType.SMELT, Map.of("smithing", 33L));
        this.get(Items.RAW_IRON).addTag("#c:raw_materials/iron", "#c:ores/iron").addXpValues(EventType.SMELT, Map.of("smithing", 100L));
        this.get(Items.RAW_GOLD).addTag("#c:raw_materials/gold", "#c:ores/gold").addXpValues(EventType.SMELT, Map.of("smithing", 200L));
        this.get(Items.DIAMOND_ORE).addTag("#c:ores/diamond").addXpValues(EventType.SMELT, Map.of("smithing", 1000L));
        this.get(Items.EMERALD_ORE).addTag("#c:ores/emerald").addXpValues(EventType.SMELT, Map.of("smithing", 500L));
        this.get(Items.LAPIS_ORE).addTag("#c:ores/lapis").addXpValues(EventType.SMELT, Map.of("smithing", 100L));
        this.get(Items.NETHER_QUARTZ_ORE).addTag("#c:ores/quartz").addXpValues(EventType.SMELT, Map.of("smithing", 100L));
        this.get(Items.REDSTONE_ORE).addTag("#c:ores/redstone").addXpValues(EventType.SMELT, Map.of("smithing", 200L));
        this.miningBreak(Blocks.COAL_ORE, 25L, Tags.Blocks.ORES_COAL);
        this.miningBreak(Blocks.DEEPSLATE_COAL_ORE, 50L, new TagKey[0]);
        this.miningBreak(Blocks.COPPER_ORE, 30L, Tags.Blocks.ORES_COPPER);
        this.miningBreak(Blocks.DEEPSLATE_COPPER_ORE, 60L, new TagKey[0]);
        this.miningBreak(Blocks.IRON_ORE, 150L, Tags.Blocks.ORES_IRON);
        this.miningBreak(Blocks.DEEPSLATE_IRON_ORE, 300L, new TagKey[0]);
        this.miningBreak(Blocks.GOLD_ORE, 200L, Tags.Blocks.ORES_GOLD);
        this.miningBreak(Blocks.DEEPSLATE_GOLD_ORE, 400L, new TagKey[0]);
        this.miningBreak(Blocks.NETHER_GOLD_ORE, 400L, new TagKey[0]);
        this.miningBreak(Blocks.REDSTONE_ORE, 150L, Tags.Blocks.ORES_REDSTONE);
        this.miningBreak(Blocks.DEEPSLATE_REDSTONE_ORE, 300L, new TagKey[0]);
        this.miningBreak(Blocks.DIAMOND_ORE, 750L, Tags.Blocks.ORES_DIAMOND);
        this.miningBreak(Blocks.DEEPSLATE_DIAMOND_ORE, 750L, new TagKey[0]);
        this.miningBreak(Blocks.EMERALD_ORE, 400L, Tags.Blocks.ORES_EMERALD);
        this.miningBreak(Blocks.DEEPSLATE_EMERALD_ORE, 10000L, new TagKey[0]);
        this.miningBreak(Blocks.LAPIS_ORE, 50L, Tags.Blocks.ORES_LAPIS);
        this.miningBreak(Blocks.DEEPSLATE_LAPIS_ORE, 100L, new TagKey[0]);
        this.miningBreak(Blocks.NETHER_QUARTZ_ORE, 100L, Tags.Blocks.ORES_QUARTZ);
        this.miningBreak(Blocks.ANCIENT_DEBRIS, 1500L, new TagKey[0]);
        BuiltInRegistries.ITEM.stream().filter(item -> new ItemStack((ItemLike)item).has(DataComponents.FOOD)).map(ItemStack::new).forEach(item -> {
            FoodProperties props = (FoodProperties)item.get(DataComponents.FOOD);
            long xp = (long)props.nutrition() * 5L + (long)(props.saturation() * 50.0f);
            this.get(item.getItem()).addXpValues(EventType.CONSUME, Map.of("endurance", xp));
            this.get(item.getItem()).addXpValues(EventType.CRAFT, Map.of("cooking", xp));
            this.get(item.getItem()).addXpValues(EventType.SMELT, Map.of("cooking", xp));
            this.get(item.getItem()).addXpValues(EventType.FISH, Map.of("fishing", xp * 2L));
        });
        this.get(Items.ENCHANTED_GOLDEN_APPLE).addBonus(ModifierDataType.HELD, Map.of("magic", 2.0));
        this.get(Items.GOLDEN_APPLE).addBonus(ModifierDataType.HELD, Map.of("magic", 1.5));
        this.get(Items.GOLDEN_CARROT).addBonus(ModifierDataType.HELD, Map.of("magic", 1.5));
        BuiltInRegistries.ITEM.stream().filter(item -> new ItemStack((ItemLike)item).isDamageableItem()).map(ItemStack::new).forEach(item -> {
            long xp = (long)(item.getMaxDamage() / 4) * 10L;
            this.get(item.getItem()).addXpValues(EventType.ANVIL_REPAIR, Map.of("smithing", xp));
        });
        LogicEntry logic = new LogicEntry(BehaviorToPrevious.ADD_TO, false, List.of(new LogicEntry.Case(List.of("components{}.minecraft:potion_contents{}.potion"), BuiltInRegistries.POTION.entrySet().stream().map(entry -> this.equalsCriteria("magic", ((Potion)entry.getValue()).getEffects().stream().mapToInt(MobEffectInstance::getDuration).max().orElseGet(() -> 1), ((ResourceKey)entry.getKey()).location())).toList())));
        this.get(Items.POTION).addNBTXp(EventType.CONSUME, List.of(logic));
        logic = new LogicEntry(BehaviorToPrevious.ADD_TO, false, List.of(new LogicEntry.Case(List.of("components{}.minecraft:potion_contents{}.potion"), BuiltInRegistries.POTION.entrySet().stream().map(entry -> this.equalsCriteria("magic", ((Potion)entry.getValue()).getEffects().stream().mapToInt(MobEffectInstance::getDuration).max().orElseGet(() -> 1), ((ResourceKey)entry.getKey()).location())).toList())));
        this.get(Items.POTION).addNBTXp(EventType.BREW, List.of(logic));
        this.get(Items.LINGERING_POTION).addNBTXp(EventType.ACTIVATE_ITEM, List.of(logic));
        this.get(Items.SPLASH_POTION).addNBTXp(EventType.ACTIVATE_ITEM, List.of(logic));
        LogicEntry logicBase = new LogicEntry(BehaviorToPrevious.ADD_TO, false, List.of(new LogicEntry.Case(List.of("components{}.minecraft:damage"), List.of(new LogicEntry.Criteria(Operator.EXISTS, Optional.empty(), Map.of("woodcutting", 1.025, "farming", 1.025, "agility", 1.025, "fishing", 1.025))))));
        LogicEntry logicSub = new LogicEntry(BehaviorToPrevious.SUB_FROM, false, List.of(new LogicEntry.Case(List.of("components{}.minecraft:dyed_color{}.rgb"), List.of(new LogicEntry.Criteria(Operator.EXISTS, Optional.empty(), Map.of("woodcutting", 1.025, "farming", 1.025, "agility", 1.025, "fishing", 1.025))))));
        LogicEntry logicBonus = new LogicEntry(BehaviorToPrevious.REPLACE, false, List.of(new LogicEntry.Case(List.of("components{}.minecraft:dyed_color{}.rgb"), List.of(new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("16701501")), Map.of("woodcutting", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("8439583")), Map.of("agility", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("6192150")), Map.of("farming", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("3949738")), Map.of("fishing", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("1908001")), Map.of("combat", 1.25, "archery", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("11546150")), Map.of("endurance", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("16383998")), Map.of("smithing", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("16351261")), Map.of("crafting", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("13061821")), Map.of("taming", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("3847130")), Map.of("building", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("15961002")), Map.of("cooking", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("4673362")), Map.of("alchemy", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("10329495")), Map.of("mining", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("1481884")), Map.of("swimming", 1.25)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("8991416")), Map.of("excavation", 1.25))))));
        this.get(Items.LEATHER_HELMET).addNBTBonus(ModifierDataType.WORN, List.of(logicBase, logicSub, logicBonus));
        this.get(Items.LEATHER_CHESTPLATE).addNBTBonus(ModifierDataType.WORN, List.of(logicBase, logicSub, logicBonus));
        this.get(Items.LEATHER_LEGGINGS).addNBTBonus(ModifierDataType.WORN, List.of(logicBase, logicSub, logicBonus));
        this.get(Items.LEATHER_BOOTS).addNBTBonus(ModifierDataType.WORN, List.of(logicBase, logicSub, logicBonus));
        this.doFor(List.of(Items.CHAINMAIL_HELMET, Items.CHAINMAIL_CHESTPLATE, Items.CHAINMAIL_LEGGINGS, Items.CHAINMAIL_BOOTS), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 2000L, "smithing", 300L)).addReq(ReqType.WEAR, Map.of("endurance", 30L)).addNegativeEffect(RegistryUtil.getId(MobEffects.SLOWNESS), 1).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 1).addSalvage(this.getId(Items.IRON_INGOT), APIUtils.SalvageBuilder.start().setSalvageMax(4).setMaxChance(0.9).setChancePerLevel(Map.of("smithing", 0.005)).setLevelReq(Map.of("smithing", 5L)).setXpAward(Map.of("smithing", 30L)).build()).setVeinCap(10).setVeinRate(0.01));
        this.doFor(List.of(Items.COPPER_HELMET, Items.COPPER_CHESTPLATE, Items.COPPER_LEGGINGS, Items.COPPER_BOOTS), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 2000L, "smithing", 300L)).addReq(ReqType.WEAR, Map.of("endurance", 5L)).addNegativeEffect(RegistryUtil.getId(MobEffects.SLOWNESS), 1).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 1).addSalvage(this.getId(Items.COPPER_INGOT), APIUtils.SalvageBuilder.start().setSalvageMax(4).setMaxChance(0.9).setChancePerLevel(Map.of("smithing", 0.005)).setXpAward(Map.of("smithing", 30L)).build()).setVeinCap(10).setVeinRate(0.01));
        this.doFor(List.of(Items.DIAMOND_HELMET, Items.DIAMOND_CHESTPLATE, Items.DIAMOND_LEGGINGS, Items.DIAMOND_BOOTS), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 4000L, "smithing", 700L)).addXpValues(EventType.ENCHANT, Map.of("magic", 80L)).addReq(ReqType.WEAR, Map.of("endurance", 60L)).addNegativeEffect(RegistryUtil.getId(MobEffects.SLOWNESS), 2).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 2).addSalvage(this.getId(Items.DIAMOND), APIUtils.SalvageBuilder.start().setSalvageMax(4).setMaxChance(0.9).setChancePerLevel(Map.of("smithing", 0.005)).setLevelReq(Map.of("smithing", 5L)).setXpAward(Map.of("smithing", 30L)).build()).setVeinCap(5).setVeinRate(0.1));
        this.doFor(List.of(Items.GOLDEN_HELMET, Items.GOLDEN_CHESTPLATE, Items.GOLDEN_LEGGINGS, Items.GOLDEN_BOOTS), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 2000L, "smithing", 300L)).addXpValues(EventType.ENCHANT, Map.of("magic", 60L)).addReq(ReqType.WEAR, Map.of("endurance", 10L)).addBonus(ModifierDataType.WORN, Map.of("mining", 1.25)).addNegativeEffect(RegistryUtil.getId(MobEffects.SLOWNESS), 1).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 1).addSalvage(this.getId(Items.GOLD_INGOT), APIUtils.SalvageBuilder.start().setSalvageMax(4).setMaxChance(0.9).setChancePerLevel(Map.of("smithing", 0.005)).setLevelReq(Map.of("smithing", 5L)).setXpAward(Map.of("smithing", 30L)).build()).setVeinCap(15).setVeinRate(0.01));
        this.doFor(List.of(Items.IRON_HELMET, Items.IRON_CHESTPLATE, Items.IRON_LEGGINGS, Items.IRON_BOOTS), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 2000L, "smithing", 300L)).addXpValues(EventType.ENCHANT, Map.of("magic", 60L)).addReq(ReqType.WEAR, Map.of("endurance", 30L)).addNegativeEffect(RegistryUtil.getId(MobEffects.SLOWNESS), 1).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 1).addSalvage(this.getId(Items.IRON_INGOT), APIUtils.SalvageBuilder.start().setSalvageMax(4).setMaxChance(0.9).setChancePerLevel(Map.of("smithing", 0.005)).setLevelReq(Map.of("smithing", 5L)).setXpAward(Map.of("smithing", 30L)).build()).setVeinCap(10).setVeinRate(0.01));
        this.doFor(List.of(Items.NETHERITE_HELMET, Items.NETHERITE_CHESTPLATE, Items.NETHERITE_LEGGINGS, Items.NETHERITE_BOOTS), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 6000L, "smithing", 1000L)).addXpValues(EventType.ENCHANT, Map.of("magic", 120L)).addReq(ReqType.WEAR, Map.of("endurance", 90L)).addNegativeEffect(RegistryUtil.getId(MobEffects.SLOWNESS), 3).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 3).addSalvage(this.getId(Items.DIAMOND), APIUtils.SalvageBuilder.start().setSalvageMax(4).setMaxChance(0.9).setChancePerLevel(Map.of("smithing", 0.005)).setLevelReq(Map.of("smithing", 5L)).setXpAward(Map.of("smithing", 30L)).build()).addSalvage(this.getId(Items.NETHERITE_INGOT), APIUtils.SalvageBuilder.start().setSalvageMax(1).setMaxChance(0.3).setChancePerLevel(Map.of("smithing", 5.0E-4)).setLevelReq(Map.of("smithing", 50L)).setXpAward(Map.of("smithing", 3000L)).build()).setVeinCap(30).setVeinRate(0.5));
        this.doFor(List.of(Items.WOODEN_AXE, Items.WOODEN_PICKAXE, Items.WOODEN_HOE, Items.WOODEN_SHOVEL, Items.WOODEN_SWORD), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 4000L, "smithing", 700L)).addXpValues(EventType.ENCHANT, Map.of("magic", 120L)).addReq(ReqType.WEAPON, Map.of("combat", 0L)).addReq(ReqType.WEAR, Map.of("combat", 0L, "mining", 0L, "woodcutting", 0L, "farming", 0L, "excavation", 0L)).addReq(ReqType.TOOL, Map.of("mining", 0L, "woodcutting", 0L, "farming", 0L, "excavation", 0L)).setVeinCap(30).setVeinRate(0.1));
        this.doFor(List.of(Items.STONE_AXE, Items.STONE_PICKAXE, Items.STONE_HOE, Items.STONE_SHOVEL, Items.STONE_SWORD), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 1500L, "smithing", 200L)).addXpValues(EventType.ENCHANT, Map.of("magic", 30L)).addNegativeEffect(RegistryUtil.getId(MobEffects.MINING_FATIGUE), 2).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 2).setVeinCap(10).setVeinRate(0.01));
        this.toolReq(Items.STONE_AXE, 10L, 10L, "woodcutting").addBonus(ModifierDataType.HELD, Map.of("woodcutting", 1.05));
        this.toolReq(Items.STONE_PICKAXE, 10L, 5L, "mining").addBonus(ModifierDataType.HELD, Map.of("mining", 1.05));
        this.toolReq(Items.STONE_HOE, 10L, 5L, "farming").addBonus(ModifierDataType.HELD, Map.of("farming", 1.05));
        this.toolReq(Items.STONE_SHOVEL, 10L, 5L, "excavation").addBonus(ModifierDataType.HELD, Map.of("excavation", 1.05));
        this.toolReq(Items.STONE_SWORD, 10L, 10L, "combat").addBonus(ModifierDataType.HELD, Map.of("combat", 1.05));
        this.doFor(List.of(Items.COPPER_AXE, Items.COPPER_PICKAXE, Items.COPPER_HOE, Items.COPPER_SHOVEL, Items.COPPER_SWORD), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 2000L, "smithing", 250L)).addXpValues(EventType.ENCHANT, Map.of("magic", 30L)).addNegativeEffect(RegistryUtil.getId(MobEffects.MINING_FATIGUE), 2).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 2).setVeinCap(5).setVeinRate(0.05));
        this.doFor(List.of(Items.DIAMOND_AXE, Items.DIAMOND_PICKAXE, Items.DIAMOND_HOE, Items.DIAMOND_SHOVEL, Items.DIAMOND_SWORD), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 4000L, "smithing", 700L)).addXpValues(EventType.ENCHANT, Map.of("magic", 120L)).addNegativeEffect(RegistryUtil.getId(MobEffects.MINING_FATIGUE), 2).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 2).setVeinCap(30).setVeinRate(0.1));
        this.toolReq(Items.DIAMOND_AXE, 60L, 60L, "woodcutting");
        this.toolReq(Items.DIAMOND_PICKAXE, 60L, 30L, "mining");
        this.toolReq(Items.DIAMOND_HOE, 60L, 30L, "farming");
        this.toolReq(Items.DIAMOND_SHOVEL, 60L, 30L, "excavation");
        this.toolReq(Items.DIAMOND_SWORD, 60L, 60L, "combat");
        this.doFor(List.of(Items.IRON_AXE, Items.IRON_PICKAXE, Items.IRON_HOE, Items.IRON_SHOVEL, Items.IRON_SWORD), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 2000L, "smithing", 300L)).addXpValues(EventType.ENCHANT, Map.of("magic", 60L)).addNegativeEffect(RegistryUtil.getId(MobEffects.MINING_FATIGUE), 2).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 2).setVeinCap(30).setVeinRate(0.01));
        this.toolReq(Items.IRON_AXE, 30L, 30L, "woodcutting");
        this.toolReq(Items.IRON_PICKAXE, 30L, 15L, "mining");
        this.toolReq(Items.IRON_HOE, 30L, 15L, "farming");
        this.toolReq(Items.IRON_SHOVEL, 30L, 15L, "excavation");
        this.toolReq(Items.IRON_SWORD, 30L, 30L, "combat");
        this.doFor(List.of(Items.GOLDEN_AXE, Items.GOLDEN_PICKAXE, Items.GOLDEN_HOE, Items.GOLDEN_SHOVEL, Items.GOLDEN_SWORD), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 1500L, "smithing", 200L)).addXpValues(EventType.ENCHANT, Map.of("magic", 30L)).addNegativeEffect(RegistryUtil.getId(MobEffects.MINING_FATIGUE), 2).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 2).setVeinCap(30).setVeinRate(0.1));
        this.toolReq(Items.GOLDEN_AXE, 10L, 10L, "woodcutting").addBonus(ModifierDataType.HELD, Map.of("woodcutting", 1.5));
        this.toolReq(Items.GOLDEN_PICKAXE, 10L, 5L, "mining").addBonus(ModifierDataType.HELD, Map.of("mining", 1.5));
        this.toolReq(Items.GOLDEN_HOE, 10L, 5L, "farming").addBonus(ModifierDataType.HELD, Map.of("farming", 1.5));
        this.toolReq(Items.GOLDEN_SHOVEL, 10L, 5L, "excavation").addBonus(ModifierDataType.HELD, Map.of("excavation", 1.5));
        this.toolReq(Items.GOLDEN_SWORD, 10L, 10L, "combat").addBonus(ModifierDataType.HELD, Map.of("combat", 1.5));
        this.doFor(List.of(Items.NETHERITE_AXE, Items.NETHERITE_PICKAXE, Items.NETHERITE_HOE, Items.NETHERITE_SHOVEL, Items.NETHERITE_SWORD), builder -> builder.addXpValues(EventType.CRAFT, Map.of("crafting", 6000L, "smithing", 1000L)).addXpValues(EventType.ENCHANT, Map.of("magic", 250L)).addNegativeEffect(RegistryUtil.getId(MobEffects.MINING_FATIGUE), 2).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 2).setVeinCap(45).setVeinRate(0.01));
        this.toolReq(Items.NETHERITE_AXE, 90L, 90L, "woodcutting");
        this.toolReq(Items.NETHERITE_PICKAXE, 90L, 45L, "mining");
        this.toolReq(Items.NETHERITE_HOE, 90L, 45L, "farming");
        this.toolReq(Items.NETHERITE_SHOVEL, 90L, 45L, "excavation");
        this.toolReq(Items.NETHERITE_SWORD, 90L, 90L, "combat");
        this.get(Items.HEART_OF_THE_SEA).addBonus(ModifierDataType.HELD, Map.of("swimming", 1.25, "fishing", 1.1));
        this.doFor(List.of(Items.WOODEN_PICKAXE, Items.WOODEN_SHOVEL, Items.WOODEN_AXE, Items.WOODEN_HOE, Items.STONE_PICKAXE, Items.STONE_SHOVEL, Items.STONE_AXE, Items.STONE_HOE, Items.COPPER_PICKAXE, Items.COPPER_SHOVEL, Items.COPPER_AXE, Items.COPPER_HOE, Items.GOLDEN_PICKAXE, Items.GOLDEN_SHOVEL, Items.GOLDEN_AXE, Items.GOLDEN_HOE, Items.IRON_PICKAXE, Items.IRON_SHOVEL, Items.IRON_AXE, Items.IRON_HOE, Items.DIAMOND_PICKAXE, Items.DIAMOND_SHOVEL, Items.DIAMOND_AXE, Items.DIAMOND_HOE, Items.NETHERITE_PICKAXE, Items.NETHERITE_SHOVEL, Items.NETHERITE_AXE, Items.NETHERITE_HOE), builder -> builder.addSalvage(this.getId(Items.STICK), APIUtils.SalvageBuilder.start().setBaseChance(0.8).setChancePerLevel(Map.of("crafting", 0.005, "smithing", 0.005)).setSalvageMax(2).setXpAward(Map.of("crafting", 10L, "smithing", 100L)).build()));
        List.of(Items.WOODEN_SWORD, Items.STONE_SWORD, Items.GOLDEN_SWORD, Items.IRON_SWORD, Items.DIAMOND_SWORD, Items.NETHERITE_SWORD).forEach(tool -> this.recoverTool((Item)tool, Items.STICK, 1, 10L, 0.005));
        this.recoverTool(Items.WOODEN_PICKAXE, Items.OAK_PLANKS, 3, 10L, 0.005);
        this.recoverTool(Items.WOODEN_AXE, Items.OAK_PLANKS, 3, 10L, 0.005);
        this.recoverTool(Items.WOODEN_HOE, Items.OAK_PLANKS, 2, 10L, 0.005);
        this.recoverTool(Items.WOODEN_SHOVEL, Items.OAK_PLANKS, 1, 10L, 0.005);
        this.recoverTool(Items.STONE_PICKAXE, Items.COBBLESTONE, 3, 15L, 0.005);
        this.recoverTool(Items.STONE_AXE, Items.COBBLESTONE, 3, 15L, 0.005);
        this.recoverTool(Items.STONE_HOE, Items.COBBLESTONE, 2, 15L, 0.005);
        this.recoverTool(Items.STONE_SHOVEL, Items.COBBLESTONE, 1, 15L, 0.005);
        this.recoverTool(Items.COPPER_PICKAXE, Items.COPPER_INGOT, 3, 20L, 0.005);
        this.recoverTool(Items.COPPER_AXE, Items.COPPER_INGOT, 3, 2L, 0.005);
        this.recoverTool(Items.COPPER_HOE, Items.COPPER_INGOT, 2, 20L, 0.005);
        this.recoverTool(Items.COPPER_SHOVEL, Items.COPPER_INGOT, 1, 20L, 0.005);
        this.recoverTool(Items.GOLDEN_PICKAXE, Items.GOLD_INGOT, 3, 50L, 0.005);
        this.recoverTool(Items.GOLDEN_AXE, Items.GOLD_INGOT, 3, 50L, 0.005);
        this.recoverTool(Items.GOLDEN_HOE, Items.GOLD_INGOT, 2, 50L, 0.005);
        this.recoverTool(Items.GOLDEN_SHOVEL, Items.GOLD_INGOT, 1, 50L, 0.005);
        this.recoverTool(Items.IRON_PICKAXE, Items.IRON_INGOT, 3, 150L, 0.0025);
        this.recoverTool(Items.IRON_AXE, Items.IRON_INGOT, 3, 150L, 0.0025);
        this.recoverTool(Items.IRON_HOE, Items.IRON_INGOT, 2, 150L, 0.0025);
        this.recoverTool(Items.IRON_SHOVEL, Items.IRON_INGOT, 1, 150L, 0.0025);
        this.recoverTool(Items.DIAMOND_PICKAXE, Items.DIAMOND, 3, 500L, 0.00125);
        this.recoverTool(Items.DIAMOND_AXE, Items.DIAMOND, 3, 500L, 0.00125);
        this.recoverTool(Items.DIAMOND_HOE, Items.DIAMOND, 2, 500L, 0.00125);
        this.recoverTool(Items.DIAMOND_SHOVEL, Items.DIAMOND, 1, 500L, 0.00125);
        this.recoverTool(Items.NETHERITE_PICKAXE, Items.NETHERITE_INGOT, 3, 1000L, 0.00125);
        this.recoverTool(Items.NETHERITE_AXE, Items.NETHERITE_INGOT, 3, 1000L, 0.00125);
        this.recoverTool(Items.NETHERITE_HOE, Items.NETHERITE_INGOT, 2, 1000L, 0.00125);
        this.recoverTool(Items.NETHERITE_SHOVEL, Items.NETHERITE_INGOT, 1, 1000L, 0.00125);
        this.get("constructionwand:core_angel").setOverride(true).addXpValues(EventType.CRAFT, Map.of("crafting", 2000L, "smithing", 300L)).addSalvage(this.getId(Items.GOLD_INGOT), APIUtils.SalvageBuilder.start().setSalvageMax(2).setMaxChance(0.9).setChancePerLevel(Map.of("smithing", 0.005)).setLevelReq(Map.of("smithing", 5L)).setXpAward(Map.of("smithing", 30L)).build());
        this.get("constructionwand:core_destruction").setOverride(true).addXpValues(EventType.CRAFT, Map.of("crafting", 10000L, "smithing", 7000L)).addSalvage(this.getId(Items.DIAMOND), APIUtils.SalvageBuilder.start().setSalvageMax(6).setMaxChance(0.9).setChancePerLevel(Map.of("smithing", 0.005)).setLevelReq(Map.of("smithing", 5L)).setXpAward(Map.of("smithing", 30L)).build()).addSalvage(this.getId(Items.DIAMOND_BLOCK), APIUtils.SalvageBuilder.start().setMaxChance(0.9).setChancePerLevel(Map.of("smithing", 0.005)).setLevelReq(Map.of("smithing", 5L)).setXpAward(Map.of("smithing", 180L)).build());
        CodecTypes.SalvageData stick = APIUtils.SalvageBuilder.start().setSalvageMax(2).setBaseChance(0.15).setChancePerLevel(Map.of("smithing", 0.05)).setXpAward(Map.of("smithing", 10L)).build();
        this.get("constructionwand:iron_wand").setOverride(true).addXpValues(EventType.ANVIL_REPAIR, Map.of("smithing", 1500L)).addXpValues(EventType.CRAFT, Map.of("crafting", 2000L, "smithing", 300L)).addXpValues(EventType.ACTIVATE_ITEM, Map.of("building", 200L)).addXpValues(EventType.ENCHANT, Map.of("magic", 60L)).addReq(ReqType.INTERACT, Map.of("building", 30L)).addReq(ReqType.USE, Map.of("building", 30L)).addBonus(ModifierDataType.HELD, Map.of("bulding", 1.1)).addSalvage(this.getId(Items.IRON_INGOT), APIUtils.SalvageBuilder.start().setMaxChance(0.9).setLevelReq(Map.of("smithing", 5L)).setChancePerLevel(Map.of("smithing", 0.005)).setXpAward(Map.of("smithing", 30L)).build()).addSalvage(this.getId(Items.STICK), stick);
        this.get("constructionwand:diamond_wand").setOverride(true).addXpValues(EventType.ANVIL_REPAIR, Map.of("smithing", 4000L)).addXpValues(EventType.CRAFT, Map.of("crafting", 4000L, "smithing", 700L)).addXpValues(EventType.ACTIVATE_ITEM, Map.of("building", 500L)).addXpValues(EventType.ENCHANT, Map.of("magic", 120L)).addReq(ReqType.INTERACT, Map.of("building", 60L)).addReq(ReqType.USE, Map.of("building", 60L)).addBonus(ModifierDataType.HELD, Map.of("bulding", 1.5)).addSalvage(this.getId(Items.DIAMOND), APIUtils.SalvageBuilder.start().setMaxChance(0.9).setLevelReq(Map.of("smithing", 5L)).setChancePerLevel(Map.of("smithing", 0.005)).setXpAward(Map.of("smithing", 30L)).build()).addSalvage(this.getId(Items.STICK), stick);
        this.get("constructionwand:infinity_wand").setOverride(true).addXpValues(EventType.ANVIL_REPAIR, Map.of("smithing", 7000L)).addXpValues(EventType.CRAFT, Map.of("crafting", 7000L, "smithing", 1000L)).addXpValues(EventType.ACTIVATE_ITEM, Map.of("building", 1000L)).addXpValues(EventType.ENCHANT, Map.of("magic", 180L)).addReq(ReqType.INTERACT, Map.of("building", 90L)).addReq(ReqType.USE, Map.of("building", 90L)).addBonus(ModifierDataType.HELD, Map.of("bulding", 2.0)).addSalvage(this.getId(Items.NETHER_STAR), APIUtils.SalvageBuilder.start().setMaxChance(0.9).setLevelReq(Map.of("smithing", 10L)).setChancePerLevel(Map.of("smithing", 0.002)).setXpAward(Map.of("smithing", 30L)).build()).addSalvage(this.getId(Items.STICK), stick);
        this.doForRaw(List.of("goblinsanddungeons:ring_of_experience", "goblinsanddungeons:ring_of_glory", "goblinsanddungeons:ring_of_health", "goblinsanddungeons:ring_of_stealth"), builder -> builder.addXpValues(EventType.CRAFT, Map.of("magic", 1000L, "crafting", 1000L)).addXpValues(EventType.FISH, Map.of("fishing", 1500L)).addXpValues(EventType.ANVIL_REPAIR, Map.of("smithing", 30L)).addXpValues(EventType.ENCHANT, Map.of("magic", 1000L)).addReq(ReqType.WEAR, Map.of("crafting", 30L)).addReq(ReqType.USE, Map.of("magic", 15L)).addNegativeEffect(RegistryUtil.getId(MobEffects.SLOWNESS), 3).addNegativeEffect(RegistryUtil.getId(MobEffects.WEAKNESS), 3));
        Function<List, List> tinkerReqs = str -> {
            Function<Double, Map> getMap = d -> str.stream().collect(Collectors.toMap(s -> s, s -> d));
            return List.of(new LogicEntry(BehaviorToPrevious.ADD_TO, false, List.of(new LogicEntry.Case(List.of("tic_materials[]"), List.of(new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("tconstruct:necrotic_bone", "tconstruct:bone", "tconstruct:flint", "tconstruct:stone", "tconstruct:wood", "tconstruct:rock")), getMap.apply(5.0)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("tconstruct:iron", "tconstruct:plated_slimewood", "tconstruct:seared_stone", "tconstruct:scorched_stone", "tconstruct:copper", "tconstruct:slimewood", "tconstruct:lead", "tconstruct:silver", "tconstruct:electrum", "tconstruct:chorus", "tconstruct:bloodbone")), getMap.apply(10.0)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("twilightforest:steeleaf", "twilightforest:knightmetal", "twilightforest:fiery", "tconstruct:slimesteel", "tconstruct:whitestone", "tconstruct:amethyst_bronze", "tconstruct:steel", "tconstruct:bronze", "tconstruct:tinkers_bronze", "tconstruct:nahuatl", "tconstruct:pig_iron", "tconstruct:rose_gold", "tconstruct:constantan", "tconstruct:cobalt", "tconstruct:necronium")), getMap.apply(20.0)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("tconstruct:queens_slime", "tconstruct:blazing_bone", "tconstruct:bloodbone", "tconstruct:hepatizon", "tconstruct:manyullyn")), getMap.apply(30.0)))))));
        };
        Function<List, List> tinkerArmorReqs = str -> {
            Function<Double, Map> getMap = d -> str.stream().collect(Collectors.toMap(s -> s, s -> d));
            return List.of(new LogicEntry(BehaviorToPrevious.ADD_TO, false, List.of(new LogicEntry.Case(List.of("tic_materials[]"), List.of(new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("tconstruct:necrotic_bone", "tconstruct:bone", "tconstruct:flint", "tconstruct:stone", "tconstruct:wood", "tconstruct:rock")), getMap.apply(5.0)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("tconstruct:iron", "tconstruct:plated_slimewood", "tconstruct:seared_stone", "tconstruct:scorched_stone", "tconstruct:copper", "tconstruct:slimewood", "tconstruct:lead", "tconstruct:silver", "tconstruct:electrum", "tconstruct:chorus", "tconstruct:bloodbone")), getMap.apply(20.0)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("twilightforest:steeleaf", "twilightforest:knightmetal", "twilightforest:fiery", "tconstruct:slimesteel", "tconstruct:whitestone", "tconstruct:amethyst_bronze", "tconstruct:steel", "tconstruct:bronze", "tconstruct:tinkers_bronze", "tconstruct:nahuatl", "tconstruct:pig_iron", "tconstruct:rose_gold", "tconstruct:constantan", "tconstruct:cobalt", "tconstruct:necronium")), getMap.apply(40.0)), new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of("tconstruct:queens_slime", "tconstruct:blazing_bone", "tconstruct:bloodbone", "tconstruct:hepatizon", "tconstruct:manyullyn")), getMap.apply(60.0)))))));
        };
        this.doForRaw(List.of("tconstruct:broad_axe", "tconstruct:hand_axe"), builder -> builder.addNBTReq(ReqType.TOOL, (List)tinkerReqs.apply(List.of("woodcutting"))).addNBTReq(ReqType.WEAPON, (List)tinkerReqs.apply(List.of("combat"))));
        this.doForRaw(List.of("tconstruct:cleaver", "tconstruct:dagger", "tconstruct:kama", "tconstruct:scythe", "tconstruct:sword"), builder -> builder.addNBTReq(ReqType.TOOL, (List)tinkerReqs.apply(List.of("combat"))).addNBTReq(ReqType.WEAPON, (List)tinkerReqs.apply(List.of("combat"))));
        this.doForRaw(List.of("tconstruct:excavator"), builder -> builder.addNBTReq(ReqType.TOOL, (List)tinkerReqs.apply(List.of("excavation"))).addNBTReq(ReqType.WEAPON, (List)tinkerReqs.apply(List.of("combat"))));
        this.doForRaw(List.of("tconstruct:mattock"), builder -> builder.addNBTReq(ReqType.TOOL, (List)tinkerReqs.apply(List.of("excavation", "woodcutting", "farming"))).addNBTReq(ReqType.WEAPON, (List)tinkerReqs.apply(List.of("combat"))));
        this.doForRaw(List.of("tconstruct:pickadze", "tconstruct:pickaxe", "tconstruct:sledge_hammer", "tconstruct:vein_hammer"), builder -> builder.addNBTReq(ReqType.TOOL, (List)tinkerReqs.apply(List.of("mining"))).addNBTReq(ReqType.WEAPON, (List)tinkerReqs.apply(List.of("combat"))));
        this.doForRaw(List.of("tconstruct:battlesign"), builder -> builder.addNBTReq(ReqType.WEAPON, (List)tinkerReqs.apply(List.of("combat"))));
        this.doForRaw(List.of("tconstruct:plate_boots", "tconstruct:plate_chestplate", "tconstruct:plate_helmet", "tconstruct:plate_leggings"), builder -> builder.addNBTReq(ReqType.WEAR, (List)tinkerArmorReqs.apply(List.of("endurance"))));
        this.get("irons_spellbooks:tarnished_helmet").addReq(ReqType.WEAR, Map.of("magic", 10L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.1));
        this.doForRaw(List.of("irons_spellbooks:wandering_magician_boots", "irons_spellbooks:wandering_magician_leggings", "irons_spellbooks:wandering_magician_helmet", "irons_spellbooks:wandering_magician_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 5L, "endurance", 30L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.1)));
        this.doForRaw(List.of("irons_spellbooks:shadowwalker_boots", "irons_spellbooks:shadowwalker_leggings", "irons_spellbooks:shadowwalker_helmet", "irons_spellbooks:shadowwalker_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 60L, "endurance", 60L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.5)));
        this.doForRaw(List.of("irons_spellbooks:pyromancer_boots", "irons_spellbooks:pyromancer_leggings", "irons_spellbooks:pyromancer_helmet", "irons_spellbooks:pyromancer_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 60L, "endurance", 60L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.5)));
        this.doForRaw(List.of("irons_spellbooks:priest_boots", "irons_spellbooks:priest_leggings", "irons_spellbooks:priest_helmet", "irons_spellbooks:priest_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 60L, "endurance", 60L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.5)));
        this.doForRaw(List.of("irons_spellbooks:plagued_boots", "irons_spellbooks:plagued_leggings", "irons_spellbooks:plagued_helmet", "irons_spellbooks:plagued_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 60L, "endurance", 60L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.5)));
        this.doForRaw(List.of("irons_spellbooks:electromancer_boots", "irons_spellbooks:electromancer_leggings", "irons_spellbooks:electromancer_helmet", "irons_spellbooks:electromancer_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 60L, "endurance", 60L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.5)));
        this.doForRaw(List.of("irons_spellbooks:cultist_boots", "irons_spellbooks:cultist_leggings", "irons_spellbooks:cultist_helmet", "irons_spellbooks:cultist_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 60L, "endurance", 60L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.5)));
        this.doForRaw(List.of("irons_spellbooks:cryomancer_boots", "irons_spellbooks:cryomancer_leggings", "irons_spellbooks:cryomancer_helmet", "irons_spellbooks:cryomancer_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 60L, "endurance", 60L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.5)));
        this.doForRaw(List.of("irons_spellbooks:archevoker_boots", "irons_spellbooks:archevoker_leggings", "irons_spellbooks:archevoker_helmet", "irons_spellbooks:archevoker_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 60L, "endurance", 60L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.5)));
        this.doForRaw(List.of("irons_spellbooks:netherite_mage_boots", "irons_spellbooks:netherite_mage_leggings", "irons_spellbooks:netherite_mage_helmet", "irons_spellbooks:netherite_mage_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 60L, "endurance", 80L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.5)));
        this.doForRaw(List.of("irons_spellbooks:pumpkin_boots", "irons_spellbooks:pumpkin_leggings", "irons_spellbooks:pumpkin_helmet", "irons_spellbooks:pumpkin_chestplate"), builder -> builder.addReq(ReqType.WEAR, Map.of("magic", 10L, "endurance", 60L)).addBonus(ModifierDataType.WORN, Map.of("magic", 1.25)));
        this.doForRaw(List.of("tetra:modular_bow", "tetra:modular_crossbow", "tetra:modular_double", "tetra:modular_shield", "tetra:modular_single", "tetra:modular_sword"), builder -> builder.addXpValues(EventType.ENCHANT, Map.of("magic", 0L)).addXpValues(EventType.CRAFT, Map.of("crafting", 0L)).addXpValues(EventType.FISH, Map.of("fishing", 0L)));
        QuadFunction<String, String, String, Map, LogicEntry> tetraEntry = (item, component, skill, values) -> {
            List<LogicEntry.Criteria> criteria = values.entrySet().stream().map(entry -> new LogicEntry.Criteria(Operator.EQUALS, Optional.of(((List)entry.getValue()).stream().map(str -> component + "/" + str).toList()), Map.of(skill, (Double)entry.getKey()))).toList();
            LogicEntry.Case cases = new LogicEntry.Case(List.of(item + "/" + component + "_material"), criteria);
            return new LogicEntry(BehaviorToPrevious.HIGHEST, false, List.of(cases));
        };
        QuadFunction<String, String, String, Map, LogicEntry> tetraEntryLR = (item, component, skill, values) -> {
            List<LogicEntry.Criteria> criteria = values.entrySet().stream().map(entry -> new LogicEntry.Criteria(Operator.EQUALS, Optional.of(((List)entry.getValue()).stream().map(str -> component + "/" + str).toList()), Map.of(skill, (Double)entry.getKey()))).toList();
            LogicEntry.Case cases = new LogicEntry.Case(List.of(item + "/" + component + "_left_material", item + "/" + component + "_right_material"), criteria);
            return new LogicEntry(BehaviorToPrevious.HIGHEST, false, List.of(cases));
        };
        List<LogicEntry> bowList = List.of(tetraEntry.apply("bow", "basic_string", "archery", Map.of(1.0, List.of("string", "weeping_vine", "vine", "twisting_vine", "leather", "hide"), 2.0, List.of("phantom_membrane", "dragon_sinew"))), tetraEntry.apply("bow", "straight_stave", "archery", Map.of(0.0, List.of("oak", "birch", "acacia", "jungle", "spruce", "dark_oak", "stick"), 15.0, List.of("copper"), 30.0, List.of("iron"), 10.0, List.of("gold"), 90.0, List.of("netherite"))), tetraEntry.apply("bow", "extended_rest", "archery", Map.of(0.0, List.of("bone", "oak", "birch", "acacia", "jungle", "spruce", "dark_oak", "stick"), 7.0, List.of("copper"), 15.0, List.of("iron"), 5.0, List.of("gold"), 45.0, List.of("netherite"))), tetraEntry.apply("bow", "long_stave", "archery", Map.of(0.0, List.of("oak", "birch", "acacia", "jungle", "spruce", "dark_oak", "stick"), 15.0, List.of("copper"), 30.0, List.of("iron"), 10.0, List.of("gold"), 90.0, List.of("netherite"))), tetraEntry.apply("bow", "recurve_stave", "archery", Map.of(0.0, List.of("oak", "birch", "acacia", "jungle", "spruce", "dark_oak", "stick"), 15.0, List.of("copper"), 30.0, List.of("iron"), 10.0, List.of("gold"), 90.0, List.of("netherite"))), tetraEntry.apply("bow", "sights", "archery", Map.of(0.0, List.of("bone", "oak", "birch", "acacia", "jungle", "spruce", "dark_oak"), 7.0, List.of("copper"), 15.0, List.of("iron"), 5.0, List.of("gold"), 45.0, List.of("netherite"))), tetraEntry.apply("bow", "stabilizer", "archery", Map.of(0.0, List.of("bone", "oak", "birch", "acacia", "jungle", "spruce", "dark_oak"), 7.0, List.of("copper"), 15.0, List.of("iron"), 5.0, List.of("gold"), 45.0, List.of("netherite"))));
        this.get("tetra:modular_bow").addNBTReq(ReqType.WEAR, bowList).addNBTReq(ReqType.WEAPON, bowList);
        List<LogicEntry> crossbowList = List.of(tetraEntry.apply("crossbow", "basic_string", "archery", Map.of(1.0, List.of("string", "weeping_vine", "vine", "twisting_vine", "leather", "hide"), 2.0, List.of("phantom_membrane", "dragon_sinew"))), tetraEntry.apply("crossbow", "basic_stave", "archery", Map.of(0.0, List.of("oak", "birch", "acacia", "jungle", "spruce", "dark_oak", "stick"), 15.0, List.of("copper"), 30.0, List.of("iron"), 10.0, List.of("gold"), 90.0, List.of("netherite"))), tetraEntry.apply("crossbow", "basic_stock", "archery", Map.of(0.0, List.of("bone", "oak", "birch", "acacia", "jungle", "spruce", "dark_oak", "stick"), 7.0, List.of("copper"), 15.0, List.of("iron"), 5.0, List.of("gold"), 45.0, List.of("netherite"))), tetraEntry.apply("crossbow", "stirrup", "archery", Map.of(7.0, List.of("copper"), 15.0, List.of("iron"), 5.0, List.of("gold"), 45.0, List.of("netherite"))));
        this.get("tetra:modular_crossbow").addNBTReq(ReqType.WEAR, crossbowList).addNBTReq(ReqType.WEAPON, crossbowList);
        Map<Double, List<String>> criteria = Map.of(0.0, List.of("oak", "birch", "acacia", "jungle", "spruce", "dark_oak"), 10.0, List.of("stone", "flint", "gold"), 15.0, List.of("andesite", "diorite", "granite", "copper"), 30.0, List.of("iron"), 25.0, List.of("blackstone", "obsidian"), 90.0, List.of("netherite"), 40.0, List.of("emerald"), 60.0, List.of("diamond"));
        Function<String, List> pickaxeList = str -> List.of((LogicEntry)tetraEntryLR.apply("double", "basic_pickaxe", (String)str, criteria), (LogicEntry)tetraEntryLR.apply("double", "basic_axe", (String)str, criteria), (LogicEntry)tetraEntryLR.apply("double", "basic_hammer", (String)str, criteria), (LogicEntry)tetraEntryLR.apply("double", "basic_claw", (String)str, criteria), (LogicEntry)tetraEntryLR.apply("double", "basic_adze", (String)str, criteria), (LogicEntry)tetraEntryLR.apply("double", "basic_butt", (String)str, criteria), (LogicEntry)tetraEntryLR.apply("double", "basic_hoe", (String)str, criteria));
        this.doForRaw(List.of("tetra:modular_double", "tetra:modular_single"), builder -> builder.addNBTReq(ReqType.WEAR, (List)pickaxeList.apply("mining")).addNBTReq(ReqType.TOOL, (List)pickaxeList.apply("mining")).addNBTReq(ReqType.WEAPON, (List)pickaxeList.apply("combat")).setVeinCap(30).setVeinRate(0.1));
        this.get("tetra:modular_shield").addNBTReq(ReqType.WEAR, List.of(tetraEntry.apply("shield", "basic_grip", "endurance", Map.of(0.0, List.of("bone", "oak", "birch", "acacia", "jungle", "spruce", "dark_oak", "stick"), 5.0, List.of("gold"), 7.0, List.of("copper"), 15.0, List.of("iron", "blaze_rod", "end_rod"), 45.0, List.of("netherite", "forged_beam"))), tetraEntry.apply("shield", "buckler", "endurance", Map.of(0.0, List.of("bone", "oak", "birch", "acacia", "jungle", "spruce", "dark_oak"), 10.0, List.of("gold"), 15.0, List.of("copper"), 30.0, List.of("iron"), 90.0, List.of("netherite", "vent_plate"))), tetraEntry.apply("shield", "heater", "endurance", Map.of(0.0, List.of("bone", "oak", "birch", "acacia", "jungle", "spruce", "dark_oak"), 10.0, List.of("gold"), 15.0, List.of("copper"), 30.0, List.of("iron"), 90.0, List.of("netherite", "vent_plate"))), tetraEntry.apply("shield", "tower", "endurance", Map.of(0.0, List.of("bone", "oak", "birch", "acacia", "jungle", "spruce", "dark_oak"), 10.0, List.of("gold"), 15.0, List.of("copper"), 30.0, List.of("iron"), 90.0, List.of("netherite", "vent_plate"))), tetraEntry.apply("shield", "spike", "endurance", Map.of(0.0, List.of("bone"), 5.0, List.of("gold"), 7.0, List.of("copper"), 15.0, List.of("iron"), 45.0, List.of("netherite"))), tetraEntry.apply("shield", "straps", "endurance", Map.of(1.0, List.of("string", "weeping_vine", "vine", "twisting_vine", "leather", "hide"), 2.0, List.of("phantom_membrane", "dragon_sinew")))));
        Function<String, List> swordList = str -> List.of((LogicEntry)tetraEntry.apply("sword", "basic_blade", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "basic_hilt", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "binding", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "counterweight", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "decorative_pommel", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "forefinger_ring", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "grip_loop", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "heavy_blade", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "howling", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "machete", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "makeshift_guard", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "reinforced_fuller", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "short_blade", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "sturdy_guard", (String)str, criteria), (LogicEntry)tetraEntry.apply("sword", "wide_guard", (String)str, criteria));
        this.get("tetra:modular_sword").addNBTReq(ReqType.WEAR, swordList.apply("combat")).addNBTReq(ReqType.WEAPON, swordList.apply("combat")).addNBTReq(ReqType.TOOL, swordList.apply("farming"));
    }

    protected void miningBreak(Block block, long amount, TagKey<Block> ... tags) {
        String[] tagStrings = (String[])Arrays.stream(tags).map(key -> "#" + key.location().toString()).toArray(String[]::new);
        this.get(block.asItem()).addXpValues(EventType.BLOCK_BREAK, Map.of("mining", amount)).addTag(tagStrings);
    }

    protected LogicEntry.Criteria equalsCriteria(String skill, double value, ResourceLocation key) {
        return new LogicEntry.Criteria(Operator.EQUALS, Optional.of(List.of(key.toString())), Map.of(skill, value));
    }

    protected ObjectData.Builder get(Item item) {
        return this.data.computeIfAbsent(this.getId(item), i -> ObjectData.build());
    }

    protected ObjectData.Builder get(String id) {
        return this.data.computeIfAbsent(Reference.of(id), i -> ObjectData.build());
    }

    protected void doFor(List<Item> items, Consumer<ObjectData.Builder> process) {
        items.forEach(item -> process.accept(this.get((Item)item)));
    }

    protected void doForRaw(List<String> items, Consumer<ObjectData.Builder> process) {
        items.forEach(item -> process.accept(this.get((String)item)));
    }

    protected void recoverTool(Item tool, Item material, int count, long xp, double skillChance) {
        this.get(tool).addSalvage(this.getId(material), APIUtils.SalvageBuilder.start().setBaseChance(0.8).setChancePerLevel(Map.of("crafting", skillChance, "smithing", skillChance)).setSalvageMax(count).setXpAward(Map.of("crafting", xp, "smithing", xp)).build());
    }

    protected ObjectData.Builder toolReq(Item tool, long asTool, long asWeapon, String skill) {
        return this.get(tool).addReq(ReqType.TOOL, Map.of(skill, asTool)).addReq(ReqType.WEAR, Map.of(skill, asTool)).addReq(ReqType.WEAPON, Map.of("combat", asWeapon));
    }

    public String getName() {
        return "Project MMO Default Item Generator";
    }
}

