/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.storage;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import harmonised.pmmo.config.Config;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.network.codec.StreamCodec;

public class Experience {
    private XpLevel level = new XpLevel();
    private long xp = 0L;
    public static final Codec<Experience> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("level").xmap(XpLevel::new, XpLevel::getLevel).forGetter(Experience::getLevel), (App)Codec.LONG.fieldOf("xp").forGetter(Experience::getXp)).apply((Applicative)instance, Experience::new));
    public static final StreamCodec<ByteBuf, Experience> STREAM_CODEC = new StreamCodec<ByteBuf, Experience>(){

        public Experience decode(ByteBuf buf) {
            return new Experience(new XpLevel(buf.readLong()), buf.readLong());
        }

        public void encode(ByteBuf buf, Experience xp) {
            buf.writeLong(xp.getLevel().getLevel());
            buf.writeLong(xp.getXp());
        }
    };

    public Experience() {
        this(new XpLevel(), 0L);
    }

    public Experience(long xpOnly) {
        this(new XpLevel(), xpOnly);
    }

    public Experience(XpLevel level, long xp) {
        this.level = level;
        this.xp = xp;
    }

    public XpLevel getLevel() {
        return this.level;
    }

    public void setLevel(long level) {
        this.level = new XpLevel(level);
    }

    public void addLevel(long level) {
        this.level.addLevel(level);
    }

    public long getXp() {
        return this.xp;
    }

    public boolean addXp(long xpIn) {
        return this.setXp(this.xp + xpIn);
    }

    public boolean setXp(long xp) {
        this.xp = xp;
        while (xp < 0L) {
            if (this.level.getLevel() <= 0L) {
                this.level.setLevel(0L);
                this.xp = 0L;
                return false;
            }
            this.level.decrement();
            xp += this.level.xpToNext;
        }
        boolean leveledUp = false;
        while (this.xp > this.level.xpToNext) {
            this.xp -= this.level.xpToNext;
            this.level.increment();
            leveledUp = true;
        }
        return leveledUp;
    }

    public Experience merge(Experience other) {
        this.addXp(other.getXp());
        this.getLevel().merge(other.getLevel());
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof Experience) {
            Experience oXp = (Experience)other;
            return this.xp == oXp.xp && this.level.getLevel() == oXp.level.getLevel();
        }
        return false;
    }

    public String toString() {
        return "Experience{level=" + String.valueOf(this.level) + ", xp=" + this.xp + "}";
    }

    public static class XpLevel {
        long level = 0L;
        long xpToNext;
        long xpToGain;

        public XpLevel() {
            this(0L);
        }

        public XpLevel(long level) {
            this.level = level;
            this.xpToNext = XpLevel.getXpForNextLevel(level);
            this.xpToGain = level > 0L ? XpLevel.getXpForNextLevel(level - 1L) : 0L;
        }

        public XpLevel merge(XpLevel other) {
            this.level += other.getLevel();
            return this;
        }

        public long getLevel() {
            return this.level;
        }

        public void setLevel(long level) {
            block3: {
                block2: {
                    if (level <= this.level) break block2;
                    for (long i = 0L; i < level - this.level; ++i) {
                        this.increment();
                    }
                    break block3;
                }
                if (level >= this.level) break block3;
                for (long i = 0L; i < this.level - level; ++i) {
                    this.decrement();
                }
            }
        }

        public long getXpToNext() {
            return this.xpToNext;
        }

        public long getXpToGain() {
            return this.xpToGain;
        }

        public void addLevel(long level) {
            boolean isNegative = level < 0L;
            for (long i = 0L; i < Math.abs(level); ++i) {
                if (isNegative) {
                    this.decrement();
                    continue;
                }
                this.increment();
            }
        }

        public void increment() {
            ++this.level;
            this.xpToGain = this.xpToNext;
            this.xpToNext = XpLevel.getXpForNextLevel(this.level);
        }

        public void decrement() {
            --this.level;
            this.xpToNext = this.xpToGain;
            this.xpToGain = this.level > 0L ? XpLevel.getXpForNextLevel(this.level - 1L) : 0L;
        }

        public static long getXpForNextLevel(long level) {
            List<Long> staticLvls = Config.server().levels().staticLevels();
            if (staticLvls.get(0) != -1L) {
                return (long)staticLvls.size() > level ? staticLvls.get((int)level) : Long.MAX_VALUE;
            }
            long min = Config.server().levels().xpMin();
            double base = Config.server().levels().xpBase();
            double lvl = Config.server().levels().perLevel();
            return min + Double.valueOf(Math.pow(base, lvl * (double)level)).longValue();
        }

        public String toString() {
            return "XpLevel{level=" + this.level + ", xpToNext=" + this.xpToNext + ", xpToGain=" + this.xpToGain + "}";
        }
    }
}

