/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.util;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;

public class TagUtils {
    public static CompoundTag mergeTags(CompoundTag tag1, CompoundTag tag2) {
        CompoundTag output = new CompoundTag();
        ArrayList<String> allKeys = new ArrayList<String>();
        tag1.keySet().forEach(s -> allKeys.add((String)s));
        for (String key : tag2.keySet()) {
            if (allKeys.contains(key) || key == null) continue;
            allKeys.add(key);
        }
        for (String key : allKeys) {
            if (tag1.contains(key) && tag2.contains(key)) {
                Tag tag = tag1.get(key);
                if (tag instanceof NumericTag) {
                    NumericTag numTag = (NumericTag)tag;
                    if (numTag instanceof DoubleTag) {
                        output.putDouble(key, tag1.getDoubleOr(key, 0.0) + tag2.getDoubleOr(key, 0.0));
                        continue;
                    }
                    if (numTag instanceof FloatTag) {
                        output.putFloat(key, tag1.getFloatOr(key, 0.0f) + tag2.getFloatOr(key, 0.0f));
                        continue;
                    }
                    if (numTag instanceof IntTag) {
                        output.putInt(key, tag1.getIntOr(key, 0) + tag2.getIntOr(key, 0));
                        continue;
                    }
                    if (numTag instanceof LongTag) {
                        output.putLong(key, tag1.getLongOr(key, 0L) + tag2.getLongOr(key, 0L));
                        continue;
                    }
                    if (numTag instanceof ShortTag) {
                        output.putShort(key, (short)(tag1.getShortOr(key, (short)0) + tag2.getShortOr(key, (short)0)));
                        continue;
                    }
                    output.put(key, tag1.get(key));
                    continue;
                }
                output.put(key, tag1.get(key));
                continue;
            }
            if (tag1.contains(key) && !tag2.contains(key)) {
                output.put(key, tag1.get(key));
                continue;
            }
            if (tag1.contains(key) || !tag2.contains(key)) continue;
            output.put(key, tag2.get(key));
        }
        return output;
    }

    public static CompoundTag stackTag(ItemStack stack, Level level) {
        if (stack.isEmpty()) {
            return new CompoundTag();
        }
        RegistryOps regOps = level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        if (stack.getCount() > 99) {
            ItemStack clone = stack.copy();
            clone.setCount(99);
            return ItemStack.CODEC.encodeStart((DynamicOps)regOps, (Object)clone).result().orElse(new CompoundTag());
        }
        return ItemStack.CODEC.encodeStart((DynamicOps)regOps, (Object)stack).result().orElse(new CompoundTag());
    }

    public static CompoundTag entityTag(Entity entity) {
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)HolderLookup.Provider.create((Stream)entity.registryAccess().listRegistries()));
        entity.saveWithoutId((ValueOutput)output);
        return output.buildResult();
    }

    public static CompoundTag tileTag(BlockEntity tile) {
        return tile == null ? new CompoundTag() : tile.saveWithFullMetadata((HolderLookup.Provider)tile.getLevel().registryAccess());
    }

    public static CompoundTag stateTag(BlockState state) {
        CompoundTag dataOut = new CompoundTag();
        state.getProperties().forEach(prop -> dataOut.putString(prop.getName(), state.getValue(prop).toString()));
        return dataOut;
    }

    public static float getFloat(CompoundTag nbt, String key, float ifAbsent) {
        return nbt.contains(key) ? ((Float)nbt.getFloat(key).get()).floatValue() : ifAbsent;
    }

    public static BlockPos getBlockPos(CompoundTag nbt, String key, BlockPos ifAbsent) {
        return nbt.contains(key) ? BlockPos.of((long)((Long)nbt.getLong(key).get())) : ifAbsent;
    }
}

