/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.events;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ModifierDataType;
import harmonised.pmmo.api.enums.ObjectType;
import harmonised.pmmo.api.enums.ReqType;
import harmonised.pmmo.client.gui.StatsScreen;
import harmonised.pmmo.client.utils.DP;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.config.codecs.VeinData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.CoreUtils;
import harmonised.pmmo.setup.ClientSetup;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import harmonised.pmmo.util.TagUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="pmmo", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class TooltipHandler {
    public static boolean tooltipOn = true;

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        if (!tooltipOn) {
            return;
        }
        Player player = event.getEntity();
        if (player != null) {
            Core core = Core.get(LogicalSide.CLIENT);
            ItemStack stack = event.getItemStack();
            boolean isBlockItem = stack.m_41720_() instanceof BlockItem;
            ResourceLocation itemID = RegistryUtil.getId(stack);
            if (itemID == null) {
                return;
            }
            if (!ClientSetup.OPEN_MENU.m_90862_() && InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)ClientSetup.OPEN_MENU.getKey().m_84873_())) {
                Minecraft.m_91087_().m_91152_((Screen)new StatsScreen(stack));
                return;
            }
            Arrays.stream(isBlockItem ? ReqType.BLOCKITEM_APPLICABLE_EVENTS : ReqType.ITEM_APPLICABLE_EVENTS).filter(type -> (Boolean)Config.tooltipReqEnabled(type).get()).map(type -> Pair.of((Object)type, TooltipHandler.getReqData(core, type, stack))).filter(pair -> !((Map)pair.getSecond()).isEmpty()).forEach(pair -> TooltipHandler.addRequirementTooltip(((ReqType)pair.getFirst()).tooltipTranslation, event, (Map)pair.getSecond()));
            Arrays.stream(isBlockItem ? EventType.BLOCKITEM_APPLICABLE_EVENTS : EventType.ITEM_APPLICABLE_EVENTS).filter(type -> (Boolean)Config.tooltipXpEnabled(type).get()).map(type -> Pair.of((Object)type, TooltipHandler.getXpData(core, type, player, stack))).filter(pair -> !((Map)pair.getSecond()).isEmpty()).forEach(pair -> TooltipHandler.addXpValueTooltip(((EventType)pair.getFirst()).tooltipTranslation, event, (Map)pair.getSecond()));
            Stream.of(ModifierDataType.HELD, ModifierDataType.WORN).filter(type -> (Boolean)Config.tooltipBonusEnabled(type).get()).map(type -> Pair.of((Object)type, core.getObjectModifierMap(ObjectType.ITEM, itemID, (ModifierDataType)type, TagUtils.stackTag(stack)))).filter(pair -> !((Map)pair.getSecond()).isEmpty()).forEach(pair -> TooltipHandler.addModifierTooltip(((ModifierDataType)pair.getFirst()).tooltip, event, (Map)pair.getSecond()));
            VeinData veinData = core.getLoader().ITEM_LOADER.getData(itemID).veinData();
            if (!veinData.isUnconfigured() && !veinData.isEmpty() && ((Boolean)Config.VEIN_ENABLED.get()).booleanValue()) {
                TooltipHandler.addVeinTooltip(LangProvider.VEIN_TOOLTIP, event, veinData, isBlockItem);
            }
        }
    }

    private static void addRequirementTooltip(LangProvider.Translation header, ItemTooltipEvent event, Map<String, Integer> reqs) {
        MutableComponent headerComp = header.asComponent().m_130940_(ChatFormatting.RED);
        if (reqs.entrySet().size() == 1) {
            Map.Entry<String, Integer> req = reqs.entrySet().iterator().next();
            MutableComponent singleComponent = Component.m_237115_((String)("pmmo." + req.getKey())).m_7220_((Component)Component.m_237113_((String)(" " + String.valueOf(req.getValue())))).m_6270_(CoreUtils.getSkillStyle(req.getKey()));
            event.getToolTip().add(headerComp.m_130946_(" ").m_7220_((Component)singleComponent));
        } else {
            event.getToolTip().add(headerComp);
            for (Map.Entry<String, Integer> req : reqs.entrySet()) {
                event.getToolTip().add(Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237115_((String)("pmmo." + req.getKey()))).m_7220_((Component)Component.m_237113_((String)(" " + String.valueOf(req.getValue())))).m_6270_(CoreUtils.getSkillStyle(req.getKey())));
            }
        }
    }

    private static void addXpValueTooltip(LangProvider.Translation header, ItemTooltipEvent event, Map<String, Long> values) {
        MutableComponent headerComp = header.asComponent().m_130940_(ChatFormatting.GREEN);
        if (values.entrySet().size() == 1) {
            Map.Entry<String, Long> value2 = values.entrySet().iterator().next();
            MutableComponent xpValue = Component.m_237115_((String)("pmmo." + value2.getKey())).m_7220_((Component)Component.m_237113_((String)(" " + String.valueOf(value2.getValue())))).m_6270_(CoreUtils.getSkillStyle(value2.getKey()));
            event.getToolTip().add(headerComp.m_130946_(" ").m_7220_((Component)xpValue));
        } else {
            event.getToolTip().add(headerComp);
            values.entrySet().stream().filter(entry -> (Long)entry.getValue() > 0L).forEach(value -> event.getToolTip().add(Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237115_((String)("pmmo." + (String)value.getKey()))).m_7220_((Component)Component.m_237113_((String)(" " + String.valueOf(value.getValue())))).m_6270_(CoreUtils.getSkillStyle((String)value.getKey()))));
        }
    }

    private static void addModifierTooltip(LangProvider.Translation header, ItemTooltipEvent event, Map<String, Double> values) {
        MutableComponent headerComp = header.asComponent().m_130940_(ChatFormatting.BLUE);
        if (values.entrySet().size() == 1) {
            Map.Entry<String, Double> modifier2 = values.entrySet().iterator().next();
            MutableComponent bonusComponent = Component.m_237115_((String)("pmmo." + modifier2.getKey())).m_7220_((Component)Component.m_237113_((String)(" " + TooltipHandler.modifierPercent(modifier2.getValue())))).m_6270_(CoreUtils.getSkillStyle(modifier2.getKey()));
            event.getToolTip().add(headerComp.m_130946_(" ").m_7220_((Component)bonusComponent));
        } else {
            event.getToolTip().add(headerComp);
            values.entrySet().stream().filter(entry -> (Double)entry.getValue() != 0.0 && (Double)entry.getValue() != 1.0).forEach(modifier -> event.getToolTip().add(Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237115_((String)("pmmo." + (String)modifier.getKey()))).m_7220_((Component)Component.m_237113_((String)(" " + TooltipHandler.modifierPercent((Double)modifier.getValue())))).m_6270_(CoreUtils.getSkillStyle((String)modifier.getKey()))));
        }
    }

    private static void addVeinTooltip(LangProvider.Translation header, ItemTooltipEvent event, VeinData data, boolean isBlockItem) {
        event.getToolTip().add(header.asComponent());
        event.getToolTip().add(LangProvider.VEIN_DATA.asComponent(data.chargeCap.orElse(0), DP.dp(data.chargeRate.orElse(0.0) * 2.0)));
        if (isBlockItem) {
            event.getToolTip().add(LangProvider.VEIN_BREAK.asComponent(data.consumeAmount.orElse(0)));
        }
    }

    private static String modifierPercent(Double value) {
        return DP.dp((value - 1.0) * 100.0) + "%";
    }

    private static Map<String, Long> getXpData(Core core, EventType type, Player player, ItemStack stack) {
        Map<String, Long> map = core.getExperienceAwards(type, stack, player, new CompoundTag());
        if (stack.m_41720_() instanceof BlockItem) {
            map = core.getCommonXpAwardData(new HashMap<String, Long>(), type, RegistryUtil.getId(stack), player, ObjectType.BLOCK, TagUtils.stackTag(stack));
        }
        CoreUtils.processSkillGroupXP(map);
        return map.entrySet().stream().filter(entry -> (Long)entry.getValue() != 0L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, Integer> getReqData(Core core, ReqType type, ItemStack stack) {
        Map<String, Integer> map;
        if (!((Boolean)Config.reqEnabled(type).get()).booleanValue()) {
            return new HashMap<String, Integer>();
        }
        Map<String, Integer> map2 = map = type == ReqType.USE_ENCHANTMENT ? core.getEnchantReqs(stack) : core.getReqMap(type, stack, true);
        if (stack.m_41720_() instanceof BlockItem) {
            map.putAll(core.getCommonReqData(new HashMap<String, Integer>(), ObjectType.BLOCK, RegistryUtil.getId(stack), type, TagUtils.stackTag(stack)));
        }
        CoreUtils.processSkillGroupReqs(map);
        if (!((Boolean)Config.HIDE_MET_REQS.get()).booleanValue()) {
            return map;
        }
        new HashMap<String, Integer>(map).forEach((skill, level) -> {
            if (SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault()).isSkillGroup()) {
                int total = SkillsConfig.SKILLS.get().get(skill).getGroup().keySet().stream().map(groupskill -> core.getData().getPlayerSkillLevel((String)groupskill, null)).collect(Collectors.summingInt(Integer::intValue));
                if (level <= total || level == 0) {
                    map.remove(skill);
                }
            } else if (core.getData().getPlayerSkillLevel((String)skill, null) >= level) {
                map.remove(skill);
            }
        });
        return map;
    }
}

