/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import harmonised.pmmo.client.utils.ClientUtils;
import harmonised.pmmo.config.Config;
import harmonised.pmmo.config.codecs.CodecTypes;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.RegistryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;

public class TutorialOverlayGUI
implements IGuiOverlay {
    private Minecraft mc;
    private Font fontRenderer;
    private List<ClientTooltipComponent> lines = new ArrayList<ClientTooltipComponent>();
    private BlockHitResult bhr;

    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (this.mc == null) {
            this.mc = Minecraft.m_91087_();
        }
        if (!(this.mc.f_91077_ instanceof BlockHitResult)) {
            return;
        }
        this.bhr = (BlockHitResult)this.mc.f_91077_;
        if (this.fontRenderer == null) {
            this.fontRenderer = this.mc.f_91062_;
        }
        int renderLeft = screenWidth / 8 * 5;
        int renderTop = screenHeight / 4;
        int tooltipWidth = 3 * (screenWidth / 8);
        if (!this.mc.f_91066_.f_92063_) {
            if (this.mc.f_91073_.m_8055_(this.bhr.m_82425_()).m_60734_().equals(ForgeRegistries.BLOCKS.getValue(new ResourceLocation((String)Config.SALVAGE_BLOCK.get())))) {
                this.lines = new ArrayList<ClientTooltipComponent>(ClientUtils.ctc(LangProvider.SALVAGE_TUTORIAL_HEADER.asComponent().m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.GOLD}), tooltipWidth));
                if (!(!this.mc.f_91074_.m_6047_() || this.mc.f_91074_.m_21205_().m_41619_() && this.mc.f_91074_.m_21206_().m_41619_())) {
                    ItemStack salvageStack = this.mc.f_91074_.m_21205_().m_41619_() ? this.mc.f_91074_.m_21206_() : this.mc.f_91074_.m_21205_();
                    this.gatherSalvageData(salvageStack).forEach(line -> this.lines.addAll(ClientUtils.ctc(line, tooltipWidth)));
                } else {
                    this.lines.addAll(ClientUtils.ctc(LangProvider.SALVAGE_TUTORIAL_USAGE.asComponent(), tooltipWidth));
                }
            } else {
                return;
            }
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            if (!this.lines.isEmpty()) {
                int i = 0;
                int j = this.lines.size() == 1 ? -2 : 0;
                for (ClientTooltipComponent clienttooltipcomponent : this.lines) {
                    int k = clienttooltipcomponent.m_142069_(this.mc.f_91062_);
                    if (k > i) {
                        i = k;
                    }
                    j += clienttooltipcomponent.m_142103_();
                }
                int l = renderLeft;
                int i1 = renderTop;
                guiGraphics.m_280168_().m_85836_();
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder bufferbuilder = tesselator.m_85915_();
                RenderSystem.setShader(GameRenderer::m_172811_);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
                Matrix4f matrix4f = guiGraphics.m_280168_().m_85850_().m_252922_();
                TooltipRenderUtil.m_280205_((GuiGraphics)guiGraphics, (int)l, (int)i1, (int)i, (int)j, (int)400);
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
                guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 400.0f);
                int k1 = i1;
                for (int l1 = 0; l1 < this.lines.size(); ++l1) {
                    ClientTooltipComponent clienttooltipcomponent1 = this.lines.get(l1);
                    clienttooltipcomponent1.m_142440_(this.mc.f_91062_, l, k1, matrix4f, multibuffersource$buffersource);
                    k1 += clienttooltipcomponent1.m_142103_() + (l1 == 0 ? 2 : 0);
                }
                multibuffersource$buffersource.m_109911_();
                k1 = i1;
                for (int i2 = 0; i2 < this.lines.size(); ++i2) {
                    ClientTooltipComponent clienttooltipcomponent2 = this.lines.get(i2);
                    clienttooltipcomponent2.m_183452_(this.mc.f_91062_, l, k1, guiGraphics);
                    k1 += clienttooltipcomponent2.m_142103_() + (i2 == 0 ? 2 : 0);
                }
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    protected static void fillGradient(Matrix4f pMatrix, BufferBuilder pBuilder, int pX1, int pY1, int pX2, int pY2, int pBlitOffset, int pColorA, int pColorB) {
        float f = (float)(pColorA >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(pColorA >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(pColorA >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(pColorA & 0xFF) / 255.0f;
        float f4 = (float)(pColorB >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(pColorB >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(pColorB >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(pColorB & 0xFF) / 255.0f;
        pBuilder.m_252986_(pMatrix, (float)pX2, (float)pY1, (float)pBlitOffset).m_85950_(f1, f2, f3, f).m_5752_();
        pBuilder.m_252986_(pMatrix, (float)pX1, (float)pY1, (float)pBlitOffset).m_85950_(f1, f2, f3, f).m_5752_();
        pBuilder.m_252986_(pMatrix, (float)pX1, (float)pY2, (float)pBlitOffset).m_85950_(f5, f6, f7, f4).m_5752_();
        pBuilder.m_252986_(pMatrix, (float)pX2, (float)pY2, (float)pBlitOffset).m_85950_(f5, f6, f7, f4).m_5752_();
    }

    private List<MutableComponent> gatherSalvageData(ItemStack stack) {
        ArrayList<MutableComponent> outList = new ArrayList<MutableComponent>();
        for (Map.Entry<ResourceLocation, CodecTypes.SalvageData> entry : Core.get((LogicalSide)LogicalSide.CLIENT).getLoader().ITEM_LOADER.getData(RegistryUtil.getId(stack)).salvage().entrySet()) {
            outList.add(MutableComponent.m_237204_((ComponentContents)new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(entry.getKey())).m_41611_().m_214077_()));
            CodecTypes.SalvageData data = entry.getValue();
            if (!data.levelReq().isEmpty()) {
                outList.add(LangProvider.SALVAGE_LEVEL_REQ.asComponent().m_130940_(ChatFormatting.UNDERLINE));
                for (Map.Entry<String, Integer> entry2 : data.levelReq().entrySet()) {
                    outList.add(Component.m_237115_((String)("pmmo." + entry2.getKey())).m_7220_((Component)Component.m_237113_((String)(": " + String.valueOf(entry2.getValue())))));
                }
            }
            outList.add(LangProvider.SALVAGE_CHANCE.asComponent(data.baseChance(), data.maxChance()).m_130940_(ChatFormatting.UNDERLINE));
            outList.add(LangProvider.SALVAGE_MAX.asComponent(data.salvageMax()).m_130940_(ChatFormatting.UNDERLINE));
            if (!data.chancePerLevel().isEmpty()) {
                outList.add(LangProvider.SALVAGE_CHANCE_MOD.asComponent().m_130940_(ChatFormatting.UNDERLINE));
                for (Map.Entry<String, Number> entry3 : data.chancePerLevel().entrySet()) {
                    outList.add(Component.m_237115_((String)("pmmo." + entry3.getKey())).m_7220_((Component)Component.m_237113_((String)(": " + String.valueOf(entry3.getValue())))));
                }
            }
            if (data.xpAward().isEmpty()) continue;
            outList.add(LangProvider.SALVAGE_XP_AWARD.asComponent().m_130940_(ChatFormatting.UNDERLINE));
            for (Map.Entry<String, Number> entry4 : data.xpAward().entrySet()) {
                outList.add(Component.m_237115_((String)("pmmo." + entry4.getKey())).m_7220_((Component)Component.m_237113_((String)(": " + String.valueOf(entry4.getValue())))));
            }
        }
        return outList;
    }
}

