/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.client.gui.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.config.PerksConfig;
import harmonised.pmmo.config.SkillsConfig;
import harmonised.pmmo.config.codecs.SkillData;
import harmonised.pmmo.core.Core;
import harmonised.pmmo.core.IDataStorage;
import harmonised.pmmo.setup.datagen.LangProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.widget.ScrollPanel;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;

public class PlayerStatsComponent
extends AbstractWidget {
    protected static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("pmmo", "textures/gui/player_stats.png");
    protected static final Core core = Core.get(LogicalSide.CLIENT);
    protected Minecraft minecraft;
    private boolean visible;
    private int xOffset;
    private int width;
    private int height;
    private boolean widthTooNarrow;
    private int timesInventoryChanged;
    protected PlayerStatsScroller statsScroller;
    public static final int IMAGE_WIDTH = 147;
    public static final int IMAGE_HEIGHT = 166;
    private static final int OFFSET_X_POSITION = 86;

    public PlayerStatsComponent() {
        super(0, 0, 0, 0, (Component)Component.m_237119_());
    }

    public void init(int width, int height, Minecraft minecraft, boolean widthTooNarrow) {
        this.minecraft = minecraft;
        this.width = width;
        this.height = height;
        this.widthTooNarrow = widthTooNarrow;
        this.timesInventoryChanged = minecraft.f_91074_.m_150109_().m_36072_();
        if (this.visible) {
            this.initVisuals();
        }
    }

    public void tick() {
        if (this.isVisible() && this.timesInventoryChanged != this.minecraft.f_91074_.m_150109_().m_36072_()) {
            this.timesInventoryChanged = this.minecraft.f_91074_.m_150109_().m_36072_();
        }
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isVisible()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_(0.0, 0.0, 120.0);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int i = (this.width - 147) / 2 - this.xOffset;
            int j = (this.height - 166) / 2;
            graphics.m_280218_(TEXTURE_LOCATION, i, j, 0, 0, 147, 166);
            this.statsScroller.m_88315_(graphics, mouseX, mouseY, partialTicks);
            graphics.m_280168_().m_85849_();
        }
    }

    public void initVisuals() {
        this.xOffset = this.widthTooNarrow ? 0 : 86;
        int i = (this.width - 147) / 2 - this.xOffset;
        int j = (this.height - 166) / 2;
        this.statsScroller = new PlayerStatsScroller(Minecraft.m_91087_(), 131, 150, j + 8, i + 8);
        this.statsScroller.populateAbilities(core, this.minecraft);
    }

    public int updateScreenPosition(int x, int y) {
        int i = this.isVisible() && !this.widthTooNarrow ? 177 + (x - y - 200) / 2 : (x - y) / 2;
        return i;
    }

    public void toggleVisibility() {
        this.setVisible(!this.isVisible());
    }

    public boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean visible) {
        if (visible) {
            this.initVisuals();
        }
        this.visible = visible;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (!this.isVisible()) {
            return false;
        }
        return this.statsScroller.m_6375_(pMouseX, pMouseY, pButton) || super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (!this.isVisible()) {
            return false;
        }
        return this.statsScroller.m_6050_(pMouseX, pMouseY, pDelta) || super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.isVisible()) {
            return false;
        }
        return this.statsScroller.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY) || super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @NotNull
    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    protected void m_168797_(NarrationElementOutput pNarrationElementOutput) {
    }

    static class PlayerStatsScroller
    extends ScrollPanel {
        private final List<String> skillsKeys = new ArrayList<String>();
        private final List<StatComponent> abilities = new ArrayList<StatComponent>();

        public PlayerStatsScroller(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left, 1, 6, 0xFFFFFF, 0xFFFFFF, -2011094751, -16777216, -11184811);
        }

        public void populateAbilities(Core core, Minecraft minecraft) {
            IDataStorage dataStorage = core.getData();
            this.skillsKeys.addAll(dataStorage.getXpMap(null).keySet().stream().filter(skill -> SkillsConfig.SKILLS.get().getOrDefault(skill, SkillData.Builder.getDefault()).getShowInList()).toList());
            this.skillsKeys.sort(Comparator.comparingLong(skill -> dataStorage.getXpRaw(null, (String)skill)).reversed());
            for (String skillKey : this.skillsKeys) {
                SkillData skillData = SkillsConfig.SKILLS.get().getOrDefault(skillKey, SkillData.Builder.getDefault());
                this.abilities.add(new StatComponent(minecraft, this.left + 1, this.top, skillKey, skillData));
            }
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int relativeY, Tesselator tess, int mouseX, int mouseY) {
            for (StatComponent component : this.abilities) {
                component.m_264152_(component.m_252754_(), relativeY);
                component.m_88315_(guiGraphics, mouseX, mouseY, Minecraft.m_91087_().getPartialTick());
                relativeY += 24 + this.border;
            }
        }

        protected int getScrollAmount() {
            return 24 + this.border;
        }

        protected int getContentHeight() {
            int height = this.abilities.size() * (24 + this.border);
            if (height < this.bottom - this.top - 1) {
                height = this.bottom - this.top - 1;
            }
            return height;
        }

        @NotNull
        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(@NotNull NarrationElementOutput pNarrationElementOutput) {
        }
    }

    static class StatComponent
    extends ImageButton {
        private final Minecraft minecraft;
        private final String skillName;
        private final SkillData skillData;
        private final Color skillColor;
        private final int skillLevel;
        private final long skillCurrentXP;
        private final long skillXpToNext;
        private static final int BASE_HEIGHT = 24;

        public StatComponent(Minecraft minecraft, int pX, int pY, String skillKey, SkillData skillData) {
            super(pX, pY, 123, 24, 0, 167, 25, TEXTURE_LOCATION, pButton -> {});
            this.minecraft = minecraft;
            this.skillName = Component.m_237115_((String)("pmmo." + skillKey)).getString();
            this.skillData = skillData;
            this.skillColor = new Color(skillData.getColor());
            this.skillCurrentXP = core.getData().getXpRaw(null, skillKey);
            this.skillLevel = core.getData().getLevelFromXP(this.skillCurrentXP);
            this.skillXpToNext = core.getData().getBaseXpForLevel(this.skillLevel + 1) - this.skillCurrentXP;
        }

        public void m_87963_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
            super.m_87963_(graphics, pMouseX, pMouseY, pPartialTick);
            graphics.m_280411_(this.skillData.getIcon(), this.m_252754_() + 3, this.m_252907_() + 3, 18, 18, 0.0f, 0.0f, this.skillData.getIconSize(), this.skillData.getIconSize(), this.skillData.getIconSize(), this.skillData.getIconSize());
            this.renderProgressBar(graphics);
            graphics.m_280488_(this.minecraft.f_91062_, this.skillName, this.m_252754_() + 24, this.m_252907_() + 5, this.skillColor.getRGB());
            graphics.m_280488_(this.minecraft.f_91062_, String.valueOf(this.skillLevel), this.m_252754_() + this.f_93618_ - 5 - this.minecraft.f_91062_.m_92895_(String.valueOf(this.skillLevel)), this.m_252907_() + 5, this.skillColor.getRGB());
            if (this.m_274382_()) {
                this.renderPerkTooltip(this.skillName);
            }
        }

        public void renderProgressBar(GuiGraphics graphics) {
            int renderX = this.m_252754_() + 24;
            int n = this.m_252907_();
            Objects.requireNonNull(this.minecraft.f_91062_);
            int renderY = n + (9 + 6);
            if (this.m_274382_()) {
                MutableComponent text = Component.m_237113_((String)"%s => %s".formatted(this.skillXpToNext, this.skillLevel + 1));
                graphics.m_280430_(this.minecraft.f_91062_, (Component)text, renderX, renderY - 1, this.skillColor.getRGB());
            } else {
                graphics.m_280246_((float)this.skillColor.getRed() / 255.0f, (float)this.skillColor.getGreen() / 255.0f, (float)this.skillColor.getBlue() / 255.0f, (float)this.skillColor.getAlpha() / 255.0f);
                graphics.m_280411_(TEXTURE_LOCATION, renderX, renderY, 94, 5, 0.0f, 217.0f, 102, 5, 256, 256);
                long baseXP = core.getData().getBaseXpForLevel(this.skillLevel);
                long requiredXP = core.getData().getBaseXpForLevel(this.skillLevel + 1);
                float percent = 100.0f / (float)(requiredXP - baseXP);
                int xp = (int)Math.min(Math.floor(percent * (float)(this.skillCurrentXP - baseXP)), 94.0);
                graphics.m_280411_(TEXTURE_LOCATION, renderX, renderY, xp, 5, 0.0f, 223.0f, 102, 5, 256, 256);
                graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }

        public void renderPerkTooltip(String skill) {
            ArrayList holder = new ArrayList();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            ((List)PerksConfig.PERK_SETTINGS.get().getOrDefault(EventType.SKILL_UP, new ArrayList())).stream().filter(nbt -> skill.isEmpty() || !nbt.m_128441_("skill") || LangProvider.skill(nbt.m_128461_("skill")).getString().equals(skill)).forEach(arg_0 -> StatComponent.lambda$renderPerkTooltip$2((Player)player, holder, arg_0));
            this.minecraft.f_91080_.m_257959_(holder);
        }

        private static /* synthetic */ void lambda$renderPerkTooltip$2(Player player, List holder, CompoundTag nbt) {
            ResourceLocation perkID = new ResourceLocation(nbt.m_128461_("perk"));
            nbt.m_128356_("level", nbt.m_128441_("skill") ? (long)Core.get(player.m_9236_()).getData().getPlayerSkillLevel(nbt.m_128461_("skill"), player.m_20148_()) : 0L);
            holder.add(Component.m_237115_((String)("perk." + perkID.m_135827_() + "." + perkID.m_135815_())).m_7532_());
            holder.add(core.getPerkRegistry().getDescription(perkID).m_6881_().m_7532_());
            core.getPerkRegistry().getStatusLines(perkID, player, nbt).stream().map(MutableComponent::m_7532_).forEach(holder::add);
        }
    }
}

