/*
 * Decompiled with CFR 0.152.
 */
package harmonised.pmmo.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import harmonised.pmmo.features.party.PartyUtils;
import harmonised.pmmo.setup.datagen.LangProvider;
import harmonised.pmmo.util.MsLoggy;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;

public class CmdNodeParty {
    private static final String REQUEST_ID = "requestID";

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"party").then(Commands.m_82127_((String)"create").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(CmdNodeParty::partyCreate)))).then(Commands.m_82127_((String)"leave").executes(CmdNodeParty::partyLeave))).then(Commands.m_82127_((String)"invite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(CmdNodeParty::partyInvite)))).then(Commands.m_82127_((String)"uninvite").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(CmdNodeParty::partyUninvite)))).then(Commands.m_82127_((String)"list").executes(CmdNodeParty::listParty))).then(Commands.m_82127_((String)"accept").then(Commands.m_82129_((String)REQUEST_ID, (ArgumentType)UuidArgument.m_113850_()).executes(CmdNodeParty::partyAccept)))).then(Commands.m_82127_((String)"decline").then(Commands.m_82129_((String)REQUEST_ID, (ArgumentType)UuidArgument.m_113850_()).executes(CmdNodeParty::partyDecline)))).executes(c -> {
            System.out.println(PartyUtils.isInParty(((CommandSourceStack)c.getSource()).m_81375_()));
            return 0;
        });
    }

    public static int partyCreate(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
        String name = StringArgumentType.getString(ctx, (String)"name");
        Scoreboard board = player.m_36329_();
        board.m_83492_(name);
        board.m_6546_(player.m_6302_(), board.m_83489_(name));
        ((CommandSourceStack)ctx.getSource()).m_288197_(LangProvider.PARTY_CREATED::asComponent, false);
        return 0;
    }

    public static int partyLeave(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        PlayerTeam team = ((CommandSourceStack)ctx.getSource()).getScoreboard().m_83500_(((CommandSourceStack)ctx.getSource()).m_81375_().m_6302_());
        ((CommandSourceStack)ctx.getSource()).getScoreboard().m_83495_(((CommandSourceStack)ctx.getSource()).m_81375_().m_6302_());
        if (team != null && team.m_6809_().isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).getScoreboard().m_83475_(team);
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(LangProvider.PARTY_LEFT::asComponent, false);
        return 0;
    }

    public static int partyInvite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        if (!PartyUtils.isInParty(((CommandSourceStack)ctx.getSource()).m_81375_())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)LangProvider.PARTY_NOT_IN.asComponent());
            return 1;
        }
        PartyUtils.inviteToParty(((CommandSourceStack)ctx.getSource()).m_81375_(), (Player)player);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_INVITE.asComponent(player.m_5446_()), false);
        return 0;
    }

    public static int partyUninvite(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
        PartyUtils.uninviteToParty(((CommandSourceStack)ctx.getSource()).m_81375_(), (Player)player);
        return 0;
    }

    public static int listParty(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        if (!PartyUtils.isInParty(((CommandSourceStack)ctx.getSource()).m_81375_())) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)LangProvider.PARTY_NOT_IN.asComponent());
            return 1;
        }
        List<String> memberNames = PartyUtils.getPartyMembers(((CommandSourceStack)ctx.getSource()).m_81375_()).stream().map(s -> s.m_7755_().getString()).toList();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_MEMBER_TOTAL.asComponent(memberNames.size()), false);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> LangProvider.PARTY_MEMBER_LIST.asComponent(MsLoggy.listToString(memberNames)), false);
        return 0;
    }

    public static int partyAccept(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        UUID requestID = UuidArgument.m_113853_(ctx, (String)REQUEST_ID);
        PartyUtils.acceptInvite(((CommandSourceStack)ctx.getSource()).m_81375_(), requestID);
        return 0;
    }

    public static int partyDecline(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        UUID requestID = UuidArgument.m_113853_(ctx, (String)REQUEST_ID);
        if (PartyUtils.declineInvite(requestID)) {
            ((CommandSourceStack)ctx.getSource()).m_288197_(LangProvider.PARTY_DECLINE::asComponent, false);
            return 1;
        }
        ((CommandSourceStack)ctx.getSource()).m_288197_(LangProvider.PARTY_NO_INVITES::asComponent, false);
        return 0;
    }
}

